// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A route calculator resource listed in your AWS account.
 */
public class ListRouteCalculatorsResponseEntry private constructor(builder: Builder) {
    /**
     * The name of the route calculator resource.
     */
    public val calculatorName: kotlin.String? = builder.calculatorName
    /**
     * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createTime
    /**
     * The data provider of traffic and road network data. Indicates one of the available providers:
     * + `Esri`
     * + `Here`
     *
     * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
     */
    public val dataSource: kotlin.String? = builder.dataSource
    /**
     * The optional description of the route calculator resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Always returns `RequestBasedUsage`.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = builder.pricingPlan
    /**
     * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
     * + For example, `2020–07-2T12:15:20.000Z+01:00`
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListRouteCalculatorsResponseEntry(")
        append("calculatorName=$calculatorName,")
        append("createTime=$createTime,")
        append("dataSource=$dataSource,")
        append("description=$description,")
        append("pricingPlan=$pricingPlan,")
        append("updateTime=$updateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = calculatorName?.hashCode() ?: 0
        result = 31 * result + (createTime?.hashCode() ?: 0)
        result = 31 * result + (dataSource?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (pricingPlan?.hashCode() ?: 0)
        result = 31 * result + (updateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListRouteCalculatorsResponseEntry

        if (calculatorName != other.calculatorName) return false
        if (createTime != other.createTime) return false
        if (dataSource != other.dataSource) return false
        if (description != other.description) return false
        if (pricingPlan != other.pricingPlan) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the route calculator resource.
         */
        public var calculatorName: kotlin.String? = null
        /**
         * The timestamp when the route calculator resource was created in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The data provider of traffic and road network data. Indicates one of the available providers:
         * + `Esri`
         * + `Here`
         *
         * For more information about data providers, see [Amazon Location Service data providers](https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).
         */
        public var dataSource: kotlin.String? = null
        /**
         * The optional description of the route calculator resource.
         */
        public var description: kotlin.String? = null
        /**
         * Always returns `RequestBasedUsage`.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var pricingPlan: aws.sdk.kotlin.services.location.model.PricingPlan? = null
        /**
         * The timestamp when the route calculator resource was last updated in [ISO 8601](https://www.iso.org/iso-8601-date-and-time-format.html) format: `YYYY-MM-DDThh:mm:ss.sssZ`.
         * + For example, `2020–07-2T12:15:20.000Z+01:00`
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry) : this() {
            this.calculatorName = x.calculatorName
            this.createTime = x.createTime
            this.dataSource = x.dataSource
            this.description = x.description
            this.pricingPlan = x.pricingPlan
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.ListRouteCalculatorsResponseEntry = ListRouteCalculatorsResponseEntry(this)
    }
}
