// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



/**
 * Contains details about addresses or points of interest that match the search criteria.
 *
 * Not all details are included with all responses. Some details may only be returned by specific data partners.
 */
public class Place private constructor(builder: Builder) {
    /**
     * The numerical portion of an address, such as a building number.
     */
    public val addressNumber: kotlin.String? = builder.addressNumber
    /**
     * A country/region specified using [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country/region code. For example, `CAN`.
     */
    public val country: kotlin.String? = builder.country
    /**
     * Places uses a point geometry to specify a location or a Place.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.PlaceGeometry? = builder.geometry
    /**
     * `True` if the result is interpolated from other known places.
     *
     * `False` if the Place is a known place.
     *
     * Not returned when the partner does not provide the information.
     *
     * For example, returns `False` for an address location that is found in the partner data, but returns `True` if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses.
     */
    public val interpolated: kotlin.Boolean? = builder.interpolated
    /**
     * The full name and address of the point of interest such as a city, region, or country. For example, `123 Any Street, Any Town, USA`.
     */
    public val label: kotlin.String? = builder.label
    /**
     * A name for a local area, such as a city or town name. For example, `Toronto`.
     */
    public val municipality: kotlin.String? = builder.municipality
    /**
     * The name of a community district. For example, `Downtown`.
     */
    public val neighborhood: kotlin.String? = builder.neighborhood
    /**
     * A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location.
     */
    public val postalCode: kotlin.String? = builder.postalCode
    /**
     * A name for an area or geographical division, such as a province or state name. For example, `British Columbia`.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The name for a street or a road to identify a location. For example, `Main Street`.
     */
    public val street: kotlin.String? = builder.street
    /**
     * A country, or an area that's part of a larger region. For example, `Metro Vancouver`.
     */
    public val subRegion: kotlin.String? = builder.subRegion
    /**
     * The time zone in which the `Place` is located. Returned only when using Here as the selected partner.
     */
    public val timeZone: aws.sdk.kotlin.services.location.model.TimeZone? = builder.timeZone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.Place = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Place(")
        append("addressNumber=$addressNumber,")
        append("country=$country,")
        append("geometry=$geometry,")
        append("interpolated=$interpolated,")
        append("label=$label,")
        append("municipality=$municipality,")
        append("neighborhood=$neighborhood,")
        append("postalCode=$postalCode,")
        append("region=$region,")
        append("street=$street,")
        append("subRegion=$subRegion,")
        append("timeZone=$timeZone)")
    }

    override fun hashCode(): kotlin.Int {
        var result = addressNumber?.hashCode() ?: 0
        result = 31 * result + (country?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        result = 31 * result + (interpolated?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (municipality?.hashCode() ?: 0)
        result = 31 * result + (neighborhood?.hashCode() ?: 0)
        result = 31 * result + (postalCode?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (street?.hashCode() ?: 0)
        result = 31 * result + (subRegion?.hashCode() ?: 0)
        result = 31 * result + (timeZone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Place

        if (addressNumber != other.addressNumber) return false
        if (country != other.country) return false
        if (geometry != other.geometry) return false
        if (interpolated != other.interpolated) return false
        if (label != other.label) return false
        if (municipality != other.municipality) return false
        if (neighborhood != other.neighborhood) return false
        if (postalCode != other.postalCode) return false
        if (region != other.region) return false
        if (street != other.street) return false
        if (subRegion != other.subRegion) return false
        if (timeZone != other.timeZone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.Place = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The numerical portion of an address, such as a building number.
         */
        public var addressNumber: kotlin.String? = null
        /**
         * A country/region specified using [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country/region code. For example, `CAN`.
         */
        public var country: kotlin.String? = null
        /**
         * Places uses a point geometry to specify a location or a Place.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.PlaceGeometry? = null
        /**
         * `True` if the result is interpolated from other known places.
         *
         * `False` if the Place is a known place.
         *
         * Not returned when the partner does not provide the information.
         *
         * For example, returns `False` for an address location that is found in the partner data, but returns `True` if an address does not exist in the partner data and its location is calculated by interpolating between other known addresses.
         */
        public var interpolated: kotlin.Boolean? = null
        /**
         * The full name and address of the point of interest such as a city, region, or country. For example, `123 Any Street, Any Town, USA`.
         */
        public var label: kotlin.String? = null
        /**
         * A name for a local area, such as a city or town name. For example, `Toronto`.
         */
        public var municipality: kotlin.String? = null
        /**
         * The name of a community district. For example, `Downtown`.
         */
        public var neighborhood: kotlin.String? = null
        /**
         * A group of numbers and letters in a country-specific format, which accompanies the address for the purpose of identifying a location.
         */
        public var postalCode: kotlin.String? = null
        /**
         * A name for an area or geographical division, such as a province or state name. For example, `British Columbia`.
         */
        public var region: kotlin.String? = null
        /**
         * The name for a street or a road to identify a location. For example, `Main Street`.
         */
        public var street: kotlin.String? = null
        /**
         * A country, or an area that's part of a larger region. For example, `Metro Vancouver`.
         */
        public var subRegion: kotlin.String? = null
        /**
         * The time zone in which the `Place` is located. Returned only when using Here as the selected partner.
         */
        public var timeZone: aws.sdk.kotlin.services.location.model.TimeZone? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.Place) : this() {
            this.addressNumber = x.addressNumber
            this.country = x.country
            this.geometry = x.geometry
            this.interpolated = x.interpolated
            this.label = x.label
            this.municipality = x.municipality
            this.neighborhood = x.neighborhood
            this.postalCode = x.postalCode
            this.region = x.region
            this.street = x.street
            this.subRegion = x.subRegion
            this.timeZone = x.timeZone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.Place = Place(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.PlaceGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.PlaceGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.location.model.PlaceGeometry.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.location.model.TimeZone] inside the given [block]
         */
        public fun timeZone(block: aws.sdk.kotlin.services.location.model.TimeZone.Builder.() -> kotlin.Unit) {
            this.timeZone = aws.sdk.kotlin.services.location.model.TimeZone.invoke(block)
        }
    }
}
