// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



public class PutGeofenceRequest private constructor(builder: Builder) {
    /**
     * The geofence collection to store the geofence in.
     */
    public val collectionName: kotlin.String? = requireNotNull(builder.collectionName) { "A non-null value must be provided for collectionName" }
    /**
     * An identifier for the geofence. For example, `ExampleGeofence-1`.
     */
    public val geofenceId: kotlin.String? = requireNotNull(builder.geofenceId) { "A non-null value must be provided for geofenceId" }
    /**
     * Contains the polygon details to specify the position of the geofence.
     *
     * Each [geofence polygon](https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html) can have a maximum of 1,000 vertices.
     */
    public val geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = builder.geometry

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.PutGeofenceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGeofenceRequest(")
        append("collectionName=$collectionName,")
        append("geofenceId=$geofenceId,")
        append("geometry=$geometry)")
    }

    override fun hashCode(): kotlin.Int {
        var result = collectionName?.hashCode() ?: 0
        result = 31 * result + (geofenceId?.hashCode() ?: 0)
        result = 31 * result + (geometry?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGeofenceRequest

        if (collectionName != other.collectionName) return false
        if (geofenceId != other.geofenceId) return false
        if (geometry != other.geometry) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.PutGeofenceRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The geofence collection to store the geofence in.
         */
        public var collectionName: kotlin.String? = null
        /**
         * An identifier for the geofence. For example, `ExampleGeofence-1`.
         */
        public var geofenceId: kotlin.String? = null
        /**
         * Contains the polygon details to specify the position of the geofence.
         *
         * Each [geofence polygon](https://docs.aws.amazon.com/location-geofences/latest/APIReference/API_GeofenceGeometry.html) can have a maximum of 1,000 vertices.
         */
        public var geometry: aws.sdk.kotlin.services.location.model.GeofenceGeometry? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.PutGeofenceRequest) : this() {
            this.collectionName = x.collectionName
            this.geofenceId = x.geofenceId
            this.geometry = x.geometry
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.PutGeofenceRequest = PutGeofenceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.GeofenceGeometry] inside the given [block]
         */
        public fun geometry(block: aws.sdk.kotlin.services.location.model.GeofenceGeometry.Builder.() -> kotlin.Unit) {
            this.geometry = aws.sdk.kotlin.services.location.model.GeofenceGeometry.invoke(block)
        }
    }
}
