// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



/**
 * Contains a search result from a text search query that is run on a place index resource.
 */
public class SearchForTextResult private constructor(builder: Builder) {
    /**
     * The distance in meters of a great-circle arc between the bias position specified and the result. `Distance` will be returned only if a bias position was specified in the query.
     *
     * A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.
     */
    public val distance: kotlin.Double? = builder.distance
    /**
     * Details about the search result, such as its address and position.
     */
    public val place: aws.sdk.kotlin.services.location.model.Place? = builder.place
    /**
     * The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.
     *
     * Returned only when the partner selected is Esri.
     */
    public val relevance: kotlin.Double? = builder.relevance

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchForTextResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchForTextResult(")
        append("distance=$distance,")
        append("place=$place,")
        append("relevance=$relevance)")
    }

    override fun hashCode(): kotlin.Int {
        var result = distance?.hashCode() ?: 0
        result = 31 * result + (place?.hashCode() ?: 0)
        result = 31 * result + (relevance?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchForTextResult

        if (distance != other.distance) return false
        if (place != other.place) return false
        if (relevance != other.relevance) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchForTextResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The distance in meters of a great-circle arc between the bias position specified and the result. `Distance` will be returned only if a bias position was specified in the query.
         *
         * A great-circle arc is the shortest path on a sphere, in this case the Earth. This returns the shortest distance between two locations.
         */
        public var distance: kotlin.Double? = null
        /**
         * Details about the search result, such as its address and position.
         */
        public var place: aws.sdk.kotlin.services.location.model.Place? = null
        /**
         * The relative confidence in the match for a result among the results returned. For example, if more fields for an address match (including house number, street, city, country/region, and postal code), the relevance score is closer to 1.
         *
         * Returned only when the partner selected is Esri.
         */
        public var relevance: kotlin.Double? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchForTextResult) : this() {
            this.distance = x.distance
            this.place = x.place
            this.relevance = x.relevance
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchForTextResult = SearchForTextResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.location.model.Place] inside the given [block]
         */
        public fun place(block: aws.sdk.kotlin.services.location.model.Place.Builder.() -> kotlin.Unit) {
            this.place = aws.sdk.kotlin.services.location.model.Place.invoke(block)
        }
    }
}
