// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.model



public class SearchPlaceIndexForSuggestionsRequest private constructor(builder: Builder) {
    /**
     * An optional parameter that indicates a preference for place suggestions that are closer to a specified position.
     *
     *  If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
     *
     * For example, `[-123.1174, 49.2847]` represents the position with longitude `-123.1174` and latitude `49.2847`.
     *
     * `BiasPosition` and `FilterBBox` are mutually exclusive. Specifying both options results in an error.
     */
    public val biasPosition: List<Double>? = builder.biasPosition
    /**
     * An optional parameter that limits the search results by returning only suggestions within a specified bounding box.
     *
     *  If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.
     *
     * For example, `[-12.7935, -37.4835, -12.0684, -36.9542]` represents a bounding box where the southwest corner has longitude `-12.7935` and latitude `-37.4835`, and the northeast corner has longitude `-12.0684` and latitude `-36.9542`.
     *
     * `FilterBBox` and `BiasPosition` are mutually exclusive. Specifying both options results in an error.
     */
    public val filterBBox: List<Double>? = builder.filterBBox
    /**
     * An optional parameter that limits the search results by returning only suggestions within the provided list of countries.
     * + Use the [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country code. For example, Australia uses three upper-case characters: `AUS`.
     */
    public val filterCountries: List<String>? = builder.filterCountries
    /**
     * The name of the place index resource you want to use for the search.
     */
    public val indexName: kotlin.String? = requireNotNull(builder.indexName) { "A non-null value must be provided for indexName" }
    /**
     * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
     *
     * This setting affects the languages used in the results. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
     *
     * For an example, we'll use the Greek language. You search for `Athens, Gr` to get suggestions with the `language` parameter set to `en`. The results found will most likely be returned as `Athens, Greece`.
     *
     * If you set the `language` parameter to `el`, for Greek, then the result found will more likely be returned as `Αθήνα, Ελλάδα`.
     *
     * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
     */
    public val language: kotlin.String? = builder.language
    /**
     * An optional parameter. The maximum number of results returned per request.
     *
     * The default: `5`
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The free-form partial text to use to generate place suggestions. For example, `eiffel tow`.
     */
    public val text: kotlin.String? = builder.text

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SearchPlaceIndexForSuggestionsRequest(")
        append("biasPosition=*** Sensitive Data Redacted ***,")
        append("filterBBox=*** Sensitive Data Redacted ***,")
        append("filterCountries=$filterCountries,")
        append("indexName=$indexName,")
        append("language=$language,")
        append("maxResults=$maxResults,")
        append("text=*** Sensitive Data Redacted ***)")
    }

    override fun hashCode(): kotlin.Int {
        var result = biasPosition?.hashCode() ?: 0
        result = 31 * result + (filterBBox?.hashCode() ?: 0)
        result = 31 * result + (filterCountries?.hashCode() ?: 0)
        result = 31 * result + (indexName?.hashCode() ?: 0)
        result = 31 * result + (language?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (text?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SearchPlaceIndexForSuggestionsRequest

        if (biasPosition != other.biasPosition) return false
        if (filterBBox != other.filterBBox) return false
        if (filterCountries != other.filterCountries) return false
        if (indexName != other.indexName) return false
        if (language != other.language) return false
        if (maxResults != other.maxResults) return false
        if (text != other.text) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An optional parameter that indicates a preference for place suggestions that are closer to a specified position.
         *
         *  If provided, this parameter must contain a pair of numbers. The first number represents the X coordinate, or longitude; the second number represents the Y coordinate, or latitude.
         *
         * For example, `[-123.1174, 49.2847]` represents the position with longitude `-123.1174` and latitude `49.2847`.
         *
         * `BiasPosition` and `FilterBBox` are mutually exclusive. Specifying both options results in an error.
         */
        public var biasPosition: List<Double>? = null
        /**
         * An optional parameter that limits the search results by returning only suggestions within a specified bounding box.
         *
         *  If provided, this parameter must contain a total of four consecutive numbers in two pairs. The first pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the southwest corner of the bounding box; the second pair of numbers represents the X and Y coordinates (longitude and latitude, respectively) of the northeast corner of the bounding box.
         *
         * For example, `[-12.7935, -37.4835, -12.0684, -36.9542]` represents a bounding box where the southwest corner has longitude `-12.7935` and latitude `-37.4835`, and the northeast corner has longitude `-12.0684` and latitude `-36.9542`.
         *
         * `FilterBBox` and `BiasPosition` are mutually exclusive. Specifying both options results in an error.
         */
        public var filterBBox: List<Double>? = null
        /**
         * An optional parameter that limits the search results by returning only suggestions within the provided list of countries.
         * + Use the [ISO 3166](https://www.iso.org/iso-3166-country-codes.html) 3-digit country code. For example, Australia uses three upper-case characters: `AUS`.
         */
        public var filterCountries: List<String>? = null
        /**
         * The name of the place index resource you want to use for the search.
         */
        public var indexName: kotlin.String? = null
        /**
         * The preferred language used to return results. The value must be a valid [BCP 47](https://tools.ietf.org/search/bcp47) language tag, for example, `en` for English.
         *
         * This setting affects the languages used in the results. If no language is specified, or not supported for a particular result, the partner automatically chooses a language for the result.
         *
         * For an example, we'll use the Greek language. You search for `Athens, Gr` to get suggestions with the `language` parameter set to `en`. The results found will most likely be returned as `Athens, Greece`.
         *
         * If you set the `language` parameter to `el`, for Greek, then the result found will more likely be returned as `Αθήνα, Ελλάδα`.
         *
         * If the data provider does not have a value for Greek, the result will be in a language that the provider does support.
         */
        public var language: kotlin.String? = null
        /**
         * An optional parameter. The maximum number of results returned per request.
         *
         * The default: `5`
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The free-form partial text to use to generate place suggestions. For example, `eiffel tow`.
         */
        public var text: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest) : this() {
            this.biasPosition = x.biasPosition
            this.filterBBox = x.filterBBox
            this.filterCountries = x.filterCountries
            this.indexName = x.indexName
            this.language = x.language
            this.maxResults = x.maxResults
            this.text = x.text
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest = SearchPlaceIndexForSuggestionsRequest(this)
    }
}
