// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.services.location.model.BatchEvaluateGeofencesRequest
import aws.sdk.kotlin.services.location.model.DevicePositionUpdate
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchEvaluateGeofencesOperationSerializer: HttpSerialize<BatchEvaluateGeofencesRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchEvaluateGeofencesRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "geofencing",
                "v0",
                "collections",
                "${input.collectionName}".encodeLabel(),
                "positions",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeBatchEvaluateGeofencesOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchEvaluateGeofencesOperationBody(context: ExecutionContext, input: BatchEvaluateGeofencesRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEVICEPOSITIONUPDATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DevicePositionUpdates"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICEPOSITIONUPDATES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.devicePositionUpdates != null) {
            listField(DEVICEPOSITIONUPDATES_DESCRIPTOR) {
                for (el0 in input.devicePositionUpdates) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeDevicePositionUpdateDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
