// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.location.model.BatchGetDevicePositionError
import aws.sdk.kotlin.services.location.model.BatchGetDevicePositionResponse
import aws.sdk.kotlin.services.location.model.DevicePosition
import aws.sdk.kotlin.services.location.model.LocationException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchGetDevicePositionOperationDeserializer: HttpDeserialize<BatchGetDevicePositionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): BatchGetDevicePositionResponse {
        if (!response.status.isSuccess()) {
            throwBatchGetDevicePositionError(context, response)
        }
        val builder = BatchGetDevicePositionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeBatchGetDevicePositionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwBatchGetDevicePositionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchGetDevicePositionOperationBody(builder: BatchGetDevicePositionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DEVICEPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DevicePositions"))
    val ERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Errors"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEVICEPOSITIONS_DESCRIPTOR)
        field(ERRORS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DEVICEPOSITIONS_DESCRIPTOR.index -> builder.devicePositions =
                    deserializer.deserializeList(DEVICEPOSITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<DevicePosition>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDevicePositionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORS_DESCRIPTOR.index -> builder.errors =
                    deserializer.deserializeList(ERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchGetDevicePositionError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchGetDevicePositionErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
