// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequest
import aws.sdk.kotlin.services.location.model.BatchPutGeofenceRequestEntry
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class BatchPutGeofenceOperationSerializer: HttpSerialize<BatchPutGeofenceRequest> {
    override suspend fun serialize(context: ExecutionContext, input: BatchPutGeofenceRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "geofencing",
                "v0",
                "collections",
                "${input.collectionName}".encodeLabel(),
                "put-geofences",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeBatchPutGeofenceOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeBatchPutGeofenceOperationBody(context: ExecutionContext, input: BatchPutGeofenceRequest): ByteArray {
    val serializer = JsonSerializer()
    val ENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Entries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENTRIES_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.entries != null) {
            listField(ENTRIES_DESCRIPTOR) {
                for (el0 in input.entries) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeBatchPutGeofenceRequestEntryDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
