// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixResponse
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixSummary
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.RouteMatrixEntry
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CalculateRouteMatrixOperationDeserializer: HttpDeserialize<CalculateRouteMatrixResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CalculateRouteMatrixResponse {
        if (!response.status.isSuccess()) {
            throwCalculateRouteMatrixError(context, response)
        }
        val builder = CalculateRouteMatrixResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCalculateRouteMatrixOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwCalculateRouteMatrixError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCalculateRouteMatrixOperationBody(builder: CalculateRouteMatrixResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ROUTEMATRIX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("RouteMatrix"))
    val ROUTEMATRIX_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SNAPPEDDEPARTUREPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SnappedDeparturePositions"))
    val SNAPPEDDEPARTUREPOSITIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SNAPPEDDESTINATIONPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SnappedDestinationPositions"))
    val SNAPPEDDESTINATIONPOSITIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Summary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ROUTEMATRIX_DESCRIPTOR)
        field(SNAPPEDDEPARTUREPOSITIONS_DESCRIPTOR)
        field(SNAPPEDDESTINATIONPOSITIONS_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ROUTEMATRIX_DESCRIPTOR.index -> builder.routeMatrix =
                    deserializer.deserializeList(ROUTEMATRIX_DESCRIPTOR) {
                        val col0 = mutableListOf<List<RouteMatrixEntry>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(ROUTEMATRIX_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<RouteMatrixEntry>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeRouteMatrixEntryDocument(deserializer) } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                SNAPPEDDEPARTUREPOSITIONS_DESCRIPTOR.index -> builder.snappedDeparturePositions =
                    deserializer.deserializeList(SNAPPEDDEPARTUREPOSITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<Double>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(SNAPPEDDEPARTUREPOSITIONS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<Double>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeDouble() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                SNAPPEDDESTINATIONPOSITIONS_DESCRIPTOR.index -> builder.snappedDestinationPositions =
                    deserializer.deserializeList(SNAPPEDDESTINATIONPOSITIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<List<Double>>()
                        while (hasNextElement()) {
                            val el0 = deserializer.deserializeList(SNAPPEDDESTINATIONPOSITIONS_C0_DESCRIPTOR) {
                                val col1 = mutableListOf<Double>()
                                while (hasNextElement()) {
                                    val el1 = if (nextHasValue()) { deserializeDouble() } else { deserializeNull(); continue }
                                    col1.add(el1)
                                }
                                col1
                            }
                            col0.add(el0)
                        }
                        col0
                    }
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeCalculateRouteMatrixSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
