// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions
import aws.sdk.kotlin.services.location.model.CalculateRouteMatrixRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions
import aws.sdk.kotlin.services.location.model.DistanceUnit
import aws.sdk.kotlin.services.location.model.TravelMode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CalculateRouteMatrixOperationSerializer: HttpSerialize<CalculateRouteMatrixRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CalculateRouteMatrixRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "routes",
                "v0",
                "calculators",
                "${input.calculatorName}".encodeLabel(),
                "calculate",
                "route-matrix",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCalculateRouteMatrixOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCalculateRouteMatrixOperationBody(context: ExecutionContext, input: CalculateRouteMatrixRequest): ByteArray {
    val serializer = JsonSerializer()
    val CARMODEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CarModeOptions"))
    val DEPARTNOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DepartNow"))
    val DEPARTUREPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DeparturePositions"))
    val DEPARTUREPOSITIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val DEPARTURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DepartureTime"))
    val DESTINATIONPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DestinationPositions"))
    val DESTINATIONPOSITIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DistanceUnit"))
    val TRAVELMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TravelMode"))
    val TRUCKMODEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TruckModeOptions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CARMODEOPTIONS_DESCRIPTOR)
        field(DEPARTNOW_DESCRIPTOR)
        field(DEPARTUREPOSITIONS_DESCRIPTOR)
        field(DEPARTURETIME_DESCRIPTOR)
        field(DESTINATIONPOSITIONS_DESCRIPTOR)
        field(DISTANCEUNIT_DESCRIPTOR)
        field(TRAVELMODE_DESCRIPTOR)
        field(TRUCKMODEOPTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.carModeOptions?.let { field(CARMODEOPTIONS_DESCRIPTOR, it, ::serializeCalculateRouteCarModeOptionsDocument) }
        input.departNow?.let { field(DEPARTNOW_DESCRIPTOR, it) }
        if (input.departurePositions != null) {
            listField(DEPARTUREPOSITIONS_DESCRIPTOR) {
                for (el0 in input.departurePositions) {
                    serializer.serializeList(DEPARTUREPOSITIONS_C0_DESCRIPTOR) {
                        for (el1 in el0) {
                            serializeDouble(el1)
                        }
                    }
                }
            }
        }
        input.departureTime?.let { field(DEPARTURETIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.destinationPositions != null) {
            listField(DESTINATIONPOSITIONS_DESCRIPTOR) {
                for (el0 in input.destinationPositions) {
                    serializer.serializeList(DESTINATIONPOSITIONS_C0_DESCRIPTOR) {
                        for (el1 in el0) {
                            serializeDouble(el1)
                        }
                    }
                }
            }
        }
        input.distanceUnit?.let { field(DISTANCEUNIT_DESCRIPTOR, it.value) }
        input.travelMode?.let { field(TRAVELMODE_DESCRIPTOR, it.value) }
        input.truckModeOptions?.let { field(TRUCKMODEOPTIONS_DESCRIPTOR, it, ::serializeCalculateRouteTruckModeOptionsDocument) }
    }
    return serializer.toByteArray()
}
