// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.services.location.model.CalculateRouteCarModeOptions
import aws.sdk.kotlin.services.location.model.CalculateRouteRequest
import aws.sdk.kotlin.services.location.model.CalculateRouteTruckModeOptions
import aws.sdk.kotlin.services.location.model.DistanceUnit
import aws.sdk.kotlin.services.location.model.TravelMode
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class CalculateRouteOperationSerializer: HttpSerialize<CalculateRouteRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CalculateRouteRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "routes",
                "v0",
                "calculators",
                "${input.calculatorName}".encodeLabel(),
                "calculate",
                "route",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCalculateRouteOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCalculateRouteOperationBody(context: ExecutionContext, input: CalculateRouteRequest): ByteArray {
    val serializer = JsonSerializer()
    val CARMODEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CarModeOptions"))
    val DEPARTNOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("DepartNow"))
    val DEPARTUREPOSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DeparturePosition"))
    val DEPARTURETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("DepartureTime"))
    val DESTINATIONPOSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("DestinationPosition"))
    val DISTANCEUNIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DistanceUnit"))
    val INCLUDELEGGEOMETRY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeLegGeometry"))
    val TRAVELMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("TravelMode"))
    val TRUCKMODEOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("TruckModeOptions"))
    val WAYPOINTPOSITIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("WaypointPositions"))
    val WAYPOINTPOSITIONS_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CARMODEOPTIONS_DESCRIPTOR)
        field(DEPARTNOW_DESCRIPTOR)
        field(DEPARTUREPOSITION_DESCRIPTOR)
        field(DEPARTURETIME_DESCRIPTOR)
        field(DESTINATIONPOSITION_DESCRIPTOR)
        field(DISTANCEUNIT_DESCRIPTOR)
        field(INCLUDELEGGEOMETRY_DESCRIPTOR)
        field(TRAVELMODE_DESCRIPTOR)
        field(TRUCKMODEOPTIONS_DESCRIPTOR)
        field(WAYPOINTPOSITIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.carModeOptions?.let { field(CARMODEOPTIONS_DESCRIPTOR, it, ::serializeCalculateRouteCarModeOptionsDocument) }
        input.departNow?.let { field(DEPARTNOW_DESCRIPTOR, it) }
        if (input.departurePosition != null) {
            listField(DEPARTUREPOSITION_DESCRIPTOR) {
                for (el0 in input.departurePosition) {
                    serializeDouble(el0)
                }
            }
        }
        input.departureTime?.let { field(DEPARTURETIME_DESCRIPTOR, it, TimestampFormat.ISO_8601) }
        if (input.destinationPosition != null) {
            listField(DESTINATIONPOSITION_DESCRIPTOR) {
                for (el0 in input.destinationPosition) {
                    serializeDouble(el0)
                }
            }
        }
        input.distanceUnit?.let { field(DISTANCEUNIT_DESCRIPTOR, it.value) }
        input.includeLegGeometry?.let { field(INCLUDELEGGEOMETRY_DESCRIPTOR, it) }
        input.travelMode?.let { field(TRAVELMODE_DESCRIPTOR, it.value) }
        input.truckModeOptions?.let { field(TRUCKMODEOPTIONS_DESCRIPTOR, it, ::serializeCalculateRouteTruckModeOptionsDocument) }
        if (input.waypointPositions != null) {
            listField(WAYPOINTPOSITIONS_DESCRIPTOR) {
                for (el0 in input.waypointPositions) {
                    serializer.serializeList(WAYPOINTPOSITIONS_C0_DESCRIPTOR) {
                        for (el1 in el0) {
                            serializeDouble(el1)
                        }
                    }
                }
            }
        }
    }
    return serializer.toByteArray()
}
