// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.location.model.GetDevicePositionResponse
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.PositionalAccuracy
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class GetDevicePositionOperationDeserializer: HttpDeserialize<GetDevicePositionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetDevicePositionResponse {
        if (!response.status.isSuccess()) {
            throwGetDevicePositionError(context, response)
        }
        val builder = GetDevicePositionResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetDevicePositionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetDevicePositionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetDevicePositionOperationBody(builder: GetDevicePositionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCURACY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Accuracy"))
    val DEVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeviceId"))
    val POSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Position"))
    val POSITIONPROPERTIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PositionProperties"))
    val RECEIVEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ReceivedTime"))
    val SAMPLETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("SampleTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCURACY_DESCRIPTOR)
        field(DEVICEID_DESCRIPTOR)
        field(POSITION_DESCRIPTOR)
        field(POSITIONPROPERTIES_DESCRIPTOR)
        field(RECEIVEDTIME_DESCRIPTOR)
        field(SAMPLETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCURACY_DESCRIPTOR.index -> builder.accuracy = deserializePositionalAccuracyDocument(deserializer)
                DEVICEID_DESCRIPTOR.index -> builder.deviceId = deserializeString()
                POSITION_DESCRIPTOR.index -> builder.position =
                    deserializer.deserializeList(POSITION_DESCRIPTOR) {
                        val col0 = mutableListOf<Double>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDouble() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                POSITIONPROPERTIES_DESCRIPTOR.index -> builder.positionProperties =
                    deserializer.deserializeMap(POSITIONPROPERTIES_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RECEIVEDTIME_DESCRIPTOR.index -> builder.receivedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                SAMPLETIME_DESCRIPTOR.index -> builder.sampleTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
