// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForSuggestionsRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchPlaceIndexForSuggestionsOperationSerializer: HttpSerialize<SearchPlaceIndexForSuggestionsRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SearchPlaceIndexForSuggestionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "places",
                "v0",
                "indexes",
                "${input.indexName}".encodeLabel(),
                "search",
                "suggestions",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeSearchPlaceIndexForSuggestionsOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchPlaceIndexForSuggestionsOperationBody(context: ExecutionContext, input: SearchPlaceIndexForSuggestionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val BIASPOSITION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("BiasPosition"))
    val FILTERBBOX_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FilterBBox"))
    val FILTERCOUNTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FilterCountries"))
    val LANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Language"))
    val MAXRESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("MaxResults"))
    val TEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Text"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BIASPOSITION_DESCRIPTOR)
        field(FILTERBBOX_DESCRIPTOR)
        field(FILTERCOUNTRIES_DESCRIPTOR)
        field(LANGUAGE_DESCRIPTOR)
        field(MAXRESULTS_DESCRIPTOR)
        field(TEXT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.biasPosition != null) {
            listField(BIASPOSITION_DESCRIPTOR) {
                for (el0 in input.biasPosition) {
                    serializeDouble(el0)
                }
            }
        }
        if (input.filterBBox != null) {
            listField(FILTERBBOX_DESCRIPTOR) {
                for (el0 in input.filterBBox) {
                    serializeDouble(el0)
                }
            }
        }
        if (input.filterCountries != null) {
            listField(FILTERCOUNTRIES_DESCRIPTOR) {
                for (el0 in input.filterCountries) {
                    serializeString(el0)
                }
            }
        }
        input.language?.let { field(LANGUAGE_DESCRIPTOR, it) }
        input.maxResults?.let { field(MAXRESULTS_DESCRIPTOR, it) }
        input.text?.let { field(TEXT_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
