// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.SearchForTextResult
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextResponse
import aws.sdk.kotlin.services.location.model.SearchPlaceIndexForTextSummary
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SearchPlaceIndexForTextOperationDeserializer: HttpDeserialize<SearchPlaceIndexForTextResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): SearchPlaceIndexForTextResponse {
        if (!response.status.isSuccess()) {
            throwSearchPlaceIndexForTextError(context, response)
        }
        val builder = SearchPlaceIndexForTextResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSearchPlaceIndexForTextOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwSearchPlaceIndexForTextError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSearchPlaceIndexForTextOperationBody(builder: SearchPlaceIndexForTextResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESULTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Results"))
    val SUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Summary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESULTS_DESCRIPTOR)
        field(SUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESULTS_DESCRIPTOR.index -> builder.results =
                    deserializer.deserializeList(RESULTS_DESCRIPTOR) {
                        val col0 = mutableListOf<SearchForTextResult>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeSearchForTextResultDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUMMARY_DESCRIPTOR.index -> builder.summary = deserializeSearchPlaceIndexForTextSummaryDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
