// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.location.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.location.model.LocationException
import aws.sdk.kotlin.services.location.model.UpdateRouteCalculatorResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class UpdateRouteCalculatorOperationDeserializer: HttpDeserialize<UpdateRouteCalculatorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateRouteCalculatorResponse {
        if (!response.status.isSuccess()) {
            throwUpdateRouteCalculatorError(context, response)
        }
        val builder = UpdateRouteCalculatorResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRouteCalculatorOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRouteCalculatorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw LocationException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> LocationException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRouteCalculatorOperationBody(builder: UpdateRouteCalculatorResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CALCULATORARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CalculatorArn"))
    val CALCULATORNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CalculatorName"))
    val UPDATETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("UpdateTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CALCULATORARN_DESCRIPTOR)
        field(CALCULATORNAME_DESCRIPTOR)
        field(UPDATETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CALCULATORARN_DESCRIPTOR.index -> builder.calculatorArn = deserializeString()
                CALCULATORNAME_DESCRIPTOR.index -> builder.calculatorName = deserializeString()
                UPDATETIME_DESCRIPTOR.index -> builder.updateTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
