// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.machinelearning.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.machinelearning.endpoints.EndpointProvider
import aws.sdk.kotlin.services.machinelearning.model.*
import aws.sdk.kotlin.services.machinelearning.model.AddTagsRequest
import aws.sdk.kotlin.services.machinelearning.model.AddTagsResponse
import aws.sdk.kotlin.services.machinelearning.model.CreateBatchPredictionRequest
import aws.sdk.kotlin.services.machinelearning.model.CreateBatchPredictionResponse
import aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRdsRequest
import aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRdsResponse
import aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRedshiftRequest
import aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRedshiftResponse
import aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromS3Request
import aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromS3Response
import aws.sdk.kotlin.services.machinelearning.model.CreateEvaluationRequest
import aws.sdk.kotlin.services.machinelearning.model.CreateEvaluationResponse
import aws.sdk.kotlin.services.machinelearning.model.CreateMlModelRequest
import aws.sdk.kotlin.services.machinelearning.model.CreateMlModelResponse
import aws.sdk.kotlin.services.machinelearning.model.CreateRealtimeEndpointRequest
import aws.sdk.kotlin.services.machinelearning.model.CreateRealtimeEndpointResponse
import aws.sdk.kotlin.services.machinelearning.model.DeleteBatchPredictionRequest
import aws.sdk.kotlin.services.machinelearning.model.DeleteBatchPredictionResponse
import aws.sdk.kotlin.services.machinelearning.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.machinelearning.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.machinelearning.model.DeleteEvaluationRequest
import aws.sdk.kotlin.services.machinelearning.model.DeleteEvaluationResponse
import aws.sdk.kotlin.services.machinelearning.model.DeleteMlModelRequest
import aws.sdk.kotlin.services.machinelearning.model.DeleteMlModelResponse
import aws.sdk.kotlin.services.machinelearning.model.DeleteRealtimeEndpointRequest
import aws.sdk.kotlin.services.machinelearning.model.DeleteRealtimeEndpointResponse
import aws.sdk.kotlin.services.machinelearning.model.DeleteTagsRequest
import aws.sdk.kotlin.services.machinelearning.model.DeleteTagsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeTagsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeTagsResponse
import aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionRequest
import aws.sdk.kotlin.services.machinelearning.model.GetBatchPredictionResponse
import aws.sdk.kotlin.services.machinelearning.model.GetDataSourceRequest
import aws.sdk.kotlin.services.machinelearning.model.GetDataSourceResponse
import aws.sdk.kotlin.services.machinelearning.model.GetEvaluationRequest
import aws.sdk.kotlin.services.machinelearning.model.GetEvaluationResponse
import aws.sdk.kotlin.services.machinelearning.model.GetMlModelRequest
import aws.sdk.kotlin.services.machinelearning.model.GetMlModelResponse
import aws.sdk.kotlin.services.machinelearning.model.PredictRequest
import aws.sdk.kotlin.services.machinelearning.model.PredictResponse
import aws.sdk.kotlin.services.machinelearning.model.UpdateBatchPredictionRequest
import aws.sdk.kotlin.services.machinelearning.model.UpdateBatchPredictionResponse
import aws.sdk.kotlin.services.machinelearning.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.machinelearning.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.machinelearning.model.UpdateEvaluationRequest
import aws.sdk.kotlin.services.machinelearning.model.UpdateEvaluationResponse
import aws.sdk.kotlin.services.machinelearning.model.UpdateMlModelRequest
import aws.sdk.kotlin.services.machinelearning.model.UpdateMlModelResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Definition of the public APIs exposed by Amazon Machine Learning
 */
public interface MachineLearningClient : SdkClient {

    override val serviceName: String
        get() = "Machine Learning"
    /**
     * MachineLearningClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): MachineLearningClient {
            val config = Config.Builder().apply(block).build()
            return DefaultMachineLearningClient(config)
        }

        public operator fun invoke(config: Config): MachineLearningClient = DefaultMachineLearningClient(config)

        /**
         * Construct a [MachineLearningClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): MachineLearningClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMachineLearningClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Machine Learning")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, `AddTags` updates the tag's value.
     */
    public suspend fun addTags(input: AddTagsRequest): AddTagsResponse

    /**
     * Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a `DataSource`. This operation creates a new `BatchPrediction`, and uses an `MLModel` and the data files referenced by the `DataSource` as information sources.
     *
     * `CreateBatchPrediction` is an asynchronous operation. In response to `CreateBatchPrediction`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `BatchPrediction` status to `PENDING`. After the `BatchPrediction` completes, Amazon ML sets the status to `COMPLETED`.
     *
     * You can poll for status updates by using the GetBatchPrediction operation and checking the `Status` parameter of the result. After the `COMPLETED` status appears, the results are available in the location specified by the `OutputUri` parameter.
     */
    public suspend fun createBatchPrediction(input: CreateBatchPredictionRequest): CreateBatchPredictionResponse

    /**
     * Creates a `DataSource` object from an [ Amazon Relational Database Service](http://aws.amazon.com/rds/) (Amazon RDS). A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromRDS` is an asynchronous operation. In response to `CreateDataSourceFromRDS`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used only to perform `>CreateMLModel`>, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML cannot accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     */
    public suspend fun createDataSourceFromRds(input: CreateDataSourceFromRdsRequest): CreateDataSourceFromRdsResponse

    /**
     * Creates a `DataSource` from a database hosted on an Amazon Redshift cluster. A `DataSource` references data that can be used to perform either `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromRedshift` is an asynchronous operation. In response to `CreateDataSourceFromRedshift`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in `COMPLETED` or `PENDING` states can be used to perform only `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     *
     * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a `SelectSqlQuery` query. Amazon ML executes an `Unload` command in Amazon Redshift to transfer the result set of the `SelectSqlQuery` query to `S3StagingLocation`.
     *
     * After the `DataSource` has been created, it's ready for use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also requires a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
     *
     * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call `GetDataSource` for an existing datasource and copy the values to a `CreateDataSource` call. Change the settings that you want to change and make sure that all required fields have the appropriate values.
     */
    public suspend fun createDataSourceFromRedshift(input: CreateDataSourceFromRedshiftRequest): CreateDataSourceFromRedshiftResponse

    /**
     * Creates a `DataSource` object. A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
     *
     * `CreateDataSourceFromS3` is an asynchronous operation. In response to `CreateDataSourceFromS3`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` has been created and is ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used to perform only `CreateMLModel`, `CreateEvaluation` or `CreateBatchPrediction` operations.
     *
     *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
     *
     * The observation data used in a `DataSource` should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the `DataSource`.
     *
     * After the `DataSource` has been created, it's ready to use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also needs a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
     */
    public suspend fun createDataSourceFromS3(input: CreateDataSourceFromS3Request): CreateDataSourceFromS3Response

    /**
     * Creates a new `Evaluation` of an `MLModel`. An `MLModel` is evaluated on a set of observations associated to a `DataSource`. Like a `DataSource` for an `MLModel`, the `DataSource` for an `Evaluation` contains values for the `Target Variable`. The `Evaluation` compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the `MLModel` functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding `MLModelType`: `BINARY`, `REGRESSION` or `MULTICLASS`.
     *
     * `CreateEvaluation` is an asynchronous operation. In response to `CreateEvaluation`, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to `PENDING`. After the `Evaluation` is created and ready for use, Amazon ML sets the status to `COMPLETED`.
     *
     * You can use the `GetEvaluation` operation to check progress of the evaluation during the creation operation.
     */
    public suspend fun createEvaluation(input: CreateEvaluationRequest): CreateEvaluationResponse

    /**
     * Creates a new `MLModel` using the `DataSource` and the recipe as information sources.
     *
     * An `MLModel` is nearly immutable. Users can update only the `MLModelName` and the `ScoreThreshold` in an `MLModel` without creating a new `MLModel`.
     *
     * `CreateMLModel` is an asynchronous operation. In response to `CreateMLModel`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `MLModel` status to `PENDING`. After the `MLModel` has been created and ready is for use, Amazon ML sets the status to `COMPLETED`.
     *
     * You can use the `GetMLModel` operation to check the progress of the `MLModel` during the creation operation.
     *
     * `CreateMLModel` requires a `DataSource` with computed statistics, which can be created by setting `ComputeStatistics` to `true` in `CreateDataSourceFromRDS`, `CreateDataSourceFromS3`, or `CreateDataSourceFromRedshift` operations.
     */
    public suspend fun createMlModel(input: CreateMlModelRequest): CreateMlModelResponse

    /**
     * Creates a real-time endpoint for the `MLModel`. The endpoint contains the URI of the `MLModel`; that is, the location to send real-time prediction requests for the specified `MLModel`.
     */
    public suspend fun createRealtimeEndpoint(input: CreateRealtimeEndpointRequest): CreateRealtimeEndpointResponse

    /**
     * Assigns the DELETED status to a `BatchPrediction`, rendering it unusable.
     *
     * After using the `DeleteBatchPrediction` operation, you can use the GetBatchPrediction operation to verify that the status of the `BatchPrediction` changed to DELETED.
     *
     * **Caution:** The result of the `DeleteBatchPrediction` operation is irreversible.
     */
    public suspend fun deleteBatchPrediction(input: DeleteBatchPredictionRequest): DeleteBatchPredictionResponse

    /**
     * Assigns the DELETED status to a `DataSource`, rendering it unusable.
     *
     * After using the `DeleteDataSource` operation, you can use the GetDataSource operation to verify that the status of the `DataSource` changed to DELETED.
     *
     * **Caution:** The results of the `DeleteDataSource` operation are irreversible.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Assigns the `DELETED` status to an `Evaluation`, rendering it unusable.
     *
     * After invoking the `DeleteEvaluation` operation, you can use the `GetEvaluation` operation to verify that the status of the `Evaluation` changed to `DELETED`.
     *
     * **Caution:** The results of the `DeleteEvaluation` operation are irreversible.
     */
    public suspend fun deleteEvaluation(input: DeleteEvaluationRequest): DeleteEvaluationResponse

    /**
     * Assigns the `DELETED` status to an `MLModel`, rendering it unusable.
     *
     * After using the `DeleteMLModel` operation, you can use the `GetMLModel` operation to verify that the status of the `MLModel` changed to DELETED.
     *
     * **Caution:** The result of the `DeleteMLModel` operation is irreversible.
     */
    public suspend fun deleteMlModel(input: DeleteMlModelRequest): DeleteMlModelResponse

    /**
     * Deletes a real time endpoint of an `MLModel`.
     */
    public suspend fun deleteRealtimeEndpoint(input: DeleteRealtimeEndpointRequest): DeleteRealtimeEndpointResponse

    /**
     * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
     *
     * If you specify a tag that doesn't exist, Amazon ML ignores it.
     */
    public suspend fun deleteTags(input: DeleteTagsRequest): DeleteTagsResponse

    /**
     * Returns a list of `BatchPrediction` operations that match the search criteria in the request.
     */
    public suspend fun describeBatchPredictions(input: DescribeBatchPredictionsRequest = DescribeBatchPredictionsRequest {}): DescribeBatchPredictionsResponse

    /**
     * Returns a list of `DataSource` that match the search criteria in the request.
     */
    public suspend fun describeDataSources(input: DescribeDataSourcesRequest = DescribeDataSourcesRequest {}): DescribeDataSourcesResponse

    /**
     * Returns a list of `DescribeEvaluations` that match the search criteria in the request.
     */
    public suspend fun describeEvaluations(input: DescribeEvaluationsRequest = DescribeEvaluationsRequest {}): DescribeEvaluationsResponse

    /**
     * Returns a list of `MLModel` that match the search criteria in the request.
     */
    public suspend fun describeMlModels(input: DescribeMlModelsRequest = DescribeMlModelsRequest {}): DescribeMlModelsResponse

    /**
     * Describes one or more of the tags for your Amazon ML object.
     */
    public suspend fun describeTags(input: DescribeTagsRequest): DescribeTagsResponse

    /**
     * Returns a `BatchPrediction` that includes detailed metadata, status, and data file information for a `Batch Prediction` request.
     */
    public suspend fun getBatchPrediction(input: GetBatchPredictionRequest): GetBatchPredictionResponse

    /**
     * Returns a `DataSource` that includes metadata and data file information, as well as the current status of the `DataSource`.
     *
     * `GetDataSource` provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.
     */
    public suspend fun getDataSource(input: GetDataSourceRequest): GetDataSourceResponse

    /**
     * Returns an `Evaluation` that includes metadata as well as the current status of the `Evaluation`.
     */
    public suspend fun getEvaluation(input: GetEvaluationRequest): GetEvaluationResponse

    /**
     * Returns an `MLModel` that includes detailed metadata, data source information, and the current status of the `MLModel`.
     *
     * `GetMLModel` provides results in normal or verbose format.
     */
    public suspend fun getMlModel(input: GetMlModelRequest): GetMlModelResponse

    /**
     * Generates a prediction for the observation using the specified `ML Model`.
     *
     * **Note:** Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.
     */
    public suspend fun predict(input: PredictRequest): PredictResponse

    /**
     * Updates the `BatchPredictionName` of a `BatchPrediction`.
     *
     * You can use the `GetBatchPrediction` operation to view the contents of the updated data element.
     */
    public suspend fun updateBatchPrediction(input: UpdateBatchPredictionRequest): UpdateBatchPredictionResponse

    /**
     * Updates the `DataSourceName` of a `DataSource`.
     *
     * You can use the `GetDataSource` operation to view the contents of the updated data element.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates the `EvaluationName` of an `Evaluation`.
     *
     * You can use the `GetEvaluation` operation to view the contents of the updated data element.
     */
    public suspend fun updateEvaluation(input: UpdateEvaluationRequest): UpdateEvaluationResponse

    /**
     * Updates the `MLModelName` and the `ScoreThreshold` of an `MLModel`.
     *
     * You can use the `GetMLModel` operation to view the contents of the updated data element.
     */
    public suspend fun updateMlModel(input: UpdateMlModelRequest): UpdateMlModelResponse
}

/**
 * Adds one or more tags to an object, up to a limit of 10. Each tag consists of a key and an optional value. If you add a tag using a key that is already associated with the ML object, `AddTags` updates the tag's value.
 */
public suspend inline fun MachineLearningClient.addTags(crossinline block: AddTagsRequest.Builder.() -> Unit): AddTagsResponse = addTags(AddTagsRequest.Builder().apply(block).build())

/**
 * Generates predictions for a group of observations. The observations to process exist in one or more data files referenced by a `DataSource`. This operation creates a new `BatchPrediction`, and uses an `MLModel` and the data files referenced by the `DataSource` as information sources.
 *
 * `CreateBatchPrediction` is an asynchronous operation. In response to `CreateBatchPrediction`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `BatchPrediction` status to `PENDING`. After the `BatchPrediction` completes, Amazon ML sets the status to `COMPLETED`.
 *
 * You can poll for status updates by using the GetBatchPrediction operation and checking the `Status` parameter of the result. After the `COMPLETED` status appears, the results are available in the location specified by the `OutputUri` parameter.
 */
public suspend inline fun MachineLearningClient.createBatchPrediction(crossinline block: CreateBatchPredictionRequest.Builder.() -> Unit): CreateBatchPredictionResponse = createBatchPrediction(CreateBatchPredictionRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` object from an [ Amazon Relational Database Service](http://aws.amazon.com/rds/) (Amazon RDS). A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 * `CreateDataSourceFromRDS` is an asynchronous operation. In response to `CreateDataSourceFromRDS`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used only to perform `>CreateMLModel`>, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 *  If Amazon ML cannot accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
 */
public suspend inline fun MachineLearningClient.createDataSourceFromRds(crossinline block: CreateDataSourceFromRdsRequest.Builder.() -> Unit): CreateDataSourceFromRdsResponse = createDataSourceFromRds(CreateDataSourceFromRdsRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` from a database hosted on an Amazon Redshift cluster. A `DataSource` references data that can be used to perform either `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 * `CreateDataSourceFromRedshift` is an asynchronous operation. In response to `CreateDataSourceFromRedshift`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` is created and ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in `COMPLETED` or `PENDING` states can be used to perform only `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
 *
 * The observations should be contained in the database hosted on an Amazon Redshift cluster and should be specified by a `SelectSqlQuery` query. Amazon ML executes an `Unload` command in Amazon Redshift to transfer the result set of the `SelectSqlQuery` query to `S3StagingLocation`.
 *
 * After the `DataSource` has been created, it's ready for use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also requires a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
 *
 * You can't change an existing datasource, but you can copy and modify the settings from an existing Amazon Redshift datasource to create a new datasource. To do so, call `GetDataSource` for an existing datasource and copy the values to a `CreateDataSource` call. Change the settings that you want to change and make sure that all required fields have the appropriate values.
 */
public suspend inline fun MachineLearningClient.createDataSourceFromRedshift(crossinline block: CreateDataSourceFromRedshiftRequest.Builder.() -> Unit): CreateDataSourceFromRedshiftResponse = createDataSourceFromRedshift(CreateDataSourceFromRedshiftRequest.Builder().apply(block).build())

/**
 * Creates a `DataSource` object. A `DataSource` references data that can be used to perform `CreateMLModel`, `CreateEvaluation`, or `CreateBatchPrediction` operations.
 *
 * `CreateDataSourceFromS3` is an asynchronous operation. In response to `CreateDataSourceFromS3`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `DataSource` status to `PENDING`. After the `DataSource` has been created and is ready for use, Amazon ML sets the `Status` parameter to `COMPLETED`. `DataSource` in the `COMPLETED` or `PENDING` state can be used to perform only `CreateMLModel`, `CreateEvaluation` or `CreateBatchPrediction` operations.
 *
 *  If Amazon ML can't accept the input source, it sets the `Status` parameter to `FAILED` and includes an error message in the `Message` attribute of the `GetDataSource` operation response.
 *
 * The observation data used in a `DataSource` should be ready to use; that is, it should have a consistent structure, and missing data values should be kept to a minimum. The observation data must reside in one or more .csv files in an Amazon Simple Storage Service (Amazon S3) location, along with a schema that describes the data items by name and type. The same schema must be used for all of the data files referenced by the `DataSource`.
 *
 * After the `DataSource` has been created, it's ready to use in evaluations and batch predictions. If you plan to use the `DataSource` to train an `MLModel`, the `DataSource` also needs a recipe. A recipe describes how each input variable will be used in training an `MLModel`. Will the variable be included or excluded from training? Will the variable be manipulated; for example, will it be combined with another variable or will it be split apart into word combinations? The recipe provides answers to these questions.
 */
public suspend inline fun MachineLearningClient.createDataSourceFromS3(crossinline block: CreateDataSourceFromS3Request.Builder.() -> Unit): CreateDataSourceFromS3Response = createDataSourceFromS3(CreateDataSourceFromS3Request.Builder().apply(block).build())

/**
 * Creates a new `Evaluation` of an `MLModel`. An `MLModel` is evaluated on a set of observations associated to a `DataSource`. Like a `DataSource` for an `MLModel`, the `DataSource` for an `Evaluation` contains values for the `Target Variable`. The `Evaluation` compares the predicted result for each observation to the actual outcome and provides a summary so that you know how effective the `MLModel` functions on the test data. Evaluation generates a relevant performance metric, such as BinaryAUC, RegressionRMSE or MulticlassAvgFScore based on the corresponding `MLModelType`: `BINARY`, `REGRESSION` or `MULTICLASS`.
 *
 * `CreateEvaluation` is an asynchronous operation. In response to `CreateEvaluation`, Amazon Machine Learning (Amazon ML) immediately returns and sets the evaluation status to `PENDING`. After the `Evaluation` is created and ready for use, Amazon ML sets the status to `COMPLETED`.
 *
 * You can use the `GetEvaluation` operation to check progress of the evaluation during the creation operation.
 */
public suspend inline fun MachineLearningClient.createEvaluation(crossinline block: CreateEvaluationRequest.Builder.() -> Unit): CreateEvaluationResponse = createEvaluation(CreateEvaluationRequest.Builder().apply(block).build())

/**
 * Creates a new `MLModel` using the `DataSource` and the recipe as information sources.
 *
 * An `MLModel` is nearly immutable. Users can update only the `MLModelName` and the `ScoreThreshold` in an `MLModel` without creating a new `MLModel`.
 *
 * `CreateMLModel` is an asynchronous operation. In response to `CreateMLModel`, Amazon Machine Learning (Amazon ML) immediately returns and sets the `MLModel` status to `PENDING`. After the `MLModel` has been created and ready is for use, Amazon ML sets the status to `COMPLETED`.
 *
 * You can use the `GetMLModel` operation to check the progress of the `MLModel` during the creation operation.
 *
 * `CreateMLModel` requires a `DataSource` with computed statistics, which can be created by setting `ComputeStatistics` to `true` in `CreateDataSourceFromRDS`, `CreateDataSourceFromS3`, or `CreateDataSourceFromRedshift` operations.
 */
public suspend inline fun MachineLearningClient.createMlModel(crossinline block: CreateMlModelRequest.Builder.() -> Unit): CreateMlModelResponse = createMlModel(CreateMlModelRequest.Builder().apply(block).build())

/**
 * Creates a real-time endpoint for the `MLModel`. The endpoint contains the URI of the `MLModel`; that is, the location to send real-time prediction requests for the specified `MLModel`.
 */
public suspend inline fun MachineLearningClient.createRealtimeEndpoint(crossinline block: CreateRealtimeEndpointRequest.Builder.() -> Unit): CreateRealtimeEndpointResponse = createRealtimeEndpoint(CreateRealtimeEndpointRequest.Builder().apply(block).build())

/**
 * Assigns the DELETED status to a `BatchPrediction`, rendering it unusable.
 *
 * After using the `DeleteBatchPrediction` operation, you can use the GetBatchPrediction operation to verify that the status of the `BatchPrediction` changed to DELETED.
 *
 * **Caution:** The result of the `DeleteBatchPrediction` operation is irreversible.
 */
public suspend inline fun MachineLearningClient.deleteBatchPrediction(crossinline block: DeleteBatchPredictionRequest.Builder.() -> Unit): DeleteBatchPredictionResponse = deleteBatchPrediction(DeleteBatchPredictionRequest.Builder().apply(block).build())

/**
 * Assigns the DELETED status to a `DataSource`, rendering it unusable.
 *
 * After using the `DeleteDataSource` operation, you can use the GetDataSource operation to verify that the status of the `DataSource` changed to DELETED.
 *
 * **Caution:** The results of the `DeleteDataSource` operation are irreversible.
 */
public suspend inline fun MachineLearningClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Assigns the `DELETED` status to an `Evaluation`, rendering it unusable.
 *
 * After invoking the `DeleteEvaluation` operation, you can use the `GetEvaluation` operation to verify that the status of the `Evaluation` changed to `DELETED`.
 *
 * **Caution:** The results of the `DeleteEvaluation` operation are irreversible.
 */
public suspend inline fun MachineLearningClient.deleteEvaluation(crossinline block: DeleteEvaluationRequest.Builder.() -> Unit): DeleteEvaluationResponse = deleteEvaluation(DeleteEvaluationRequest.Builder().apply(block).build())

/**
 * Assigns the `DELETED` status to an `MLModel`, rendering it unusable.
 *
 * After using the `DeleteMLModel` operation, you can use the `GetMLModel` operation to verify that the status of the `MLModel` changed to DELETED.
 *
 * **Caution:** The result of the `DeleteMLModel` operation is irreversible.
 */
public suspend inline fun MachineLearningClient.deleteMlModel(crossinline block: DeleteMlModelRequest.Builder.() -> Unit): DeleteMlModelResponse = deleteMlModel(DeleteMlModelRequest.Builder().apply(block).build())

/**
 * Deletes a real time endpoint of an `MLModel`.
 */
public suspend inline fun MachineLearningClient.deleteRealtimeEndpoint(crossinline block: DeleteRealtimeEndpointRequest.Builder.() -> Unit): DeleteRealtimeEndpointResponse = deleteRealtimeEndpoint(DeleteRealtimeEndpointRequest.Builder().apply(block).build())

/**
 * Deletes the specified tags associated with an ML object. After this operation is complete, you can't recover deleted tags.
 *
 * If you specify a tag that doesn't exist, Amazon ML ignores it.
 */
public suspend inline fun MachineLearningClient.deleteTags(crossinline block: DeleteTagsRequest.Builder.() -> Unit): DeleteTagsResponse = deleteTags(DeleteTagsRequest.Builder().apply(block).build())

/**
 * Returns a list of `BatchPrediction` operations that match the search criteria in the request.
 */
public suspend inline fun MachineLearningClient.describeBatchPredictions(crossinline block: DescribeBatchPredictionsRequest.Builder.() -> Unit): DescribeBatchPredictionsResponse = describeBatchPredictions(DescribeBatchPredictionsRequest.Builder().apply(block).build())

/**
 * Returns a list of `DataSource` that match the search criteria in the request.
 */
public suspend inline fun MachineLearningClient.describeDataSources(crossinline block: DescribeDataSourcesRequest.Builder.() -> Unit): DescribeDataSourcesResponse = describeDataSources(DescribeDataSourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of `DescribeEvaluations` that match the search criteria in the request.
 */
public suspend inline fun MachineLearningClient.describeEvaluations(crossinline block: DescribeEvaluationsRequest.Builder.() -> Unit): DescribeEvaluationsResponse = describeEvaluations(DescribeEvaluationsRequest.Builder().apply(block).build())

/**
 * Returns a list of `MLModel` that match the search criteria in the request.
 */
public suspend inline fun MachineLearningClient.describeMlModels(crossinline block: DescribeMlModelsRequest.Builder.() -> Unit): DescribeMlModelsResponse = describeMlModels(DescribeMlModelsRequest.Builder().apply(block).build())

/**
 * Describes one or more of the tags for your Amazon ML object.
 */
public suspend inline fun MachineLearningClient.describeTags(crossinline block: DescribeTagsRequest.Builder.() -> Unit): DescribeTagsResponse = describeTags(DescribeTagsRequest.Builder().apply(block).build())

/**
 * Returns a `BatchPrediction` that includes detailed metadata, status, and data file information for a `Batch Prediction` request.
 */
public suspend inline fun MachineLearningClient.getBatchPrediction(crossinline block: GetBatchPredictionRequest.Builder.() -> Unit): GetBatchPredictionResponse = getBatchPrediction(GetBatchPredictionRequest.Builder().apply(block).build())

/**
 * Returns a `DataSource` that includes metadata and data file information, as well as the current status of the `DataSource`.
 *
 * `GetDataSource` provides results in normal or verbose format. The verbose format adds the schema description and the list of files pointed to by the DataSource to the normal format.
 */
public suspend inline fun MachineLearningClient.getDataSource(crossinline block: GetDataSourceRequest.Builder.() -> Unit): GetDataSourceResponse = getDataSource(GetDataSourceRequest.Builder().apply(block).build())

/**
 * Returns an `Evaluation` that includes metadata as well as the current status of the `Evaluation`.
 */
public suspend inline fun MachineLearningClient.getEvaluation(crossinline block: GetEvaluationRequest.Builder.() -> Unit): GetEvaluationResponse = getEvaluation(GetEvaluationRequest.Builder().apply(block).build())

/**
 * Returns an `MLModel` that includes detailed metadata, data source information, and the current status of the `MLModel`.
 *
 * `GetMLModel` provides results in normal or verbose format.
 */
public suspend inline fun MachineLearningClient.getMlModel(crossinline block: GetMlModelRequest.Builder.() -> Unit): GetMlModelResponse = getMlModel(GetMlModelRequest.Builder().apply(block).build())

/**
 * Generates a prediction for the observation using the specified `ML Model`.
 *
 * **Note:** Not all response parameters will be populated. Whether a response parameter is populated depends on the type of model requested.
 */
public suspend inline fun MachineLearningClient.predict(crossinline block: PredictRequest.Builder.() -> Unit): PredictResponse = predict(PredictRequest.Builder().apply(block).build())

/**
 * Updates the `BatchPredictionName` of a `BatchPrediction`.
 *
 * You can use the `GetBatchPrediction` operation to view the contents of the updated data element.
 */
public suspend inline fun MachineLearningClient.updateBatchPrediction(crossinline block: UpdateBatchPredictionRequest.Builder.() -> Unit): UpdateBatchPredictionResponse = updateBatchPrediction(UpdateBatchPredictionRequest.Builder().apply(block).build())

/**
 * Updates the `DataSourceName` of a `DataSource`.
 *
 * You can use the `GetDataSource` operation to view the contents of the updated data element.
 */
public suspend inline fun MachineLearningClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates the `EvaluationName` of an `Evaluation`.
 *
 * You can use the `GetEvaluation` operation to view the contents of the updated data element.
 */
public suspend inline fun MachineLearningClient.updateEvaluation(crossinline block: UpdateEvaluationRequest.Builder.() -> Unit): UpdateEvaluationResponse = updateEvaluation(UpdateEvaluationRequest.Builder().apply(block).build())

/**
 * Updates the `MLModelName` and the `ScoreThreshold` of an `MLModel`.
 *
 * You can use the `GetMLModel` operation to view the contents of the updated data element.
 */
public suspend inline fun MachineLearningClient.updateMlModel(crossinline block: UpdateMlModelRequest.Builder.() -> Unit): UpdateMlModelResponse = updateMlModel(UpdateMlModelRequest.Builder().apply(block).build())
