// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



class CreateDataSourceFromRedshiftRequest private constructor(builder: Builder) {
    /**
     * The compute statistics for a DataSource. The statistics are generated from the observation data referenced by
     * a DataSource. Amazon ML uses the statistics internally during MLModel training.
     * This parameter must be set to true if the DataSource needs to
     * be used for MLModel training.
     */
    val computeStatistics: kotlin.Boolean = builder.computeStatistics
    /**
     * A user-supplied ID that uniquely identifies the DataSource.
     */
    val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * A user-supplied name or description of the DataSource.
     */
    val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The data specification of an Amazon Redshift DataSource:
     *
     *
     * DatabaseInformation -
     *
     *
     *
     * DatabaseName - The name of the Amazon Redshift database.
     *
     *
     * ClusterIdentifier - The unique ID for the Amazon Redshift cluster.
     *
     *
     *
     * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.
     *
     * SelectSqlQuery - The query that is used to retrieve the observation data for the
     * Datasource.
     *
     * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
     * Redshift data. The data retrieved from Amazon Redshift using
     * the SelectSqlQuery query is stored in this location.
     *
     * DataSchemaUri - The Amazon S3 location of the DataSchema.
     *
     * DataSchema - A JSON string representing the schema. This is not required if DataSchemaUri is specified.
     *
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the DataSource.
     * Sample -
     * "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
     */
    val dataSpec: aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec? = builder.dataSpec
    /**
     * A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:
     *
     *
     *
     * A security group to allow Amazon ML to execute the SelectSqlQuery query on an Amazon Redshift cluster
     *
     * An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the S3StagingLocation
     */
    val roleArn: kotlin.String? = builder.roleArn

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRedshiftRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceFromRedshiftRequest(")
        append("computeStatistics=$computeStatistics,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceName=$dataSourceName,")
        append("dataSpec=$dataSpec,")
        append("roleArn=$roleArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeStatistics.hashCode()
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (dataSpec?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceFromRedshiftRequest

        if (computeStatistics != other.computeStatistics) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceName != other.dataSourceName) return false
        if (dataSpec != other.dataSpec) return false
        if (roleArn != other.roleArn) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRedshiftRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * The compute statistics for a DataSource. The statistics are generated from the observation data referenced by
         * a DataSource. Amazon ML uses the statistics internally during MLModel training.
         * This parameter must be set to true if the DataSource needs to
         * be used for MLModel training.
         */
        var computeStatistics: kotlin.Boolean = false
        /**
         * A user-supplied ID that uniquely identifies the DataSource.
         */
        var dataSourceId: kotlin.String? = null
        /**
         * A user-supplied name or description of the DataSource.
         */
        var dataSourceName: kotlin.String? = null
        /**
         * The data specification of an Amazon Redshift DataSource:
         *
         *
         * DatabaseInformation -
         *
         *
         *
         * DatabaseName - The name of the Amazon Redshift database.
         *
         *
         * ClusterIdentifier - The unique ID for the Amazon Redshift cluster.
         *
         *
         *
         * DatabaseCredentials - The AWS Identity and Access Management (IAM) credentials that are used to connect to the Amazon Redshift database.
         *
         * SelectSqlQuery - The query that is used to retrieve the observation data for the
         * Datasource.
         *
         * S3StagingLocation - The Amazon Simple Storage Service (Amazon S3) location for staging Amazon
         * Redshift data. The data retrieved from Amazon Redshift using
         * the SelectSqlQuery query is stored in this location.
         *
         * DataSchemaUri - The Amazon S3 location of the DataSchema.
         *
         * DataSchema - A JSON string representing the schema. This is not required if DataSchemaUri is specified.
         *
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the DataSource.
         * Sample -
         * "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
         */
        var dataSpec: aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec? = null
        /**
         * A fully specified role Amazon Resource Name (ARN). Amazon ML assumes the role on behalf of the user to create the following:
         *
         *
         *
         * A security group to allow Amazon ML to execute the SelectSqlQuery query on an Amazon Redshift cluster
         *
         * An Amazon S3 bucket policy to grant Amazon ML read/write permissions on the S3StagingLocation
         */
        var roleArn: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRedshiftRequest) : this() {
            this.computeStatistics = x.computeStatistics
            this.dataSourceId = x.dataSourceId
            this.dataSourceName = x.dataSourceName
            this.dataSpec = x.dataSpec
            this.roleArn = x.roleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromRedshiftRequest = CreateDataSourceFromRedshiftRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec] inside the given [block]
         */
        fun dataSpec(block: aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec.Builder.() -> kotlin.Unit) {
            this.dataSpec = aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec.invoke(block)
        }
    }
}
