// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



class CreateDataSourceFromS3Request private constructor(builder: Builder) {
    /**
     * The compute statistics for a DataSource. The statistics are generated from the observation data referenced by
     * a DataSource. Amazon ML uses the statistics internally during MLModel training.
     * This parameter must be set to true if the DataSource needs to be used for MLModel training.
     */
    val computeStatistics: kotlin.Boolean = builder.computeStatistics
    /**
     * A user-supplied identifier that uniquely identifies the DataSource.
     */
    val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * A user-supplied name or description of the DataSource.
     */
    val dataSourceName: kotlin.String? = builder.dataSourceName
    /**
     * The data specification of a DataSource:
     *
     *
     * DataLocationS3 - The Amazon S3 location of the observation data.
     *
     * DataSchemaLocationS3 - The Amazon S3 location of the DataSchema.
     *
     * DataSchema - A JSON string representing the schema. This is not required if DataSchemaUri is specified.
     *
     * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the Datasource.
     * Sample -
     * "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
     */
    val dataSpec: aws.sdk.kotlin.services.machinelearning.model.S3DataSpec? = builder.dataSpec

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromS3Request = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDataSourceFromS3Request(")
        append("computeStatistics=$computeStatistics,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceName=$dataSourceName,")
        append("dataSpec=$dataSpec)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeStatistics.hashCode()
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (dataSourceName?.hashCode() ?: 0)
        result = 31 * result + (dataSpec?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDataSourceFromS3Request

        if (computeStatistics != other.computeStatistics) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceName != other.dataSourceName) return false
        if (dataSpec != other.dataSpec) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromS3Request = Builder(this).apply(block).build()

    class Builder {
        /**
         * The compute statistics for a DataSource. The statistics are generated from the observation data referenced by
         * a DataSource. Amazon ML uses the statistics internally during MLModel training.
         * This parameter must be set to true if the DataSource needs to be used for MLModel training.
         */
        var computeStatistics: kotlin.Boolean = false
        /**
         * A user-supplied identifier that uniquely identifies the DataSource.
         */
        var dataSourceId: kotlin.String? = null
        /**
         * A user-supplied name or description of the DataSource.
         */
        var dataSourceName: kotlin.String? = null
        /**
         * The data specification of a DataSource:
         *
         *
         * DataLocationS3 - The Amazon S3 location of the observation data.
         *
         * DataSchemaLocationS3 - The Amazon S3 location of the DataSchema.
         *
         * DataSchema - A JSON string representing the schema. This is not required if DataSchemaUri is specified.
         *
         * DataRearrangement - A JSON string that represents the splitting and rearrangement requirements for the Datasource.
         * Sample -
         * "{\"splitting\":{\"percentBegin\":10,\"percentEnd\":60}}"
         */
        var dataSpec: aws.sdk.kotlin.services.machinelearning.model.S3DataSpec? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromS3Request) : this() {
            this.computeStatistics = x.computeStatistics
            this.dataSourceId = x.dataSourceId
            this.dataSourceName = x.dataSourceName
            this.dataSpec = x.dataSpec
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.CreateDataSourceFromS3Request = CreateDataSourceFromS3Request(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.S3DataSpec] inside the given [block]
         */
        fun dataSpec(block: aws.sdk.kotlin.services.machinelearning.model.S3DataSpec.Builder.() -> kotlin.Unit) {
            this.dataSpec = aws.sdk.kotlin.services.machinelearning.model.S3DataSpec.invoke(block)
        }
    }
}
