// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of the GetDataSource operation.
 * The content consists of the detailed metadata and data file information and the current status of the DataSource.
 */
class DataSource private constructor(builder: Builder) {
    /**
     * The parameter is true if statistics need to be generated from the observation data.
     */
    val computeStatistics: kotlin.Boolean = builder.computeStatistics
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time that the DataSource was created. The time is expressed in epoch time.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account from which the DataSource was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a DataSource.
     */
    val dataLocationS3: kotlin.String? = builder.dataLocationS3
    /**
     * A JSON string that represents the splitting and rearrangement requirement used when this DataSource
     * was created.
     */
    val dataRearrangement: kotlin.String? = builder.dataRearrangement
    /**
     * The total number of observations contained in the data files that the DataSource references.
     */
    val dataSizeInBytes: kotlin.Long? = builder.dataSizeInBytes
    /**
     * The ID that is assigned to the DataSource during creation.
     */
    val dataSourceId: kotlin.String? = builder.dataSourceId
    /**
     * A timestamp represented in epoch time.
     */
    val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The time of the most recent edit to the
     * BatchPrediction. The time is expressed in epoch time.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A description of the most recent details about creating the DataSource.
     */
    val message: kotlin.String? = builder.message
    /**
     * A user-supplied name or description of the DataSource.
     */
    val name: kotlin.String? = builder.name
    /**
     * The number of data files referenced by the DataSource.
     */
    val numberOfFiles: kotlin.Long? = builder.numberOfFiles
    /**
     * The datasource details that are specific to Amazon RDS.
     */
    val rdsMetadata: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata? = builder.rdsMetadata
    /**
     * Describes the DataSource details specific to Amazon Redshift.
     */
    val redshiftMetadata: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata? = builder.redshiftMetadata
    /**
     * The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role, such as the following: arn:aws:iam::account:role/rolename.
     */
    val roleArn: kotlin.String? = builder.roleArn
    /**
     * A timestamp represented in epoch time.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The current status of the DataSource. This element can have one of the following values:
     *
     *
     * PENDING	- Amazon Machine Learning (Amazon ML) submitted a request to create a DataSource.
     *
     * INPROGRESS - The creation process is underway.
     *
     * FAILED - The request to create a DataSource did not run to completion. It is not usable.
     *
     * COMPLETED - The creation process completed successfully.
     *
     * DELETED	- The DataSource is marked as deleted. It is not usable.
     */
    val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.DataSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSource(")
        append("computeStatistics=$computeStatistics,")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("dataLocationS3=$dataLocationS3,")
        append("dataRearrangement=$dataRearrangement,")
        append("dataSizeInBytes=$dataSizeInBytes,")
        append("dataSourceId=$dataSourceId,")
        append("finishedAt=$finishedAt,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("message=$message,")
        append("name=$name,")
        append("numberOfFiles=$numberOfFiles,")
        append("rdsMetadata=$rdsMetadata,")
        append("redshiftMetadata=$redshiftMetadata,")
        append("roleArn=$roleArn,")
        append("startedAt=$startedAt,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeStatistics.hashCode()
        result = 31 * result + (computeTime?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (dataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (dataRearrangement?.hashCode() ?: 0)
        result = 31 * result + (dataSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (dataSourceId?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (numberOfFiles?.hashCode() ?: 0)
        result = 31 * result + (rdsMetadata?.hashCode() ?: 0)
        result = 31 * result + (redshiftMetadata?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSource

        if (computeStatistics != other.computeStatistics) return false
        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (dataLocationS3 != other.dataLocationS3) return false
        if (dataRearrangement != other.dataRearrangement) return false
        if (dataSizeInBytes != other.dataSizeInBytes) return false
        if (dataSourceId != other.dataSourceId) return false
        if (finishedAt != other.finishedAt) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (message != other.message) return false
        if (name != other.name) return false
        if (numberOfFiles != other.numberOfFiles) return false
        if (rdsMetadata != other.rdsMetadata) return false
        if (redshiftMetadata != other.redshiftMetadata) return false
        if (roleArn != other.roleArn) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.DataSource = Builder(this).apply(block).build()

    class Builder {
        /**
         * The parameter is true if statistics need to be generated from the observation data.
         */
        var computeStatistics: kotlin.Boolean = false
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var computeTime: kotlin.Long? = null
        /**
         * The time that the DataSource was created. The time is expressed in epoch time.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account from which the DataSource was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        var createdByIamUser: kotlin.String? = null
        /**
         * The location and name of the data in Amazon Simple Storage Service (Amazon S3) that is used by a DataSource.
         */
        var dataLocationS3: kotlin.String? = null
        /**
         * A JSON string that represents the splitting and rearrangement requirement used when this DataSource
         * was created.
         */
        var dataRearrangement: kotlin.String? = null
        /**
         * The total number of observations contained in the data files that the DataSource references.
         */
        var dataSizeInBytes: kotlin.Long? = null
        /**
         * The ID that is assigned to the DataSource during creation.
         */
        var dataSourceId: kotlin.String? = null
        /**
         * A timestamp represented in epoch time.
         */
        var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The time of the most recent edit to the
         * BatchPrediction. The time is expressed in epoch time.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the most recent details about creating the DataSource.
         */
        var message: kotlin.String? = null
        /**
         * A user-supplied name or description of the DataSource.
         */
        var name: kotlin.String? = null
        /**
         * The number of data files referenced by the DataSource.
         */
        var numberOfFiles: kotlin.Long? = null
        /**
         * The datasource details that are specific to Amazon RDS.
         */
        var rdsMetadata: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata? = null
        /**
         * Describes the DataSource details specific to Amazon Redshift.
         */
        var redshiftMetadata: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata? = null
        /**
         * The Amazon Resource Name (ARN) of an <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html#roles-about-termsandconcepts">AWS IAM Role, such as the following: arn:aws:iam::account:role/rolename.
         */
        var roleArn: kotlin.String? = null
        /**
         * A timestamp represented in epoch time.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the DataSource. This element can have one of the following values:
         *
         *
         * PENDING	- Amazon Machine Learning (Amazon ML) submitted a request to create a DataSource.
         *
         * INPROGRESS - The creation process is underway.
         *
         * FAILED - The request to create a DataSource did not run to completion. It is not usable.
         *
         * COMPLETED - The creation process completed successfully.
         *
         * DELETED	- The DataSource is marked as deleted. It is not usable.
         */
        var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.DataSource) : this() {
            this.computeStatistics = x.computeStatistics
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.dataLocationS3 = x.dataLocationS3
            this.dataRearrangement = x.dataRearrangement
            this.dataSizeInBytes = x.dataSizeInBytes
            this.dataSourceId = x.dataSourceId
            this.finishedAt = x.finishedAt
            this.lastUpdatedAt = x.lastUpdatedAt
            this.message = x.message
            this.name = x.name
            this.numberOfFiles = x.numberOfFiles
            this.rdsMetadata = x.rdsMetadata
            this.redshiftMetadata = x.redshiftMetadata
            this.roleArn = x.roleArn
            this.startedAt = x.startedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.DataSource = DataSource(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RdsMetadata] inside the given [block]
         */
        fun rdsMetadata(block: aws.sdk.kotlin.services.machinelearning.model.RdsMetadata.Builder.() -> kotlin.Unit) {
            this.rdsMetadata = aws.sdk.kotlin.services.machinelearning.model.RdsMetadata.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata] inside the given [block]
         */
        fun redshiftMetadata(block: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata.Builder.() -> kotlin.Unit) {
            this.redshiftMetadata = aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata.invoke(block)
        }
    }
}
