// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a GetEvaluation operation and describes an Evaluation.
 */
class GetEvaluationResponse private constructor(builder: Builder) {
    /**
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the Evaluation, normalized and scaled on computation resources. ComputeTime is only available if the Evaluation is in the COMPLETED state.
     */
    val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time that the Evaluation was created. The time is expressed in epoch time.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * The DataSource used for this evaluation.
     */
    val evaluationDataSourceId: kotlin.String? = builder.evaluationDataSourceId
    /**
     * The evaluation ID which is same as the EvaluationId in the request.
     */
    val evaluationId: kotlin.String? = builder.evaluationId
    /**
     * The epoch time when Amazon Machine Learning marked the Evaluation as COMPLETED or FAILED. FinishedAt is only available when the Evaluation is in the COMPLETED or FAILED state.
     */
    val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    val inputDataLocationS3: kotlin.String? = builder.inputDataLocationS3
    /**
     * The time of the most recent edit to the Evaluation. The time is expressed in epoch time.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A link to the file that contains logs of the CreateEvaluation operation.
     */
    val logUri: kotlin.String? = builder.logUri
    /**
     * A description of the most recent details about evaluating the MLModel.
     */
    val message: kotlin.String? = builder.message
    /**
     * The ID of the MLModel that was the focus of the evaluation.
     */
    val mlModelId: kotlin.String? = builder.mlModelId
    /**
     * A user-supplied name or description of the Evaluation.
     */
    val name: kotlin.String? = builder.name
    /**
     * Measurements of how well the MLModel performed using observations referenced by the DataSource. One of the following metric is returned based on the type of the MLModel:
     *
     *
     * BinaryAUC: A binary MLModel uses the Area Under the Curve (AUC) technique to measure performance.
     *
     * RegressionRMSE: A regression MLModel uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.
     *
     * MulticlassAvgFScore: A multiclass MLModel uses the F1 score technique to measure performance.
     *
     *
     *
     * For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide.
     */
    val performanceMetrics: aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics? = builder.performanceMetrics
    /**
     * The epoch time when Amazon Machine Learning marked the Evaluation as INPROGRESS. StartedAt isn't available if the Evaluation is in the PENDING state.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The status of the evaluation. This element can have one of the following values:
     *
     *
     *
     * PENDING - Amazon Machine Language (Amazon ML) submitted a request to evaluate an MLModel.
     *
     *
     * INPROGRESS - The evaluation is underway.
     *
     *
     * FAILED - The request to evaluate an MLModel did not run to completion. It is not usable.
     *
     *
     * COMPLETED - The evaluation process completed successfully.
     *
     *
     * DELETED - The Evaluation is marked as deleted. It is not usable.
     */
    val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.GetEvaluationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetEvaluationResponse(")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("evaluationDataSourceId=$evaluationDataSourceId,")
        append("evaluationId=$evaluationId,")
        append("finishedAt=$finishedAt,")
        append("inputDataLocationS3=$inputDataLocationS3,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("logUri=$logUri,")
        append("message=$message,")
        append("mlModelId=$mlModelId,")
        append("name=$name,")
        append("performanceMetrics=$performanceMetrics,")
        append("startedAt=$startedAt,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeTime?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (evaluationDataSourceId?.hashCode() ?: 0)
        result = 31 * result + (evaluationId?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (inputDataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mlModelId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (performanceMetrics?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetEvaluationResponse

        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (evaluationDataSourceId != other.evaluationDataSourceId) return false
        if (evaluationId != other.evaluationId) return false
        if (finishedAt != other.finishedAt) return false
        if (inputDataLocationS3 != other.inputDataLocationS3) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (logUri != other.logUri) return false
        if (message != other.message) return false
        if (mlModelId != other.mlModelId) return false
        if (name != other.name) return false
        if (performanceMetrics != other.performanceMetrics) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.GetEvaluationResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the Evaluation, normalized and scaled on computation resources. ComputeTime is only available if the Evaluation is in the COMPLETED state.
         */
        var computeTime: kotlin.Long? = null
        /**
         * The time that the Evaluation was created. The time is expressed in epoch time.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account that invoked the evaluation. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        var createdByIamUser: kotlin.String? = null
        /**
         * The DataSource used for this evaluation.
         */
        var evaluationDataSourceId: kotlin.String? = null
        /**
         * The evaluation ID which is same as the EvaluationId in the request.
         */
        var evaluationId: kotlin.String? = null
        /**
         * The epoch time when Amazon Machine Learning marked the Evaluation as COMPLETED or FAILED. FinishedAt is only available when the Evaluation is in the COMPLETED or FAILED state.
         */
        var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         */
        var inputDataLocationS3: kotlin.String? = null
        /**
         * The time of the most recent edit to the Evaluation. The time is expressed in epoch time.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A link to the file that contains logs of the CreateEvaluation operation.
         */
        var logUri: kotlin.String? = null
        /**
         * A description of the most recent details about evaluating the MLModel.
         */
        var message: kotlin.String? = null
        /**
         * The ID of the MLModel that was the focus of the evaluation.
         */
        var mlModelId: kotlin.String? = null
        /**
         * A user-supplied name or description of the Evaluation.
         */
        var name: kotlin.String? = null
        /**
         * Measurements of how well the MLModel performed using observations referenced by the DataSource. One of the following metric is returned based on the type of the MLModel:
         *
         *
         * BinaryAUC: A binary MLModel uses the Area Under the Curve (AUC) technique to measure performance.
         *
         * RegressionRMSE: A regression MLModel uses the Root Mean Square Error (RMSE) technique to measure performance. RMSE measures the difference between predicted and actual values for a single variable.
         *
         * MulticlassAvgFScore: A multiclass MLModel uses the F1 score technique to measure performance.
         *
         *
         *
         * For more information about performance metrics, please see the <a href="https://docs.aws.amazon.com/machine-learning/latest/dg">Amazon Machine Learning Developer Guide.
         */
        var performanceMetrics: aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics? = null
        /**
         * The epoch time when Amazon Machine Learning marked the Evaluation as INPROGRESS. StartedAt isn't available if the Evaluation is in the PENDING state.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the evaluation. This element can have one of the following values:
         *
         *
         *
         * PENDING - Amazon Machine Language (Amazon ML) submitted a request to evaluate an MLModel.
         *
         *
         * INPROGRESS - The evaluation is underway.
         *
         *
         * FAILED - The request to evaluate an MLModel did not run to completion. It is not usable.
         *
         *
         * COMPLETED - The evaluation process completed successfully.
         *
         *
         * DELETED - The Evaluation is marked as deleted. It is not usable.
         */
        var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.GetEvaluationResponse) : this() {
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.evaluationDataSourceId = x.evaluationDataSourceId
            this.evaluationId = x.evaluationId
            this.finishedAt = x.finishedAt
            this.inputDataLocationS3 = x.inputDataLocationS3
            this.lastUpdatedAt = x.lastUpdatedAt
            this.logUri = x.logUri
            this.message = x.message
            this.mlModelId = x.mlModelId
            this.name = x.name
            this.performanceMetrics = x.performanceMetrics
            this.startedAt = x.startedAt
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.GetEvaluationResponse = GetEvaluationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics] inside the given [block]
         */
        fun performanceMetrics(block: aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics.Builder.() -> kotlin.Unit) {
            this.performanceMetrics = aws.sdk.kotlin.services.machinelearning.model.PerformanceMetrics.invoke(block)
        }
    }
}
