// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the output of a GetMLModel operation, and provides detailed information about a MLModel.
 */
class GetMlModelResponse private constructor(builder: Builder) {
    /**
     * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the MLModel, normalized and scaled on computation resources. ComputeTime is only available if the MLModel is in the COMPLETED state.
     */
    val computeTime: kotlin.Long? = builder.computeTime
    /**
     * The time that the MLModel was created. The time is expressed in epoch time.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The AWS user account from which the MLModel was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
     */
    val createdByIamUser: kotlin.String? = builder.createdByIamUser
    /**
     * The current endpoint of the MLModel
     */
    val endpointInfo: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo? = builder.endpointInfo
    /**
     * The epoch time when Amazon Machine Learning marked the MLModel as COMPLETED or FAILED. FinishedAt is only available when the MLModel is in the COMPLETED or FAILED state.
     */
    val finishedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.finishedAt
    /**
     * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
     */
    val inputDataLocationS3: kotlin.String? = builder.inputDataLocationS3
    /**
     * The time of the most recent edit to the MLModel. The time is expressed in epoch time.
     */
    val lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedAt
    /**
     * A link to the file that contains logs of the CreateMLModel operation.
     */
    val logUri: kotlin.String? = builder.logUri
    /**
     * A description of the most recent details about accessing the MLModel.
     */
    val message: kotlin.String? = builder.message
    /**
     * The MLModel ID,
     * which is same as the MLModelId in the request.
     */
    val mlModelId: kotlin.String? = builder.mlModelId
    /**
     * Identifies the MLModel category. The following are the available types:
     *
     *
     * REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
     *
     * BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
     *
     * MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"
     */
    val mlModelType: aws.sdk.kotlin.services.machinelearning.model.MlModelType? = builder.mlModelType
    /**
     * A user-supplied name or description of the MLModel.
     */
    val name: kotlin.String? = builder.name
    /**
     * The recipe to use when training the MLModel. The Recipe
     * provides detailed information about the observation data to use during training, and
     * manipulations to perform on the observation data during training.
     *
     * Note: This parameter is provided as part of the verbose format.
     */
    val recipe: kotlin.String? = builder.recipe
    /**
     * The schema used by all of the data files referenced by the DataSource.
     *
     * Note: This parameter is provided as part of the verbose format.
     */
    val schema: kotlin.String? = builder.schema
    /**
     * The scoring threshold is used in binary classification MLModel
     * models. It marks the boundary between a positive prediction and a
     * negative prediction.
     * Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
     * true. Output values less than the threshold receive a negative response from the MLModel,
     * such as false.
     */
    val scoreThreshold: kotlin.Float? = builder.scoreThreshold
    /**
     * The time of the most recent edit to the ScoreThreshold. The time is expressed in epoch time.
     */
    val scoreThresholdLastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.scoreThresholdLastUpdatedAt
    /**
     * Long integer type that is a 64-bit signed number.
     */
    val sizeInBytes: kotlin.Long? = builder.sizeInBytes
    /**
     * The epoch time when Amazon Machine Learning marked the MLModel as INPROGRESS. StartedAt isn't available if the MLModel is in the PENDING state.
     */
    val startedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.startedAt
    /**
     * The current status of the MLModel. This element can have one of the following values:
     *
     *
     *
     * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to describe a MLModel.
     *
     *
     * INPROGRESS - The request is processing.
     *
     *
     * FAILED - The request did not run to completion. The ML model isn't
     * usable.
     *
     *
     * COMPLETED - The request completed successfully.
     *
     *
     * DELETED - The MLModel is marked as deleted. It isn't
     * usable.
     */
    val status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = builder.status
    /**
     * The ID of the training DataSource.
     */
    val trainingDataSourceId: kotlin.String? = builder.trainingDataSourceId
    /**
     * A list of the training parameters in the MLModel. The list is implemented as
     * a map of key-value pairs.
     * The following is the current set of training parameters:
     *
     *
     *
     * sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending on the
     * input data, the size of the model might affect its performance.
     * The value is an integer that ranges from 100000 to 2147483648. The default value is 33554432.
     *
     *
     * sgd.maxPasses - The number of times that the training process traverses the
     * observations to build the MLModel. The value is an integer that
     * ranges from 1 to 10000. The default value is
     * 10.
     *
     *
     * sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling data improves a
     * model's ability to find the optimal solution for a variety of data types. The
     * valid values are auto and none. The default value is
     * none. We strongly recommend that you shuffle your data.
     *
     *
     * sgd.l1RegularizationAmount - The coefficient regularization L1 norm. It controls
     * overfitting the data by penalizing large coefficients. This tends to drive
     * coefficients to zero, resulting in a sparse feature set. If you use this
     * parameter, start by specifying a small value, such as 1.0E-08.
     * The value is a double that ranges from 0 to MAX_DOUBLE.
     * The default is to not use L1 normalization. This parameter can't be used when
     * L2 is specified. Use this parameter sparingly.
     *
     *
     * sgd.l2RegularizationAmount - The coefficient regularization L2 norm. It controls
     * overfitting the data by penalizing large coefficients. This tends to drive
     * coefficients to small, nonzero values. If you use this parameter, start by
     * specifying a small value, such as 1.0E-08.
     * The value is a double that ranges from 0 to MAX_DOUBLE.
     * The default is to not use L2 normalization. This parameter can't be used when
     * L1 is specified. Use this parameter sparingly.
     */
    val trainingParameters: Map<String, String>? = builder.trainingParameters

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.GetMlModelResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetMlModelResponse(")
        append("computeTime=$computeTime,")
        append("createdAt=$createdAt,")
        append("createdByIamUser=$createdByIamUser,")
        append("endpointInfo=$endpointInfo,")
        append("finishedAt=$finishedAt,")
        append("inputDataLocationS3=$inputDataLocationS3,")
        append("lastUpdatedAt=$lastUpdatedAt,")
        append("logUri=$logUri,")
        append("message=$message,")
        append("mlModelId=$mlModelId,")
        append("mlModelType=$mlModelType,")
        append("name=$name,")
        append("recipe=$recipe,")
        append("schema=$schema,")
        append("scoreThreshold=$scoreThreshold,")
        append("scoreThresholdLastUpdatedAt=$scoreThresholdLastUpdatedAt,")
        append("sizeInBytes=$sizeInBytes,")
        append("startedAt=$startedAt,")
        append("status=$status,")
        append("trainingDataSourceId=$trainingDataSourceId,")
        append("trainingParameters=$trainingParameters)")
    }

    override fun hashCode(): kotlin.Int {
        var result = computeTime?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdByIamUser?.hashCode() ?: 0)
        result = 31 * result + (endpointInfo?.hashCode() ?: 0)
        result = 31 * result + (finishedAt?.hashCode() ?: 0)
        result = 31 * result + (inputDataLocationS3?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (logUri?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (mlModelId?.hashCode() ?: 0)
        result = 31 * result + (mlModelType?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (recipe?.hashCode() ?: 0)
        result = 31 * result + (schema?.hashCode() ?: 0)
        result = 31 * result + (scoreThreshold?.hashCode() ?: 0)
        result = 31 * result + (scoreThresholdLastUpdatedAt?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (startedAt?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (trainingDataSourceId?.hashCode() ?: 0)
        result = 31 * result + (trainingParameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetMlModelResponse

        if (computeTime != other.computeTime) return false
        if (createdAt != other.createdAt) return false
        if (createdByIamUser != other.createdByIamUser) return false
        if (endpointInfo != other.endpointInfo) return false
        if (finishedAt != other.finishedAt) return false
        if (inputDataLocationS3 != other.inputDataLocationS3) return false
        if (lastUpdatedAt != other.lastUpdatedAt) return false
        if (logUri != other.logUri) return false
        if (message != other.message) return false
        if (mlModelId != other.mlModelId) return false
        if (mlModelType != other.mlModelType) return false
        if (name != other.name) return false
        if (recipe != other.recipe) return false
        if (schema != other.schema) return false
        if (scoreThreshold != other.scoreThreshold) return false
        if (scoreThresholdLastUpdatedAt != other.scoreThresholdLastUpdatedAt) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (startedAt != other.startedAt) return false
        if (status != other.status) return false
        if (trainingDataSourceId != other.trainingDataSourceId) return false
        if (trainingParameters != other.trainingParameters) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.GetMlModelResponse = Builder(this).apply(block).build()

    class Builder {
        /**
         * The approximate CPU time in milliseconds that Amazon Machine Learning spent processing the MLModel, normalized and scaled on computation resources. ComputeTime is only available if the MLModel is in the COMPLETED state.
         */
        var computeTime: kotlin.Long? = null
        /**
         * The time that the MLModel was created. The time is expressed in epoch time.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The AWS user account from which the MLModel was created. The account type can be either an AWS root account or an AWS Identity and Access Management (IAM) user account.
         */
        var createdByIamUser: kotlin.String? = null
        /**
         * The current endpoint of the MLModel
         */
        var endpointInfo: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo? = null
        /**
         * The epoch time when Amazon Machine Learning marked the MLModel as COMPLETED or FAILED. FinishedAt is only available when the MLModel is in the COMPLETED or FAILED state.
         */
        var finishedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The location of the data file or directory in Amazon Simple Storage Service (Amazon S3).
         */
        var inputDataLocationS3: kotlin.String? = null
        /**
         * The time of the most recent edit to the MLModel. The time is expressed in epoch time.
         */
        var lastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A link to the file that contains logs of the CreateMLModel operation.
         */
        var logUri: kotlin.String? = null
        /**
         * A description of the most recent details about accessing the MLModel.
         */
        var message: kotlin.String? = null
        /**
         * The MLModel ID,
         * which is same as the MLModelId in the request.
         */
        var mlModelId: kotlin.String? = null
        /**
         * Identifies the MLModel category. The following are the available types:
         *
         *
         * REGRESSION -- Produces a numeric result. For example, "What price should a house be listed at?"
         *
         * BINARY -- Produces one of two possible results. For example, "Is this an e-commerce website?"
         *
         * MULTICLASS -- Produces one of several possible results. For example, "Is this a HIGH, LOW or MEDIUM risk trade?"
         */
        var mlModelType: aws.sdk.kotlin.services.machinelearning.model.MlModelType? = null
        /**
         * A user-supplied name or description of the MLModel.
         */
        var name: kotlin.String? = null
        /**
         * The recipe to use when training the MLModel. The Recipe
         * provides detailed information about the observation data to use during training, and
         * manipulations to perform on the observation data during training.
         *
         * Note: This parameter is provided as part of the verbose format.
         */
        var recipe: kotlin.String? = null
        /**
         * The schema used by all of the data files referenced by the DataSource.
         *
         * Note: This parameter is provided as part of the verbose format.
         */
        var schema: kotlin.String? = null
        /**
         * The scoring threshold is used in binary classification MLModel
         * models. It marks the boundary between a positive prediction and a
         * negative prediction.
         * Output values greater than or equal to the threshold receive a positive result from the MLModel, such as
         * true. Output values less than the threshold receive a negative response from the MLModel,
         * such as false.
         */
        var scoreThreshold: kotlin.Float? = null
        /**
         * The time of the most recent edit to the ScoreThreshold. The time is expressed in epoch time.
         */
        var scoreThresholdLastUpdatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Long integer type that is a 64-bit signed number.
         */
        var sizeInBytes: kotlin.Long? = null
        /**
         * The epoch time when Amazon Machine Learning marked the MLModel as INPROGRESS. StartedAt isn't available if the MLModel is in the PENDING state.
         */
        var startedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the MLModel. This element can have one of the following values:
         *
         *
         *
         * PENDING - Amazon Machine Learning (Amazon ML) submitted a request to describe a MLModel.
         *
         *
         * INPROGRESS - The request is processing.
         *
         *
         * FAILED - The request did not run to completion. The ML model isn't
         * usable.
         *
         *
         * COMPLETED - The request completed successfully.
         *
         *
         * DELETED - The MLModel is marked as deleted. It isn't
         * usable.
         */
        var status: aws.sdk.kotlin.services.machinelearning.model.EntityStatus? = null
        /**
         * The ID of the training DataSource.
         */
        var trainingDataSourceId: kotlin.String? = null
        /**
         * A list of the training parameters in the MLModel. The list is implemented as
         * a map of key-value pairs.
         * The following is the current set of training parameters:
         *
         *
         *
         * sgd.maxMLModelSizeInBytes - The maximum allowed size of the model. Depending on the
         * input data, the size of the model might affect its performance.
         * The value is an integer that ranges from 100000 to 2147483648. The default value is 33554432.
         *
         *
         * sgd.maxPasses - The number of times that the training process traverses the
         * observations to build the MLModel. The value is an integer that
         * ranges from 1 to 10000. The default value is
         * 10.
         *
         *
         * sgd.shuffleType - Whether Amazon ML shuffles the training data. Shuffling data improves a
         * model's ability to find the optimal solution for a variety of data types. The
         * valid values are auto and none. The default value is
         * none. We strongly recommend that you shuffle your data.
         *
         *
         * sgd.l1RegularizationAmount - The coefficient regularization L1 norm. It controls
         * overfitting the data by penalizing large coefficients. This tends to drive
         * coefficients to zero, resulting in a sparse feature set. If you use this
         * parameter, start by specifying a small value, such as 1.0E-08.
         * The value is a double that ranges from 0 to MAX_DOUBLE.
         * The default is to not use L1 normalization. This parameter can't be used when
         * L2 is specified. Use this parameter sparingly.
         *
         *
         * sgd.l2RegularizationAmount - The coefficient regularization L2 norm. It controls
         * overfitting the data by penalizing large coefficients. This tends to drive
         * coefficients to small, nonzero values. If you use this parameter, start by
         * specifying a small value, such as 1.0E-08.
         * The value is a double that ranges from 0 to MAX_DOUBLE.
         * The default is to not use L2 normalization. This parameter can't be used when
         * L1 is specified. Use this parameter sparingly.
         */
        var trainingParameters: Map<String, String>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.GetMlModelResponse) : this() {
            this.computeTime = x.computeTime
            this.createdAt = x.createdAt
            this.createdByIamUser = x.createdByIamUser
            this.endpointInfo = x.endpointInfo
            this.finishedAt = x.finishedAt
            this.inputDataLocationS3 = x.inputDataLocationS3
            this.lastUpdatedAt = x.lastUpdatedAt
            this.logUri = x.logUri
            this.message = x.message
            this.mlModelId = x.mlModelId
            this.mlModelType = x.mlModelType
            this.name = x.name
            this.recipe = x.recipe
            this.schema = x.schema
            this.scoreThreshold = x.scoreThreshold
            this.scoreThresholdLastUpdatedAt = x.scoreThresholdLastUpdatedAt
            this.sizeInBytes = x.sizeInBytes
            this.startedAt = x.startedAt
            this.status = x.status
            this.trainingDataSourceId = x.trainingDataSourceId
            this.trainingParameters = x.trainingParameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.GetMlModelResponse = GetMlModelResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo] inside the given [block]
         */
        fun endpointInfo(block: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo.Builder.() -> kotlin.Unit) {
            this.endpointInfo = aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo.invoke(block)
        }
    }
}
