// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the real-time endpoint information for an MLModel.
 */
class RealtimeEndpointInfo private constructor(builder: Builder) {
    /**
     * The time that the request to create the real-time endpoint for the MLModel was received. The time is expressed in epoch time.
     */
    val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The current status of the real-time endpoint for the MLModel. This element can have one of the following values:
     *
     *
     *
     * NONE  - Endpoint does not exist or was previously deleted.
     *
     *
     * READY - Endpoint is ready to be used for real-time predictions.
     *
     *
     * UPDATING - Updating/creating the endpoint.
     */
    val endpointStatus: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointStatus? = builder.endpointStatus
    /**
     * The URI that specifies where to send real-time prediction requests for the MLModel.
     *
     * Note: The application must wait until the real-time endpoint is ready before using this URI.
     */
    val endpointUrl: kotlin.String? = builder.endpointUrl
    /**
     * The maximum processing rate for the real-time endpoint for MLModel, measured in incoming requests per second.
     */
    val peakRequestsPerSecond: kotlin.Int = builder.peakRequestsPerSecond

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RealtimeEndpointInfo(")
        append("createdAt=$createdAt,")
        append("endpointStatus=$endpointStatus,")
        append("endpointUrl=$endpointUrl,")
        append("peakRequestsPerSecond=$peakRequestsPerSecond)")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt?.hashCode() ?: 0
        result = 31 * result + (endpointStatus?.hashCode() ?: 0)
        result = 31 * result + (endpointUrl?.hashCode() ?: 0)
        result = 31 * result + (peakRequestsPerSecond)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RealtimeEndpointInfo

        if (createdAt != other.createdAt) return false
        if (endpointStatus != other.endpointStatus) return false
        if (endpointUrl != other.endpointUrl) return false
        if (peakRequestsPerSecond != other.peakRequestsPerSecond) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo = Builder(this).apply(block).build()

    class Builder {
        /**
         * The time that the request to create the real-time endpoint for the MLModel was received. The time is expressed in epoch time.
         */
        var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status of the real-time endpoint for the MLModel. This element can have one of the following values:
         *
         *
         *
         * NONE  - Endpoint does not exist or was previously deleted.
         *
         *
         * READY - Endpoint is ready to be used for real-time predictions.
         *
         *
         * UPDATING - Updating/creating the endpoint.
         */
        var endpointStatus: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointStatus? = null
        /**
         * The URI that specifies where to send real-time prediction requests for the MLModel.
         *
         * Note: The application must wait until the real-time endpoint is ready before using this URI.
         */
        var endpointUrl: kotlin.String? = null
        /**
         * The maximum processing rate for the real-time endpoint for MLModel, measured in incoming requests per second.
         */
        var peakRequestsPerSecond: kotlin.Int = 0

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo) : this() {
            this.createdAt = x.createdAt
            this.endpointStatus = x.endpointStatus
            this.endpointUrl = x.endpointUrl
            this.peakRequestsPerSecond = x.peakRequestsPerSecond
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RealtimeEndpointInfo = RealtimeEndpointInfo(this)
    }
}
