// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * Describes the data specification of an Amazon Redshift DataSource.
 */
class RedshiftDataSpec private constructor(builder: Builder) {
    /**
     * A JSON string that represents the splitting and rearrangement
     * processing to be applied to a DataSource. If the DataRearrangement
     * parameter is not provided, all of the input data is used to create the Datasource.
     *
     * There are multiple parameters that control what data is used to create a datasource:
     *
     *
     *
     *
     * percentBegin
     *
     *
     * Use percentBegin to indicate the beginning of the range of the data used to
     * create the Datasource.
     * If you do not include percentBegin and percentEnd, Amazon ML includes
     * all of the data when creating the datasource.
     *
     *
     *
     * percentEnd
     *
     *
     * Use percentEnd to indicate the end of the range of the data used to create the
     * Datasource. If you do not
     * include percentBegin and percentEnd, Amazon ML
     * includes all of the data when creating the datasource.
     *
     *
     *
     * complement
     *
     *
     * The complement parameter instructs Amazon ML to use the data that is
     * not included in the range of percentBegin to percentEnd to create a
     * datasource. The complement parameter is useful if you need to create
     * complementary datasources for training and evaluation.
     * To create a complementary datasource, use the same
     * values for percentBegin and percentEnd, along with the
     * complement parameter.
     *
     * For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.
     * Datasource for evaluation: {"splitting":{"percentBegin":0, "percentEnd":25}}
     *
     * Datasource for training: {"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}
     *
     *
     *
     *
     * strategy
     *
     *
     * To change how Amazon ML splits the data for a datasource, use the strategy parameter.
     * The default value for the strategy parameter
     * is sequential, meaning that Amazon ML takes all of the data records between the percentBegin
     * and percentEnd parameters for the datasource, in the order that the records appear in the input data.
     *
     * The following two DataRearrangement lines are examples of sequentially ordered
     * training and evaluation datasources:
     * Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}
     *
     * Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}
     *
     *
     * To randomly split the input data into the proportions indicated by the percentBegin and percentEnd
     * parameters, set the strategy parameter to
     * random and provide a string that is used as the seed value for the random data splitting (for
     * example, you can use the S3 path to your data as the random seed string).
     * If you choose the random split strategy,
     * Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned
     * number between percentBegin and percentEnd. Pseudo-random numbers are assigned
     * using both the input seed string value and the byte offset as a seed, so changing the data results in a
     * different split. Any existing ordering is preserved.
     * The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly.
     * It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in
     * training and evaluation datasources containing non-similar data records.
     * The following two DataRearrangement lines are examples of non-sequentially ordered
     * training and evaluation datasources:
     * Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}
     *
     * Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}
     */
    val dataRearrangement: kotlin.String? = builder.dataRearrangement
    /**
     * A JSON string that represents the schema for an Amazon Redshift
     * DataSource. The DataSchema
     * defines the structure of the observation data in the data file(s)
     * referenced in the DataSource.
     * A DataSchema is not required if you specify a
     * DataSchemaUri.
     * Define your DataSchema as a series of key-value pairs. attributes
     * and excludedVariableNames have an array of key-value pairs
     * for their value. Use the following format to define your DataSchema.
     * { "version": "1.0",
     * "recordAnnotationFieldName": "F1",
     * "recordWeightFieldName": "F2",
     * "targetFieldName": "F3",
     * "dataFormat": "CSV",
     * "dataFileContainsHeader": true,
     * "attributes": &#91;
     * { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } &#93;,
     * "excludedVariableNames": &#91; "F6" &#93; }
     */
    val dataSchema: kotlin.String? = builder.dataSchema
    /**
     * Describes the schema location for an Amazon Redshift DataSource.
     */
    val dataSchemaUri: kotlin.String? = builder.dataSchemaUri
    /**
     * Describes AWS Identity and Access Management (IAM) credentials that are used connect to the Amazon Redshift database.
     */
    val databaseCredentials: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials? = builder.databaseCredentials
    /**
     * Describes the DatabaseName and ClusterIdentifier for an Amazon Redshift DataSource.
     */
    val databaseInformation: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase? = builder.databaseInformation
    /**
     * Describes an Amazon S3 location to store the result set of the SelectSqlQuery query.
     */
    val s3StagingLocation: kotlin.String? = builder.s3StagingLocation
    /**
     * Describes the SQL Query to execute on an Amazon Redshift database for an Amazon Redshift DataSource.
     */
    val selectSqlQuery: kotlin.String? = builder.selectSqlQuery

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDataSpec(")
        append("dataRearrangement=$dataRearrangement,")
        append("dataSchema=$dataSchema,")
        append("dataSchemaUri=$dataSchemaUri,")
        append("databaseCredentials=$databaseCredentials,")
        append("databaseInformation=$databaseInformation,")
        append("s3StagingLocation=$s3StagingLocation,")
        append("selectSqlQuery=$selectSqlQuery)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataRearrangement?.hashCode() ?: 0
        result = 31 * result + (dataSchema?.hashCode() ?: 0)
        result = 31 * result + (dataSchemaUri?.hashCode() ?: 0)
        result = 31 * result + (databaseCredentials?.hashCode() ?: 0)
        result = 31 * result + (databaseInformation?.hashCode() ?: 0)
        result = 31 * result + (s3StagingLocation?.hashCode() ?: 0)
        result = 31 * result + (selectSqlQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDataSpec

        if (dataRearrangement != other.dataRearrangement) return false
        if (dataSchema != other.dataSchema) return false
        if (dataSchemaUri != other.dataSchemaUri) return false
        if (databaseCredentials != other.databaseCredentials) return false
        if (databaseInformation != other.databaseInformation) return false
        if (s3StagingLocation != other.s3StagingLocation) return false
        if (selectSqlQuery != other.selectSqlQuery) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec = Builder(this).apply(block).build()

    class Builder {
        /**
         * A JSON string that represents the splitting and rearrangement
         * processing to be applied to a DataSource. If the DataRearrangement
         * parameter is not provided, all of the input data is used to create the Datasource.
         *
         * There are multiple parameters that control what data is used to create a datasource:
         *
         *
         *
         *
         * percentBegin
         *
         *
         * Use percentBegin to indicate the beginning of the range of the data used to
         * create the Datasource.
         * If you do not include percentBegin and percentEnd, Amazon ML includes
         * all of the data when creating the datasource.
         *
         *
         *
         * percentEnd
         *
         *
         * Use percentEnd to indicate the end of the range of the data used to create the
         * Datasource. If you do not
         * include percentBegin and percentEnd, Amazon ML
         * includes all of the data when creating the datasource.
         *
         *
         *
         * complement
         *
         *
         * The complement parameter instructs Amazon ML to use the data that is
         * not included in the range of percentBegin to percentEnd to create a
         * datasource. The complement parameter is useful if you need to create
         * complementary datasources for training and evaluation.
         * To create a complementary datasource, use the same
         * values for percentBegin and percentEnd, along with the
         * complement parameter.
         *
         * For example, the following two datasources do not share any data, and can be used to train and evaluate a model. The first datasource has 25 percent of the data, and the second one has 75 percent of the data.
         * Datasource for evaluation: {"splitting":{"percentBegin":0, "percentEnd":25}}
         *
         * Datasource for training: {"splitting":{"percentBegin":0, "percentEnd":25, "complement":"true"}}
         *
         *
         *
         *
         * strategy
         *
         *
         * To change how Amazon ML splits the data for a datasource, use the strategy parameter.
         * The default value for the strategy parameter
         * is sequential, meaning that Amazon ML takes all of the data records between the percentBegin
         * and percentEnd parameters for the datasource, in the order that the records appear in the input data.
         *
         * The following two DataRearrangement lines are examples of sequentially ordered
         * training and evaluation datasources:
         * Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential"}}
         *
         * Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"sequential", "complement":"true"}}
         *
         *
         * To randomly split the input data into the proportions indicated by the percentBegin and percentEnd
         * parameters, set the strategy parameter to
         * random and provide a string that is used as the seed value for the random data splitting (for
         * example, you can use the S3 path to your data as the random seed string).
         * If you choose the random split strategy,
         * Amazon ML assigns each row of data a pseudo-random number between 0 and 100, and then selects the rows that have an assigned
         * number between percentBegin and percentEnd. Pseudo-random numbers are assigned
         * using both the input seed string value and the byte offset as a seed, so changing the data results in a
         * different split. Any existing ordering is preserved.
         * The random splitting strategy ensures that variables in the training and evaluation data are distributed similarly.
         * It is useful in the cases where the input data may have an implicit sort order, which would otherwise result in
         * training and evaluation datasources containing non-similar data records.
         * The following two DataRearrangement lines are examples of non-sequentially ordered
         * training and evaluation datasources:
         * Datasource for evaluation: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv"}}
         *
         * Datasource for training: {"splitting":{"percentBegin":70, "percentEnd":100, "strategy":"random", "randomSeed"="s3://my_s3_path/bucket/file.csv", "complement":"true"}}
         */
        var dataRearrangement: kotlin.String? = null
        /**
         * A JSON string that represents the schema for an Amazon Redshift
         * DataSource. The DataSchema
         * defines the structure of the observation data in the data file(s)
         * referenced in the DataSource.
         * A DataSchema is not required if you specify a
         * DataSchemaUri.
         * Define your DataSchema as a series of key-value pairs. attributes
         * and excludedVariableNames have an array of key-value pairs
         * for their value. Use the following format to define your DataSchema.
         * { "version": "1.0",
         * "recordAnnotationFieldName": "F1",
         * "recordWeightFieldName": "F2",
         * "targetFieldName": "F3",
         * "dataFormat": "CSV",
         * "dataFileContainsHeader": true,
         * "attributes": &#91;
         * { "fieldName": "F1", "fieldType": "TEXT" }, { "fieldName": "F2", "fieldType": "NUMERIC" }, { "fieldName": "F3", "fieldType": "CATEGORICAL" }, { "fieldName": "F4", "fieldType": "NUMERIC" }, { "fieldName": "F5", "fieldType": "CATEGORICAL" }, { "fieldName": "F6", "fieldType": "TEXT" }, { "fieldName": "F7", "fieldType": "WEIGHTED_INT_SEQUENCE" }, { "fieldName": "F8", "fieldType": "WEIGHTED_STRING_SEQUENCE" } &#93;,
         * "excludedVariableNames": &#91; "F6" &#93; }
         */
        var dataSchema: kotlin.String? = null
        /**
         * Describes the schema location for an Amazon Redshift DataSource.
         */
        var dataSchemaUri: kotlin.String? = null
        /**
         * Describes AWS Identity and Access Management (IAM) credentials that are used connect to the Amazon Redshift database.
         */
        var databaseCredentials: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials? = null
        /**
         * Describes the DatabaseName and ClusterIdentifier for an Amazon Redshift DataSource.
         */
        var databaseInformation: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase? = null
        /**
         * Describes an Amazon S3 location to store the result set of the SelectSqlQuery query.
         */
        var s3StagingLocation: kotlin.String? = null
        /**
         * Describes the SQL Query to execute on an Amazon Redshift database for an Amazon Redshift DataSource.
         */
        var selectSqlQuery: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec) : this() {
            this.dataRearrangement = x.dataRearrangement
            this.dataSchema = x.dataSchema
            this.dataSchemaUri = x.dataSchemaUri
            this.databaseCredentials = x.databaseCredentials
            this.databaseInformation = x.databaseInformation
            this.s3StagingLocation = x.s3StagingLocation
            this.selectSqlQuery = x.selectSqlQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RedshiftDataSpec = RedshiftDataSpec(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials] inside the given [block]
         */
        fun databaseCredentials(block: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials.Builder.() -> kotlin.Unit) {
            this.databaseCredentials = aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase] inside the given [block]
         */
        fun databaseInformation(block: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase.Builder.() -> kotlin.Unit) {
            this.databaseInformation = aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase.invoke(block)
        }
    }
}
