// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * Describes the database credentials for connecting to a database on an Amazon Redshift cluster.
 */
class RedshiftDatabaseCredentials private constructor(builder: Builder) {
    /**
     * A password to be used by Amazon ML to connect to a database on an Amazon Redshift cluster.
     * The password should have sufficient permissions to execute a RedshiftSelectSqlQuery query. The password should be valid for an Amazon Redshift <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER.
     */
    val password: kotlin.String? = builder.password
    /**
     * A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster.
     * The username should have sufficient permissions to execute the RedshiftSelectSqlQuery query. The username should be valid for an Amazon Redshift <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER.
     */
    val username: kotlin.String? = builder.username

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDatabaseCredentials(")
        append("password=$password,")
        append("username=$username)")
    }

    override fun hashCode(): kotlin.Int {
        var result = password?.hashCode() ?: 0
        result = 31 * result + (username?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDatabaseCredentials

        if (password != other.password) return false
        if (username != other.username) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials = Builder(this).apply(block).build()

    class Builder {
        /**
         * A password to be used by Amazon ML to connect to a database on an Amazon Redshift cluster.
         * The password should have sufficient permissions to execute a RedshiftSelectSqlQuery query. The password should be valid for an Amazon Redshift <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER.
         */
        var password: kotlin.String? = null
        /**
         * A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster.
         * The username should have sufficient permissions to execute the RedshiftSelectSqlQuery query. The username should be valid for an Amazon Redshift <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER.
         */
        var username: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials) : this() {
            this.password = x.password
            this.username = x.username
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabaseCredentials = RedshiftDatabaseCredentials(this)
    }
}
