// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.model



/**
 * Describes the DataSource details specific to Amazon Redshift.
 */
class RedshiftMetadata private constructor(builder: Builder) {
    /**
     * A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster.
     * The username should have sufficient permissions to execute the RedshiftSelectSqlQuery query. The username should be valid for an Amazon Redshift <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER.
     */
    val databaseUserName: kotlin.String? = builder.databaseUserName
    /**
     * Describes the database details required to connect to an Amazon Redshift database.
     */
    val redshiftDatabase: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase? = builder.redshiftDatabase
    /**
     * The SQL query that is specified during CreateDataSourceFromRedshift. Returns only if Verbose is true in GetDataSourceInput.
     */
    val selectSqlQuery: kotlin.String? = builder.selectSqlQuery

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftMetadata(")
        append("databaseUserName=$databaseUserName,")
        append("redshiftDatabase=$redshiftDatabase,")
        append("selectSqlQuery=$selectSqlQuery)")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseUserName?.hashCode() ?: 0
        result = 31 * result + (redshiftDatabase?.hashCode() ?: 0)
        result = 31 * result + (selectSqlQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftMetadata

        if (databaseUserName != other.databaseUserName) return false
        if (redshiftDatabase != other.redshiftDatabase) return false
        if (selectSqlQuery != other.selectSqlQuery) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata = Builder(this).apply(block).build()

    class Builder {
        /**
         * A username to be used by Amazon Machine Learning (Amazon ML)to connect to a database on an Amazon Redshift cluster.
         * The username should have sufficient permissions to execute the RedshiftSelectSqlQuery query. The username should be valid for an Amazon Redshift <a href="https://docs.aws.amazon.com/redshift/latest/dg/r_CREATE_USER.html">USER.
         */
        var databaseUserName: kotlin.String? = null
        /**
         * Describes the database details required to connect to an Amazon Redshift database.
         */
        var redshiftDatabase: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase? = null
        /**
         * The SQL query that is specified during CreateDataSourceFromRedshift. Returns only if Verbose is true in GetDataSourceInput.
         */
        var selectSqlQuery: kotlin.String? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata) : this() {
            this.databaseUserName = x.databaseUserName
            this.redshiftDatabase = x.redshiftDatabase
            this.selectSqlQuery = x.selectSqlQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.machinelearning.model.RedshiftMetadata = RedshiftMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase] inside the given [block]
         */
        fun redshiftDatabase(block: aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase.Builder.() -> kotlin.Unit) {
            this.redshiftDatabase = aws.sdk.kotlin.services.machinelearning.model.RedshiftDatabase.invoke(block)
        }
    }
}
