// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.machinelearning.paginators

import aws.sdk.kotlin.services.machinelearning.MachineLearningClient
import aws.sdk.kotlin.services.machinelearning.model.BatchPrediction
import aws.sdk.kotlin.services.machinelearning.model.DataSource
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeBatchPredictionsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeDataSourcesResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeEvaluationsResponse
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsRequest
import aws.sdk.kotlin.services.machinelearning.model.DescribeMlModelsResponse
import aws.sdk.kotlin.services.machinelearning.model.Evaluation
import aws.sdk.kotlin.services.machinelearning.model.MlModel
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeBatchPredictionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeBatchPredictionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBatchPredictionsResponse]
 */
fun MachineLearningClient.describeBatchPredictionsPaginated(initialRequest: DescribeBatchPredictionsRequest): Flow<DescribeBatchPredictionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeBatchPredictionsPaginated.describeBatchPredictions(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeBatchPredictionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeBatchPredictionsResponse]
 */
fun MachineLearningClient.describeBatchPredictionsPaginated(block: DescribeBatchPredictionsRequest.Builder.() -> Unit): Flow<DescribeBatchPredictionsResponse> =
    describeBatchPredictionsPaginated(DescribeBatchPredictionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeBatchPredictionsPaginated]
 * to access the nested member [BatchPrediction]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [BatchPrediction]
 */
@JvmName("describeBatchPredictionsResponseBatchPrediction")
fun Flow<DescribeBatchPredictionsResponse>.results(): Flow<BatchPrediction> =
    transform() { response ->
        response.results?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeDataSourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSourcesResponse]
 */
fun MachineLearningClient.describeDataSourcesPaginated(initialRequest: DescribeDataSourcesRequest): Flow<DescribeDataSourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeDataSourcesPaginated.describeDataSources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeDataSourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeDataSourcesResponse]
 */
fun MachineLearningClient.describeDataSourcesPaginated(block: DescribeDataSourcesRequest.Builder.() -> Unit): Flow<DescribeDataSourcesResponse> =
    describeDataSourcesPaginated(DescribeDataSourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeDataSourcesPaginated]
 * to access the nested member [DataSource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DataSource]
 */
@JvmName("describeDataSourcesResponseDataSource")
fun Flow<DescribeDataSourcesResponse>.results(): Flow<DataSource> =
    transform() { response ->
        response.results?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEvaluationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEvaluationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEvaluationsResponse]
 */
fun MachineLearningClient.describeEvaluationsPaginated(initialRequest: DescribeEvaluationsRequest): Flow<DescribeEvaluationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEvaluationsPaginated.describeEvaluations(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEvaluationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEvaluationsResponse]
 */
fun MachineLearningClient.describeEvaluationsPaginated(block: DescribeEvaluationsRequest.Builder.() -> Unit): Flow<DescribeEvaluationsResponse> =
    describeEvaluationsPaginated(DescribeEvaluationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEvaluationsPaginated]
 * to access the nested member [Evaluation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Evaluation]
 */
@JvmName("describeEvaluationsResponseEvaluation")
fun Flow<DescribeEvaluationsResponse>.results(): Flow<Evaluation> =
    transform() { response ->
        response.results?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeMlModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeMlModelsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMlModelsResponse]
 */
fun MachineLearningClient.describeMlModelsPaginated(initialRequest: DescribeMlModelsRequest): Flow<DescribeMlModelsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeMlModelsPaginated.describeMlModels(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [DescribeMlModelsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeMlModelsResponse]
 */
fun MachineLearningClient.describeMlModelsPaginated(block: DescribeMlModelsRequest.Builder.() -> Unit): Flow<DescribeMlModelsResponse> =
    describeMlModelsPaginated(DescribeMlModelsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeMlModelsPaginated]
 * to access the nested member [MlModel]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MlModel]
 */
@JvmName("describeMlModelsResponseMlModel")
fun Flow<DescribeMlModelsResponse>.results(): Flow<MlModel> =
    transform() { response ->
        response.results?.forEach {
            emit(it)
        }
    }
