// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.macie2.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.macie2.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.macie2.model.*
import aws.sdk.kotlin.services.macie2.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Macie2"
public const val ServiceApiVersion: String = "2020-01-01"
public const val SdkVersion: String = "0.18.0-beta"

internal class DefaultMacie2Client(override val config: Macie2Client.Config) : Macie2Client {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     */
    override suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse {
        val op = SdkHttpOperation.build<AcceptInvitationRequest, AcceptInvitationResponse> {
            serializer = AcceptInvitationOperationSerializer()
            deserializer = AcceptInvitationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AcceptInvitation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("AcceptInvitation-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about one or more custom data identifiers.
     */
    override suspend fun batchGetCustomDataIdentifiers(input: BatchGetCustomDataIdentifiersRequest): BatchGetCustomDataIdentifiersResponse {
        val op = SdkHttpOperation.build<BatchGetCustomDataIdentifiersRequest, BatchGetCustomDataIdentifiersResponse> {
            serializer = BatchGetCustomDataIdentifiersOperationSerializer()
            deserializer = BatchGetCustomDataIdentifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchGetCustomDataIdentifiers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("BatchGetCustomDataIdentifiers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates and defines the settings for an allow list.
     */
    override suspend fun createAllowList(input: CreateAllowListRequest): CreateAllowListResponse {
        val op = SdkHttpOperation.build<CreateAllowListRequest, CreateAllowListResponse> {
            serializer = CreateAllowListOperationSerializer()
            deserializer = CreateAllowListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAllowList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateAllowList-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates and defines the settings for a classification job.
     */
    override suspend fun createClassificationJob(input: CreateClassificationJobRequest): CreateClassificationJobResponse {
        val op = SdkHttpOperation.build<CreateClassificationJobRequest, CreateClassificationJobResponse> {
            serializer = CreateClassificationJobOperationSerializer()
            deserializer = CreateClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateClassificationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateClassificationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates and defines the criteria and other settings for a custom data identifier.
     */
    override suspend fun createCustomDataIdentifier(input: CreateCustomDataIdentifierRequest): CreateCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<CreateCustomDataIdentifierRequest, CreateCustomDataIdentifierResponse> {
            serializer = CreateCustomDataIdentifierOperationSerializer()
            deserializer = CreateCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomDataIdentifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateCustomDataIdentifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates and defines the criteria and other settings for a findings filter.
     */
    override suspend fun createFindingsFilter(input: CreateFindingsFilterRequest): CreateFindingsFilterResponse {
        val op = SdkHttpOperation.build<CreateFindingsFilterRequest, CreateFindingsFilterResponse> {
            serializer = CreateFindingsFilterOperationSerializer()
            deserializer = CreateFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFindingsFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateFindingsFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Sends an Amazon Macie membership invitation to one or more accounts.
     */
    override suspend fun createInvitations(input: CreateInvitationsRequest): CreateInvitationsResponse {
        val op = SdkHttpOperation.build<CreateInvitationsRequest, CreateInvitationsResponse> {
            serializer = CreateInvitationsOperationSerializer()
            deserializer = CreateInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateInvitations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Associates an account with an Amazon Macie administrator account.
     */
    override suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse {
        val op = SdkHttpOperation.build<CreateMemberRequest, CreateMemberResponse> {
            serializer = CreateMemberOperationSerializer()
            deserializer = CreateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateMember-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates sample findings.
     */
    override suspend fun createSampleFindings(input: CreateSampleFindingsRequest): CreateSampleFindingsResponse {
        val op = SdkHttpOperation.build<CreateSampleFindingsRequest, CreateSampleFindingsResponse> {
            serializer = CreateSampleFindingsOperationSerializer()
            deserializer = CreateSampleFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSampleFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateSampleFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     */
    override suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse {
        val op = SdkHttpOperation.build<DeclineInvitationsRequest, DeclineInvitationsResponse> {
            serializer = DeclineInvitationsOperationSerializer()
            deserializer = DeclineInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeclineInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeclineInvitations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes an allow list.
     */
    override suspend fun deleteAllowList(input: DeleteAllowListRequest): DeleteAllowListResponse {
        val op = SdkHttpOperation.build<DeleteAllowListRequest, DeleteAllowListResponse> {
            serializer = DeleteAllowListOperationSerializer()
            deserializer = DeleteAllowListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAllowList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteAllowList-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Soft deletes a custom data identifier.
     */
    override suspend fun deleteCustomDataIdentifier(input: DeleteCustomDataIdentifierRequest): DeleteCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<DeleteCustomDataIdentifierRequest, DeleteCustomDataIdentifierResponse> {
            serializer = DeleteCustomDataIdentifierOperationSerializer()
            deserializer = DeleteCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomDataIdentifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteCustomDataIdentifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a findings filter.
     */
    override suspend fun deleteFindingsFilter(input: DeleteFindingsFilterRequest): DeleteFindingsFilterResponse {
        val op = SdkHttpOperation.build<DeleteFindingsFilterRequest, DeleteFindingsFilterResponse> {
            serializer = DeleteFindingsFilterOperationSerializer()
            deserializer = DeleteFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFindingsFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteFindingsFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     */
    override suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse {
        val op = SdkHttpOperation.build<DeleteInvitationsRequest, DeleteInvitationsResponse> {
            serializer = DeleteInvitationsOperationSerializer()
            deserializer = DeleteInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteInvitations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the association between an Amazon Macie administrator account and an account.
     */
    override suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse {
        val op = SdkHttpOperation.build<DeleteMemberRequest, DeleteMemberResponse> {
            serializer = DeleteMemberOperationSerializer()
            deserializer = DeleteMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteMember-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.
     */
    override suspend fun describeBuckets(input: DescribeBucketsRequest): DescribeBucketsResponse {
        val op = SdkHttpOperation.build<DescribeBucketsRequest, DescribeBucketsResponse> {
            serializer = DescribeBucketsOperationSerializer()
            deserializer = DescribeBucketsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeBuckets"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeBuckets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the status and settings for a classification job.
     */
    override suspend fun describeClassificationJob(input: DescribeClassificationJobRequest): DescribeClassificationJobResponse {
        val op = SdkHttpOperation.build<DescribeClassificationJobRequest, DescribeClassificationJobResponse> {
            serializer = DescribeClassificationJobOperationSerializer()
            deserializer = DescribeClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeClassificationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeClassificationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the Amazon Macie configuration settings for an organization in Organizations.
     */
    override suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest): DescribeOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<DescribeOrganizationConfigurationRequest, DescribeOrganizationConfigurationResponse> {
            serializer = DescribeOrganizationConfigurationOperationSerializer()
            deserializer = DescribeOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeOrganizationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DescribeOrganizationConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables Amazon Macie and deletes all settings and resources for a Macie account.
     */
    override suspend fun disableMacie(input: DisableMacieRequest): DisableMacieResponse {
        val op = SdkHttpOperation.build<DisableMacieRequest, DisableMacieResponse> {
            serializer = DisableMacieOperationSerializer()
            deserializer = DisableMacieOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableMacie"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisableMacie-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     */
    override suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<DisableOrganizationAdminAccountRequest, DisableOrganizationAdminAccountResponse> {
            serializer = DisableOrganizationAdminAccountOperationSerializer()
            deserializer = DisableOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisableOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisableOrganizationAdminAccount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates a member account from its Amazon Macie administrator account.
     */
    override suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest): DisassociateFromAdministratorAccountResponse {
        val op = SdkHttpOperation.build<DisassociateFromAdministratorAccountRequest, DisassociateFromAdministratorAccountResponse> {
            serializer = DisassociateFromAdministratorAccountOperationSerializer()
            deserializer = DisassociateFromAdministratorAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFromAdministratorAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisassociateFromAdministratorAccount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link>DisassociateFromAdministratorAccount operation.
     */
    override suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest): DisassociateFromMasterAccountResponse {
        val op = SdkHttpOperation.build<DisassociateFromMasterAccountRequest, DisassociateFromMasterAccountResponse> {
            serializer = DisassociateFromMasterAccountOperationSerializer()
            deserializer = DisassociateFromMasterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateFromMasterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisassociateFromMasterAccount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Disassociates an Amazon Macie administrator account from a member account.
     */
    override suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse {
        val op = SdkHttpOperation.build<DisassociateMemberRequest, DisassociateMemberResponse> {
            serializer = DisassociateMemberOperationSerializer()
            deserializer = DisassociateMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DisassociateMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DisassociateMember-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     */
    override suspend fun enableMacie(input: EnableMacieRequest): EnableMacieResponse {
        val op = SdkHttpOperation.build<EnableMacieRequest, EnableMacieResponse> {
            serializer = EnableMacieOperationSerializer()
            deserializer = EnableMacieOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableMacie"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("EnableMacie-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     */
    override suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse {
        val op = SdkHttpOperation.build<EnableOrganizationAdminAccountRequest, EnableOrganizationAdminAccountResponse> {
            serializer = EnableOrganizationAdminAccountOperationSerializer()
            deserializer = EnableOrganizationAdminAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "EnableOrganizationAdminAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("EnableOrganizationAdminAccount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the Amazon Macie administrator account for an account.
     */
    override suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest): GetAdministratorAccountResponse {
        val op = SdkHttpOperation.build<GetAdministratorAccountRequest, GetAdministratorAccountResponse> {
            serializer = GetAdministratorAccountOperationSerializer()
            deserializer = GetAdministratorAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAdministratorAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetAdministratorAccount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the settings and status of an allow list.
     */
    override suspend fun getAllowList(input: GetAllowListRequest): GetAllowListResponse {
        val op = SdkHttpOperation.build<GetAllowListRequest, GetAllowListResponse> {
            serializer = GetAllowListOperationSerializer()
            deserializer = GetAllowListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetAllowList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetAllowList-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) aggregated statistical data about S3 buckets that Amazon Macie monitors and analyzes.
     */
    override suspend fun getBucketStatistics(input: GetBucketStatisticsRequest): GetBucketStatisticsResponse {
        val op = SdkHttpOperation.build<GetBucketStatisticsRequest, GetBucketStatisticsResponse> {
            serializer = GetBucketStatisticsOperationSerializer()
            deserializer = GetBucketStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBucketStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetBucketStatistics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the configuration settings for storing data classification results.
     */
    override suspend fun getClassificationExportConfiguration(input: GetClassificationExportConfigurationRequest): GetClassificationExportConfigurationResponse {
        val op = SdkHttpOperation.build<GetClassificationExportConfigurationRequest, GetClassificationExportConfigurationResponse> {
            serializer = GetClassificationExportConfigurationOperationSerializer()
            deserializer = GetClassificationExportConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetClassificationExportConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetClassificationExportConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the criteria and other settings for a custom data identifier.
     */
    override suspend fun getCustomDataIdentifier(input: GetCustomDataIdentifierRequest): GetCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<GetCustomDataIdentifierRequest, GetCustomDataIdentifierResponse> {
            serializer = GetCustomDataIdentifierOperationSerializer()
            deserializer = GetCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetCustomDataIdentifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetCustomDataIdentifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) aggregated statistical data about findings.
     */
    override suspend fun getFindingStatistics(input: GetFindingStatisticsRequest): GetFindingStatisticsResponse {
        val op = SdkHttpOperation.build<GetFindingStatisticsRequest, GetFindingStatisticsResponse> {
            serializer = GetFindingStatisticsOperationSerializer()
            deserializer = GetFindingStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetFindingStatistics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the details of one or more findings.
     */
    override suspend fun getFindings(input: GetFindingsRequest): GetFindingsResponse {
        val op = SdkHttpOperation.build<GetFindingsRequest, GetFindingsResponse> {
            serializer = GetFindingsOperationSerializer()
            deserializer = GetFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the criteria and other settings for a findings filter.
     */
    override suspend fun getFindingsFilter(input: GetFindingsFilterRequest): GetFindingsFilterResponse {
        val op = SdkHttpOperation.build<GetFindingsFilterRequest, GetFindingsFilterResponse> {
            serializer = GetFindingsFilterOperationSerializer()
            deserializer = GetFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingsFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetFindingsFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the configuration settings for publishing findings to Security Hub.
     */
    override suspend fun getFindingsPublicationConfiguration(input: GetFindingsPublicationConfigurationRequest): GetFindingsPublicationConfigurationResponse {
        val op = SdkHttpOperation.build<GetFindingsPublicationConfigurationRequest, GetFindingsPublicationConfigurationResponse> {
            serializer = GetFindingsPublicationConfigurationOperationSerializer()
            deserializer = GetFindingsPublicationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetFindingsPublicationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetFindingsPublicationConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     */
    override suspend fun getInvitationsCount(input: GetInvitationsCountRequest): GetInvitationsCountResponse {
        val op = SdkHttpOperation.build<GetInvitationsCountRequest, GetInvitationsCountResponse> {
            serializer = GetInvitationsCountOperationSerializer()
            deserializer = GetInvitationsCountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetInvitationsCount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetInvitationsCount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     */
    override suspend fun getMacieSession(input: GetMacieSessionRequest): GetMacieSessionResponse {
        val op = SdkHttpOperation.build<GetMacieSessionRequest, GetMacieSessionResponse> {
            serializer = GetMacieSessionOperationSerializer()
            deserializer = GetMacieSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMacieSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetMacieSession-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link>GetAdministratorAccount operation.
     */
    override suspend fun getMasterAccount(input: GetMasterAccountRequest): GetMasterAccountResponse {
        val op = SdkHttpOperation.build<GetMasterAccountRequest, GetMasterAccountResponse> {
            serializer = GetMasterAccountOperationSerializer()
            deserializer = GetMasterAccountOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMasterAccount"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetMasterAccount-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     */
    override suspend fun getMember(input: GetMemberRequest): GetMemberResponse {
        val op = SdkHttpOperation.build<GetMemberRequest, GetMemberResponse> {
            serializer = GetMemberOperationSerializer()
            deserializer = GetMemberOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetMember"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetMember-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
     */
    override suspend fun getRevealConfiguration(input: GetRevealConfigurationRequest): GetRevealConfigurationResponse {
        val op = SdkHttpOperation.build<GetRevealConfigurationRequest, GetRevealConfigurationResponse> {
            serializer = GetRevealConfigurationOperationSerializer()
            deserializer = GetRevealConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRevealConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetRevealConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves occurrences of sensitive data reported by a finding.
     */
    override suspend fun getSensitiveDataOccurrences(input: GetSensitiveDataOccurrencesRequest): GetSensitiveDataOccurrencesResponse {
        val op = SdkHttpOperation.build<GetSensitiveDataOccurrencesRequest, GetSensitiveDataOccurrencesResponse> {
            serializer = GetSensitiveDataOccurrencesOperationSerializer()
            deserializer = GetSensitiveDataOccurrencesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSensitiveDataOccurrences"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetSensitiveDataOccurrences-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Checks whether occurrences of sensitive data can be retrieved for a finding.
     */
    override suspend fun getSensitiveDataOccurrencesAvailability(input: GetSensitiveDataOccurrencesAvailabilityRequest): GetSensitiveDataOccurrencesAvailabilityResponse {
        val op = SdkHttpOperation.build<GetSensitiveDataOccurrencesAvailabilityRequest, GetSensitiveDataOccurrencesAvailabilityResponse> {
            serializer = GetSensitiveDataOccurrencesAvailabilityOperationSerializer()
            deserializer = GetSensitiveDataOccurrencesAvailabilityOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetSensitiveDataOccurrencesAvailability"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetSensitiveDataOccurrencesAvailability-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     */
    override suspend fun getUsageStatistics(input: GetUsageStatisticsRequest): GetUsageStatisticsResponse {
        val op = SdkHttpOperation.build<GetUsageStatisticsRequest, GetUsageStatisticsResponse> {
            serializer = GetUsageStatisticsOperationSerializer()
            deserializer = GetUsageStatisticsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsageStatistics"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetUsageStatistics-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) aggregated usage data for an account.
     */
    override suspend fun getUsageTotals(input: GetUsageTotalsRequest): GetUsageTotalsResponse {
        val op = SdkHttpOperation.build<GetUsageTotalsRequest, GetUsageTotalsResponse> {
            serializer = GetUsageTotalsOperationSerializer()
            deserializer = GetUsageTotalsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetUsageTotals"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetUsageTotals-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a subset of information about all the allow lists for an account.
     */
    override suspend fun listAllowLists(input: ListAllowListsRequest): ListAllowListsResponse {
        val op = SdkHttpOperation.build<ListAllowListsRequest, ListAllowListsResponse> {
            serializer = ListAllowListsOperationSerializer()
            deserializer = ListAllowListsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAllowLists"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListAllowLists-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a subset of information about one or more classification jobs.
     */
    override suspend fun listClassificationJobs(input: ListClassificationJobsRequest): ListClassificationJobsResponse {
        val op = SdkHttpOperation.build<ListClassificationJobsRequest, ListClassificationJobsResponse> {
            serializer = ListClassificationJobsOperationSerializer()
            deserializer = ListClassificationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListClassificationJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListClassificationJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a subset of information about all the custom data identifiers for an account.
     */
    override suspend fun listCustomDataIdentifiers(input: ListCustomDataIdentifiersRequest): ListCustomDataIdentifiersResponse {
        val op = SdkHttpOperation.build<ListCustomDataIdentifiersRequest, ListCustomDataIdentifiersResponse> {
            serializer = ListCustomDataIdentifiersOperationSerializer()
            deserializer = ListCustomDataIdentifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomDataIdentifiers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListCustomDataIdentifiers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a subset of information about one or more findings.
     */
    override suspend fun listFindings(input: ListFindingsRequest): ListFindingsResponse {
        val op = SdkHttpOperation.build<ListFindingsRequest, ListFindingsResponse> {
            serializer = ListFindingsOperationSerializer()
            deserializer = ListFindingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindings"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListFindings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves a subset of information about all the findings filters for an account.
     */
    override suspend fun listFindingsFilters(input: ListFindingsFiltersRequest): ListFindingsFiltersResponse {
        val op = SdkHttpOperation.build<ListFindingsFiltersRequest, ListFindingsFiltersResponse> {
            serializer = ListFindingsFiltersOperationSerializer()
            deserializer = ListFindingsFiltersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFindingsFilters"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListFindingsFilters-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     */
    override suspend fun listInvitations(input: ListInvitationsRequest): ListInvitationsResponse {
        val op = SdkHttpOperation.build<ListInvitationsRequest, ListInvitationsResponse> {
            serializer = ListInvitationsOperationSerializer()
            deserializer = ListInvitationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListInvitations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListInvitations-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
     */
    override suspend fun listManagedDataIdentifiers(input: ListManagedDataIdentifiersRequest): ListManagedDataIdentifiersResponse {
        val op = SdkHttpOperation.build<ListManagedDataIdentifiersRequest, ListManagedDataIdentifiersResponse> {
            serializer = ListManagedDataIdentifiersOperationSerializer()
            deserializer = ListManagedDataIdentifiersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListManagedDataIdentifiers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListManagedDataIdentifiers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     */
    override suspend fun listMembers(input: ListMembersRequest): ListMembersResponse {
        val op = SdkHttpOperation.build<ListMembersRequest, ListMembersResponse> {
            serializer = ListMembersOperationSerializer()
            deserializer = ListMembersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListMembers"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListMembers-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in Organizations.
     */
    override suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest): ListOrganizationAdminAccountsResponse {
        val op = SdkHttpOperation.build<ListOrganizationAdminAccountsRequest, ListOrganizationAdminAccountsResponse> {
            serializer = ListOrganizationAdminAccountsOperationSerializer()
            deserializer = ListOrganizationAdminAccountsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListOrganizationAdminAccounts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListOrganizationAdminAccounts-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves the tags (keys and values) that are associated with an Amazon Macie resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates or updates the configuration settings for storing data classification results.
     */
    override suspend fun putClassificationExportConfiguration(input: PutClassificationExportConfigurationRequest): PutClassificationExportConfigurationResponse {
        val op = SdkHttpOperation.build<PutClassificationExportConfigurationRequest, PutClassificationExportConfigurationResponse> {
            serializer = PutClassificationExportConfigurationOperationSerializer()
            deserializer = PutClassificationExportConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutClassificationExportConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutClassificationExportConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the configuration settings for publishing findings to Security Hub.
     */
    override suspend fun putFindingsPublicationConfiguration(input: PutFindingsPublicationConfigurationRequest): PutFindingsPublicationConfigurationResponse {
        val op = SdkHttpOperation.build<PutFindingsPublicationConfigurationRequest, PutFindingsPublicationConfigurationResponse> {
            serializer = PutFindingsPublicationConfigurationOperationSerializer()
            deserializer = PutFindingsPublicationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "PutFindingsPublicationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("PutFindingsPublicationConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.
     */
    override suspend fun searchResources(input: SearchResourcesRequest): SearchResourcesResponse {
        val op = SdkHttpOperation.build<SearchResourcesRequest, SearchResourcesResponse> {
            serializer = SearchResourcesOperationSerializer()
            deserializer = SearchResourcesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SearchResources"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("SearchResources-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds or updates one or more tags (keys and values) that are associated with an Amazon Macie resource.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tests a custom data identifier.
     */
    override suspend fun testCustomDataIdentifier(input: TestCustomDataIdentifierRequest): TestCustomDataIdentifierResponse {
        val op = SdkHttpOperation.build<TestCustomDataIdentifierRequest, TestCustomDataIdentifierResponse> {
            serializer = TestCustomDataIdentifierOperationSerializer()
            deserializer = TestCustomDataIdentifierOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TestCustomDataIdentifier"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TestCustomDataIdentifier-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes one or more tags (keys and values) from an Amazon Macie resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 204
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the settings for an allow list.
     */
    override suspend fun updateAllowList(input: UpdateAllowListRequest): UpdateAllowListResponse {
        val op = SdkHttpOperation.build<UpdateAllowListRequest, UpdateAllowListResponse> {
            serializer = UpdateAllowListOperationSerializer()
            deserializer = UpdateAllowListOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAllowList"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateAllowList-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Changes the status of a classification job.
     */
    override suspend fun updateClassificationJob(input: UpdateClassificationJobRequest): UpdateClassificationJobResponse {
        val op = SdkHttpOperation.build<UpdateClassificationJobRequest, UpdateClassificationJobResponse> {
            serializer = UpdateClassificationJobOperationSerializer()
            deserializer = UpdateClassificationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateClassificationJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateClassificationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the criteria and other settings for a findings filter.
     */
    override suspend fun updateFindingsFilter(input: UpdateFindingsFilterRequest): UpdateFindingsFilterResponse {
        val op = SdkHttpOperation.build<UpdateFindingsFilterRequest, UpdateFindingsFilterResponse> {
            serializer = UpdateFindingsFilterOperationSerializer()
            deserializer = UpdateFindingsFilterOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateFindingsFilter"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateFindingsFilter-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
     */
    override suspend fun updateMacieSession(input: UpdateMacieSessionRequest): UpdateMacieSessionResponse {
        val op = SdkHttpOperation.build<UpdateMacieSessionRequest, UpdateMacieSessionResponse> {
            serializer = UpdateMacieSessionOperationSerializer()
            deserializer = UpdateMacieSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMacieSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateMacieSession-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
     */
    override suspend fun updateMemberSession(input: UpdateMemberSessionRequest): UpdateMemberSessionResponse {
        val op = SdkHttpOperation.build<UpdateMemberSessionRequest, UpdateMemberSessionResponse> {
            serializer = UpdateMemberSessionOperationSerializer()
            deserializer = UpdateMemberSessionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateMemberSession"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateMemberSession-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the Amazon Macie configuration settings for an organization in Organizations.
     */
    override suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateOrganizationConfigurationRequest, UpdateOrganizationConfigurationResponse> {
            serializer = UpdateOrganizationConfigurationOperationSerializer()
            deserializer = UpdateOrganizationConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateOrganizationConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateOrganizationConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
     */
    override suspend fun updateRevealConfiguration(input: UpdateRevealConfigurationRequest): UpdateRevealConfigurationResponse {
        val op = SdkHttpOperation.build<UpdateRevealConfigurationRequest, UpdateRevealConfigurationResponse> {
            serializer = UpdateRevealConfigurationOperationSerializer()
            deserializer = UpdateRevealConfigurationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRevealConfiguration"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "macie2"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateRevealConfiguration-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "macie2")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
