// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.macie2.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.macie2.endpoints.EndpointProvider
import aws.sdk.kotlin.services.macie2.model.*
import aws.sdk.kotlin.services.macie2.model.AcceptInvitationRequest
import aws.sdk.kotlin.services.macie2.model.AcceptInvitationResponse
import aws.sdk.kotlin.services.macie2.model.BatchGetCustomDataIdentifiersRequest
import aws.sdk.kotlin.services.macie2.model.BatchGetCustomDataIdentifiersResponse
import aws.sdk.kotlin.services.macie2.model.CreateAllowListRequest
import aws.sdk.kotlin.services.macie2.model.CreateAllowListResponse
import aws.sdk.kotlin.services.macie2.model.CreateClassificationJobRequest
import aws.sdk.kotlin.services.macie2.model.CreateClassificationJobResponse
import aws.sdk.kotlin.services.macie2.model.CreateCustomDataIdentifierRequest
import aws.sdk.kotlin.services.macie2.model.CreateCustomDataIdentifierResponse
import aws.sdk.kotlin.services.macie2.model.CreateFindingsFilterRequest
import aws.sdk.kotlin.services.macie2.model.CreateFindingsFilterResponse
import aws.sdk.kotlin.services.macie2.model.CreateInvitationsRequest
import aws.sdk.kotlin.services.macie2.model.CreateInvitationsResponse
import aws.sdk.kotlin.services.macie2.model.CreateMemberRequest
import aws.sdk.kotlin.services.macie2.model.CreateMemberResponse
import aws.sdk.kotlin.services.macie2.model.CreateSampleFindingsRequest
import aws.sdk.kotlin.services.macie2.model.CreateSampleFindingsResponse
import aws.sdk.kotlin.services.macie2.model.DeclineInvitationsRequest
import aws.sdk.kotlin.services.macie2.model.DeclineInvitationsResponse
import aws.sdk.kotlin.services.macie2.model.DeleteAllowListRequest
import aws.sdk.kotlin.services.macie2.model.DeleteAllowListResponse
import aws.sdk.kotlin.services.macie2.model.DeleteCustomDataIdentifierRequest
import aws.sdk.kotlin.services.macie2.model.DeleteCustomDataIdentifierResponse
import aws.sdk.kotlin.services.macie2.model.DeleteFindingsFilterRequest
import aws.sdk.kotlin.services.macie2.model.DeleteFindingsFilterResponse
import aws.sdk.kotlin.services.macie2.model.DeleteInvitationsRequest
import aws.sdk.kotlin.services.macie2.model.DeleteInvitationsResponse
import aws.sdk.kotlin.services.macie2.model.DeleteMemberRequest
import aws.sdk.kotlin.services.macie2.model.DeleteMemberResponse
import aws.sdk.kotlin.services.macie2.model.DescribeBucketsRequest
import aws.sdk.kotlin.services.macie2.model.DescribeBucketsResponse
import aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobRequest
import aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobResponse
import aws.sdk.kotlin.services.macie2.model.DescribeOrganizationConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.DescribeOrganizationConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.DisableMacieRequest
import aws.sdk.kotlin.services.macie2.model.DisableMacieResponse
import aws.sdk.kotlin.services.macie2.model.DisableOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.macie2.model.DisableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.macie2.model.DisassociateFromAdministratorAccountRequest
import aws.sdk.kotlin.services.macie2.model.DisassociateFromAdministratorAccountResponse
import aws.sdk.kotlin.services.macie2.model.DisassociateFromMasterAccountRequest
import aws.sdk.kotlin.services.macie2.model.DisassociateFromMasterAccountResponse
import aws.sdk.kotlin.services.macie2.model.DisassociateMemberRequest
import aws.sdk.kotlin.services.macie2.model.DisassociateMemberResponse
import aws.sdk.kotlin.services.macie2.model.EnableMacieRequest
import aws.sdk.kotlin.services.macie2.model.EnableMacieResponse
import aws.sdk.kotlin.services.macie2.model.EnableOrganizationAdminAccountRequest
import aws.sdk.kotlin.services.macie2.model.EnableOrganizationAdminAccountResponse
import aws.sdk.kotlin.services.macie2.model.GetAdministratorAccountRequest
import aws.sdk.kotlin.services.macie2.model.GetAdministratorAccountResponse
import aws.sdk.kotlin.services.macie2.model.GetAllowListRequest
import aws.sdk.kotlin.services.macie2.model.GetAllowListResponse
import aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsRequest
import aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsResponse
import aws.sdk.kotlin.services.macie2.model.GetClassificationExportConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.GetClassificationExportConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.GetCustomDataIdentifierRequest
import aws.sdk.kotlin.services.macie2.model.GetCustomDataIdentifierResponse
import aws.sdk.kotlin.services.macie2.model.GetFindingStatisticsRequest
import aws.sdk.kotlin.services.macie2.model.GetFindingStatisticsResponse
import aws.sdk.kotlin.services.macie2.model.GetFindingsFilterRequest
import aws.sdk.kotlin.services.macie2.model.GetFindingsFilterResponse
import aws.sdk.kotlin.services.macie2.model.GetFindingsPublicationConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.GetFindingsPublicationConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.GetFindingsRequest
import aws.sdk.kotlin.services.macie2.model.GetFindingsResponse
import aws.sdk.kotlin.services.macie2.model.GetInvitationsCountRequest
import aws.sdk.kotlin.services.macie2.model.GetInvitationsCountResponse
import aws.sdk.kotlin.services.macie2.model.GetMacieSessionRequest
import aws.sdk.kotlin.services.macie2.model.GetMacieSessionResponse
import aws.sdk.kotlin.services.macie2.model.GetMasterAccountRequest
import aws.sdk.kotlin.services.macie2.model.GetMasterAccountResponse
import aws.sdk.kotlin.services.macie2.model.GetMemberRequest
import aws.sdk.kotlin.services.macie2.model.GetMemberResponse
import aws.sdk.kotlin.services.macie2.model.GetRevealConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.GetRevealConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityRequest
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesAvailabilityResponse
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesRequest
import aws.sdk.kotlin.services.macie2.model.GetSensitiveDataOccurrencesResponse
import aws.sdk.kotlin.services.macie2.model.GetUsageStatisticsRequest
import aws.sdk.kotlin.services.macie2.model.GetUsageStatisticsResponse
import aws.sdk.kotlin.services.macie2.model.GetUsageTotalsRequest
import aws.sdk.kotlin.services.macie2.model.GetUsageTotalsResponse
import aws.sdk.kotlin.services.macie2.model.ListAllowListsRequest
import aws.sdk.kotlin.services.macie2.model.ListAllowListsResponse
import aws.sdk.kotlin.services.macie2.model.ListClassificationJobsRequest
import aws.sdk.kotlin.services.macie2.model.ListClassificationJobsResponse
import aws.sdk.kotlin.services.macie2.model.ListCustomDataIdentifiersRequest
import aws.sdk.kotlin.services.macie2.model.ListCustomDataIdentifiersResponse
import aws.sdk.kotlin.services.macie2.model.ListFindingsFiltersRequest
import aws.sdk.kotlin.services.macie2.model.ListFindingsFiltersResponse
import aws.sdk.kotlin.services.macie2.model.ListFindingsRequest
import aws.sdk.kotlin.services.macie2.model.ListFindingsResponse
import aws.sdk.kotlin.services.macie2.model.ListInvitationsRequest
import aws.sdk.kotlin.services.macie2.model.ListInvitationsResponse
import aws.sdk.kotlin.services.macie2.model.ListManagedDataIdentifiersRequest
import aws.sdk.kotlin.services.macie2.model.ListManagedDataIdentifiersResponse
import aws.sdk.kotlin.services.macie2.model.ListMembersRequest
import aws.sdk.kotlin.services.macie2.model.ListMembersResponse
import aws.sdk.kotlin.services.macie2.model.ListOrganizationAdminAccountsRequest
import aws.sdk.kotlin.services.macie2.model.ListOrganizationAdminAccountsResponse
import aws.sdk.kotlin.services.macie2.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.macie2.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.macie2.model.PutClassificationExportConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.PutClassificationExportConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.PutFindingsPublicationConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.PutFindingsPublicationConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.SearchResourcesRequest
import aws.sdk.kotlin.services.macie2.model.SearchResourcesResponse
import aws.sdk.kotlin.services.macie2.model.TagResourceRequest
import aws.sdk.kotlin.services.macie2.model.TagResourceResponse
import aws.sdk.kotlin.services.macie2.model.TestCustomDataIdentifierRequest
import aws.sdk.kotlin.services.macie2.model.TestCustomDataIdentifierResponse
import aws.sdk.kotlin.services.macie2.model.UntagResourceRequest
import aws.sdk.kotlin.services.macie2.model.UntagResourceResponse
import aws.sdk.kotlin.services.macie2.model.UpdateAllowListRequest
import aws.sdk.kotlin.services.macie2.model.UpdateAllowListResponse
import aws.sdk.kotlin.services.macie2.model.UpdateClassificationJobRequest
import aws.sdk.kotlin.services.macie2.model.UpdateClassificationJobResponse
import aws.sdk.kotlin.services.macie2.model.UpdateFindingsFilterRequest
import aws.sdk.kotlin.services.macie2.model.UpdateFindingsFilterResponse
import aws.sdk.kotlin.services.macie2.model.UpdateMacieSessionRequest
import aws.sdk.kotlin.services.macie2.model.UpdateMacieSessionResponse
import aws.sdk.kotlin.services.macie2.model.UpdateMemberSessionRequest
import aws.sdk.kotlin.services.macie2.model.UpdateMemberSessionResponse
import aws.sdk.kotlin.services.macie2.model.UpdateOrganizationConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.UpdateOrganizationConfigurationResponse
import aws.sdk.kotlin.services.macie2.model.UpdateRevealConfigurationRequest
import aws.sdk.kotlin.services.macie2.model.UpdateRevealConfigurationResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.config.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig

/**
 * Amazon Macie is a fully managed data security and data privacy service that uses machine learning and pattern matching to discover and protect your sensitive data in AWS. Macie automates the discovery of sensitive data, such as PII and intellectual property, to provide you with insight into the data that your organization stores in AWS. Macie also provides an inventory of your Amazon S3 buckets, which it continually monitors for you. If Macie detects sensitive data or potential data access issues, it generates detailed findings for you to review and act upon as necessary.
 */
public interface Macie2Client : SdkClient {

    override val serviceName: String
        get() = "Macie2"
    /**
     * Macie2Client's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): Macie2Client {
            val config = Config.Builder().apply(block).build()
            return DefaultMacie2Client(config)
        }

        public operator fun invoke(config: Config): Macie2Client = DefaultMacie2Client(config)

        /**
         * Construct a [Macie2Client] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): Macie2Client {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultMacie2Client(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, IdempotencyTokenConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider? = builder.idempotencyTokenProvider
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "Macie2")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null
            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null
            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            public var idempotencyTokenProvider: IdempotencyTokenProvider? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null
            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null
            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false
            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts an Amazon Macie membership invitation that was received from a specific account.
     */
    public suspend fun acceptInvitation(input: AcceptInvitationRequest): AcceptInvitationResponse

    /**
     * Retrieves information about one or more custom data identifiers.
     */
    public suspend fun batchGetCustomDataIdentifiers(input: BatchGetCustomDataIdentifiersRequest = BatchGetCustomDataIdentifiersRequest {}): BatchGetCustomDataIdentifiersResponse

    /**
     * Creates and defines the settings for an allow list.
     */
    public suspend fun createAllowList(input: CreateAllowListRequest): CreateAllowListResponse

    /**
     * Creates and defines the settings for a classification job.
     */
    public suspend fun createClassificationJob(input: CreateClassificationJobRequest): CreateClassificationJobResponse

    /**
     * Creates and defines the criteria and other settings for a custom data identifier.
     */
    public suspend fun createCustomDataIdentifier(input: CreateCustomDataIdentifierRequest): CreateCustomDataIdentifierResponse

    /**
     * Creates and defines the criteria and other settings for a findings filter.
     */
    public suspend fun createFindingsFilter(input: CreateFindingsFilterRequest): CreateFindingsFilterResponse

    /**
     * Sends an Amazon Macie membership invitation to one or more accounts.
     */
    public suspend fun createInvitations(input: CreateInvitationsRequest): CreateInvitationsResponse

    /**
     * Associates an account with an Amazon Macie administrator account.
     */
    public suspend fun createMember(input: CreateMemberRequest): CreateMemberResponse

    /**
     * Creates sample findings.
     */
    public suspend fun createSampleFindings(input: CreateSampleFindingsRequest = CreateSampleFindingsRequest {}): CreateSampleFindingsResponse

    /**
     * Declines Amazon Macie membership invitations that were received from specific accounts.
     */
    public suspend fun declineInvitations(input: DeclineInvitationsRequest): DeclineInvitationsResponse

    /**
     * Deletes an allow list.
     */
    public suspend fun deleteAllowList(input: DeleteAllowListRequest): DeleteAllowListResponse

    /**
     * Soft deletes a custom data identifier.
     */
    public suspend fun deleteCustomDataIdentifier(input: DeleteCustomDataIdentifierRequest): DeleteCustomDataIdentifierResponse

    /**
     * Deletes a findings filter.
     */
    public suspend fun deleteFindingsFilter(input: DeleteFindingsFilterRequest): DeleteFindingsFilterResponse

    /**
     * Deletes Amazon Macie membership invitations that were received from specific accounts.
     */
    public suspend fun deleteInvitations(input: DeleteInvitationsRequest): DeleteInvitationsResponse

    /**
     * Deletes the association between an Amazon Macie administrator account and an account.
     */
    public suspend fun deleteMember(input: DeleteMemberRequest): DeleteMemberResponse

    /**
     * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.
     */
    public suspend fun describeBuckets(input: DescribeBucketsRequest = DescribeBucketsRequest {}): DescribeBucketsResponse

    /**
     * Retrieves the status and settings for a classification job.
     */
    public suspend fun describeClassificationJob(input: DescribeClassificationJobRequest): DescribeClassificationJobResponse

    /**
     * Retrieves the Amazon Macie configuration settings for an organization in Organizations.
     */
    public suspend fun describeOrganizationConfiguration(input: DescribeOrganizationConfigurationRequest = DescribeOrganizationConfigurationRequest {}): DescribeOrganizationConfigurationResponse

    /**
     * Disables Amazon Macie and deletes all settings and resources for a Macie account.
     */
    public suspend fun disableMacie(input: DisableMacieRequest = DisableMacieRequest {}): DisableMacieResponse

    /**
     * Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     */
    public suspend fun disableOrganizationAdminAccount(input: DisableOrganizationAdminAccountRequest): DisableOrganizationAdminAccountResponse

    /**
     * Disassociates a member account from its Amazon Macie administrator account.
     */
    public suspend fun disassociateFromAdministratorAccount(input: DisassociateFromAdministratorAccountRequest = DisassociateFromAdministratorAccountRequest {}): DisassociateFromAdministratorAccountResponse

    /**
     * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link>DisassociateFromAdministratorAccount operation.
     */
    public suspend fun disassociateFromMasterAccount(input: DisassociateFromMasterAccountRequest = DisassociateFromMasterAccountRequest {}): DisassociateFromMasterAccountResponse

    /**
     * Disassociates an Amazon Macie administrator account from a member account.
     */
    public suspend fun disassociateMember(input: DisassociateMemberRequest): DisassociateMemberResponse

    /**
     * Enables Amazon Macie and specifies the configuration settings for a Macie account.
     */
    public suspend fun enableMacie(input: EnableMacieRequest = EnableMacieRequest {}): EnableMacieResponse

    /**
     * Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
     */
    public suspend fun enableOrganizationAdminAccount(input: EnableOrganizationAdminAccountRequest): EnableOrganizationAdminAccountResponse

    /**
     * Retrieves information about the Amazon Macie administrator account for an account.
     */
    public suspend fun getAdministratorAccount(input: GetAdministratorAccountRequest = GetAdministratorAccountRequest {}): GetAdministratorAccountResponse

    /**
     * Retrieves the settings and status of an allow list.
     */
    public suspend fun getAllowList(input: GetAllowListRequest): GetAllowListResponse

    /**
     * Retrieves (queries) aggregated statistical data about S3 buckets that Amazon Macie monitors and analyzes.
     */
    public suspend fun getBucketStatistics(input: GetBucketStatisticsRequest = GetBucketStatisticsRequest {}): GetBucketStatisticsResponse

    /**
     * Retrieves the configuration settings for storing data classification results.
     */
    public suspend fun getClassificationExportConfiguration(input: GetClassificationExportConfigurationRequest = GetClassificationExportConfigurationRequest {}): GetClassificationExportConfigurationResponse

    /**
     * Retrieves the criteria and other settings for a custom data identifier.
     */
    public suspend fun getCustomDataIdentifier(input: GetCustomDataIdentifierRequest): GetCustomDataIdentifierResponse

    /**
     * Retrieves (queries) aggregated statistical data about findings.
     */
    public suspend fun getFindingStatistics(input: GetFindingStatisticsRequest): GetFindingStatisticsResponse

    /**
     * Retrieves the details of one or more findings.
     */
    public suspend fun getFindings(input: GetFindingsRequest): GetFindingsResponse

    /**
     * Retrieves the criteria and other settings for a findings filter.
     */
    public suspend fun getFindingsFilter(input: GetFindingsFilterRequest): GetFindingsFilterResponse

    /**
     * Retrieves the configuration settings for publishing findings to Security Hub.
     */
    public suspend fun getFindingsPublicationConfiguration(input: GetFindingsPublicationConfigurationRequest = GetFindingsPublicationConfigurationRequest {}): GetFindingsPublicationConfigurationResponse

    /**
     * Retrieves the count of Amazon Macie membership invitations that were received by an account.
     */
    public suspend fun getInvitationsCount(input: GetInvitationsCountRequest = GetInvitationsCountRequest {}): GetInvitationsCountResponse

    /**
     * Retrieves the current status and configuration settings for an Amazon Macie account.
     */
    public suspend fun getMacieSession(input: GetMacieSessionRequest = GetMacieSessionRequest {}): GetMacieSessionResponse

    /**
     * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link>GetAdministratorAccount operation.
     */
    public suspend fun getMasterAccount(input: GetMasterAccountRequest = GetMasterAccountRequest {}): GetMasterAccountResponse

    /**
     * Retrieves information about an account that's associated with an Amazon Macie administrator account.
     */
    public suspend fun getMember(input: GetMemberRequest): GetMemberResponse

    /**
     * Retrieves the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
     */
    public suspend fun getRevealConfiguration(input: GetRevealConfigurationRequest = GetRevealConfigurationRequest {}): GetRevealConfigurationResponse

    /**
     * Retrieves occurrences of sensitive data reported by a finding.
     */
    public suspend fun getSensitiveDataOccurrences(input: GetSensitiveDataOccurrencesRequest): GetSensitiveDataOccurrencesResponse

    /**
     * Checks whether occurrences of sensitive data can be retrieved for a finding.
     */
    public suspend fun getSensitiveDataOccurrencesAvailability(input: GetSensitiveDataOccurrencesAvailabilityRequest): GetSensitiveDataOccurrencesAvailabilityResponse

    /**
     * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
     */
    public suspend fun getUsageStatistics(input: GetUsageStatisticsRequest = GetUsageStatisticsRequest {}): GetUsageStatisticsResponse

    /**
     * Retrieves (queries) aggregated usage data for an account.
     */
    public suspend fun getUsageTotals(input: GetUsageTotalsRequest = GetUsageTotalsRequest {}): GetUsageTotalsResponse

    /**
     * Retrieves a subset of information about all the allow lists for an account.
     */
    public suspend fun listAllowLists(input: ListAllowListsRequest = ListAllowListsRequest {}): ListAllowListsResponse

    /**
     * Retrieves a subset of information about one or more classification jobs.
     */
    public suspend fun listClassificationJobs(input: ListClassificationJobsRequest = ListClassificationJobsRequest {}): ListClassificationJobsResponse

    /**
     * Retrieves a subset of information about all the custom data identifiers for an account.
     */
    public suspend fun listCustomDataIdentifiers(input: ListCustomDataIdentifiersRequest = ListCustomDataIdentifiersRequest {}): ListCustomDataIdentifiersResponse

    /**
     * Retrieves a subset of information about one or more findings.
     */
    public suspend fun listFindings(input: ListFindingsRequest = ListFindingsRequest {}): ListFindingsResponse

    /**
     * Retrieves a subset of information about all the findings filters for an account.
     */
    public suspend fun listFindingsFilters(input: ListFindingsFiltersRequest = ListFindingsFiltersRequest {}): ListFindingsFiltersResponse

    /**
     * Retrieves information about the Amazon Macie membership invitations that were received by an account.
     */
    public suspend fun listInvitations(input: ListInvitationsRequest = ListInvitationsRequest {}): ListInvitationsResponse

    /**
     * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
     */
    public suspend fun listManagedDataIdentifiers(input: ListManagedDataIdentifiersRequest = ListManagedDataIdentifiersRequest {}): ListManagedDataIdentifiersResponse

    /**
     * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
     */
    public suspend fun listMembers(input: ListMembersRequest = ListMembersRequest {}): ListMembersResponse

    /**
     * Retrieves information about the delegated Amazon Macie administrator account for an organization in Organizations.
     */
    public suspend fun listOrganizationAdminAccounts(input: ListOrganizationAdminAccountsRequest = ListOrganizationAdminAccountsRequest {}): ListOrganizationAdminAccountsResponse

    /**
     * Retrieves the tags (keys and values) that are associated with an Amazon Macie resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates or updates the configuration settings for storing data classification results.
     */
    public suspend fun putClassificationExportConfiguration(input: PutClassificationExportConfigurationRequest): PutClassificationExportConfigurationResponse

    /**
     * Updates the configuration settings for publishing findings to Security Hub.
     */
    public suspend fun putFindingsPublicationConfiguration(input: PutFindingsPublicationConfigurationRequest = PutFindingsPublicationConfigurationRequest {}): PutFindingsPublicationConfigurationResponse

    /**
     * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.
     */
    public suspend fun searchResources(input: SearchResourcesRequest = SearchResourcesRequest {}): SearchResourcesResponse

    /**
     * Adds or updates one or more tags (keys and values) that are associated with an Amazon Macie resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Tests a custom data identifier.
     */
    public suspend fun testCustomDataIdentifier(input: TestCustomDataIdentifierRequest): TestCustomDataIdentifierResponse

    /**
     * Removes one or more tags (keys and values) from an Amazon Macie resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the settings for an allow list.
     */
    public suspend fun updateAllowList(input: UpdateAllowListRequest): UpdateAllowListResponse

    /**
     * Changes the status of a classification job.
     */
    public suspend fun updateClassificationJob(input: UpdateClassificationJobRequest): UpdateClassificationJobResponse

    /**
     * Updates the criteria and other settings for a findings filter.
     */
    public suspend fun updateFindingsFilter(input: UpdateFindingsFilterRequest): UpdateFindingsFilterResponse

    /**
     * Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
     */
    public suspend fun updateMacieSession(input: UpdateMacieSessionRequest = UpdateMacieSessionRequest {}): UpdateMacieSessionResponse

    /**
     * Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
     */
    public suspend fun updateMemberSession(input: UpdateMemberSessionRequest): UpdateMemberSessionResponse

    /**
     * Updates the Amazon Macie configuration settings for an organization in Organizations.
     */
    public suspend fun updateOrganizationConfiguration(input: UpdateOrganizationConfigurationRequest): UpdateOrganizationConfigurationResponse

    /**
     * Updates the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
     */
    public suspend fun updateRevealConfiguration(input: UpdateRevealConfigurationRequest): UpdateRevealConfigurationResponse
}

/**
 * Accepts an Amazon Macie membership invitation that was received from a specific account.
 */
public suspend inline fun Macie2Client.acceptInvitation(crossinline block: AcceptInvitationRequest.Builder.() -> Unit): AcceptInvitationResponse = acceptInvitation(AcceptInvitationRequest.Builder().apply(block).build())

/**
 * Retrieves information about one or more custom data identifiers.
 */
public suspend inline fun Macie2Client.batchGetCustomDataIdentifiers(crossinline block: BatchGetCustomDataIdentifiersRequest.Builder.() -> Unit): BatchGetCustomDataIdentifiersResponse = batchGetCustomDataIdentifiers(BatchGetCustomDataIdentifiersRequest.Builder().apply(block).build())

/**
 * Creates and defines the settings for an allow list.
 */
public suspend inline fun Macie2Client.createAllowList(crossinline block: CreateAllowListRequest.Builder.() -> Unit): CreateAllowListResponse = createAllowList(CreateAllowListRequest.Builder().apply(block).build())

/**
 * Creates and defines the settings for a classification job.
 */
public suspend inline fun Macie2Client.createClassificationJob(crossinline block: CreateClassificationJobRequest.Builder.() -> Unit): CreateClassificationJobResponse = createClassificationJob(CreateClassificationJobRequest.Builder().apply(block).build())

/**
 * Creates and defines the criteria and other settings for a custom data identifier.
 */
public suspend inline fun Macie2Client.createCustomDataIdentifier(crossinline block: CreateCustomDataIdentifierRequest.Builder.() -> Unit): CreateCustomDataIdentifierResponse = createCustomDataIdentifier(CreateCustomDataIdentifierRequest.Builder().apply(block).build())

/**
 * Creates and defines the criteria and other settings for a findings filter.
 */
public suspend inline fun Macie2Client.createFindingsFilter(crossinline block: CreateFindingsFilterRequest.Builder.() -> Unit): CreateFindingsFilterResponse = createFindingsFilter(CreateFindingsFilterRequest.Builder().apply(block).build())

/**
 * Sends an Amazon Macie membership invitation to one or more accounts.
 */
public suspend inline fun Macie2Client.createInvitations(crossinline block: CreateInvitationsRequest.Builder.() -> Unit): CreateInvitationsResponse = createInvitations(CreateInvitationsRequest.Builder().apply(block).build())

/**
 * Associates an account with an Amazon Macie administrator account.
 */
public suspend inline fun Macie2Client.createMember(crossinline block: CreateMemberRequest.Builder.() -> Unit): CreateMemberResponse = createMember(CreateMemberRequest.Builder().apply(block).build())

/**
 * Creates sample findings.
 */
public suspend inline fun Macie2Client.createSampleFindings(crossinline block: CreateSampleFindingsRequest.Builder.() -> Unit): CreateSampleFindingsResponse = createSampleFindings(CreateSampleFindingsRequest.Builder().apply(block).build())

/**
 * Declines Amazon Macie membership invitations that were received from specific accounts.
 */
public suspend inline fun Macie2Client.declineInvitations(crossinline block: DeclineInvitationsRequest.Builder.() -> Unit): DeclineInvitationsResponse = declineInvitations(DeclineInvitationsRequest.Builder().apply(block).build())

/**
 * Deletes an allow list.
 */
public suspend inline fun Macie2Client.deleteAllowList(crossinline block: DeleteAllowListRequest.Builder.() -> Unit): DeleteAllowListResponse = deleteAllowList(DeleteAllowListRequest.Builder().apply(block).build())

/**
 * Soft deletes a custom data identifier.
 */
public suspend inline fun Macie2Client.deleteCustomDataIdentifier(crossinline block: DeleteCustomDataIdentifierRequest.Builder.() -> Unit): DeleteCustomDataIdentifierResponse = deleteCustomDataIdentifier(DeleteCustomDataIdentifierRequest.Builder().apply(block).build())

/**
 * Deletes a findings filter.
 */
public suspend inline fun Macie2Client.deleteFindingsFilter(crossinline block: DeleteFindingsFilterRequest.Builder.() -> Unit): DeleteFindingsFilterResponse = deleteFindingsFilter(DeleteFindingsFilterRequest.Builder().apply(block).build())

/**
 * Deletes Amazon Macie membership invitations that were received from specific accounts.
 */
public suspend inline fun Macie2Client.deleteInvitations(crossinline block: DeleteInvitationsRequest.Builder.() -> Unit): DeleteInvitationsResponse = deleteInvitations(DeleteInvitationsRequest.Builder().apply(block).build())

/**
 * Deletes the association between an Amazon Macie administrator account and an account.
 */
public suspend inline fun Macie2Client.deleteMember(crossinline block: DeleteMemberRequest.Builder.() -> Unit): DeleteMemberResponse = deleteMember(DeleteMemberRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) statistical data and other information about one or more S3 buckets that Amazon Macie monitors and analyzes.
 */
public suspend inline fun Macie2Client.describeBuckets(crossinline block: DescribeBucketsRequest.Builder.() -> Unit): DescribeBucketsResponse = describeBuckets(DescribeBucketsRequest.Builder().apply(block).build())

/**
 * Retrieves the status and settings for a classification job.
 */
public suspend inline fun Macie2Client.describeClassificationJob(crossinline block: DescribeClassificationJobRequest.Builder.() -> Unit): DescribeClassificationJobResponse = describeClassificationJob(DescribeClassificationJobRequest.Builder().apply(block).build())

/**
 * Retrieves the Amazon Macie configuration settings for an organization in Organizations.
 */
public suspend inline fun Macie2Client.describeOrganizationConfiguration(crossinline block: DescribeOrganizationConfigurationRequest.Builder.() -> Unit): DescribeOrganizationConfigurationResponse = describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Disables Amazon Macie and deletes all settings and resources for a Macie account.
 */
public suspend inline fun Macie2Client.disableMacie(crossinline block: DisableMacieRequest.Builder.() -> Unit): DisableMacieResponse = disableMacie(DisableMacieRequest.Builder().apply(block).build())

/**
 * Disables an account as the delegated Amazon Macie administrator account for an organization in Organizations.
 */
public suspend inline fun Macie2Client.disableOrganizationAdminAccount(crossinline block: DisableOrganizationAdminAccountRequest.Builder.() -> Unit): DisableOrganizationAdminAccountResponse = disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Disassociates a member account from its Amazon Macie administrator account.
 */
public suspend inline fun Macie2Client.disassociateFromAdministratorAccount(crossinline block: DisassociateFromAdministratorAccountRequest.Builder.() -> Unit): DisassociateFromAdministratorAccountResponse = disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.Builder().apply(block).build())

/**
 * (Deprecated) Disassociates a member account from its Amazon Macie administrator account. This operation has been replaced by the <link>DisassociateFromAdministratorAccount operation.
 */
public suspend inline fun Macie2Client.disassociateFromMasterAccount(crossinline block: DisassociateFromMasterAccountRequest.Builder.() -> Unit): DisassociateFromMasterAccountResponse = disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.Builder().apply(block).build())

/**
 * Disassociates an Amazon Macie administrator account from a member account.
 */
public suspend inline fun Macie2Client.disassociateMember(crossinline block: DisassociateMemberRequest.Builder.() -> Unit): DisassociateMemberResponse = disassociateMember(DisassociateMemberRequest.Builder().apply(block).build())

/**
 * Enables Amazon Macie and specifies the configuration settings for a Macie account.
 */
public suspend inline fun Macie2Client.enableMacie(crossinline block: EnableMacieRequest.Builder.() -> Unit): EnableMacieResponse = enableMacie(EnableMacieRequest.Builder().apply(block).build())

/**
 * Designates an account as the delegated Amazon Macie administrator account for an organization in Organizations.
 */
public suspend inline fun Macie2Client.enableOrganizationAdminAccount(crossinline block: EnableOrganizationAdminAccountRequest.Builder.() -> Unit): EnableOrganizationAdminAccountResponse = enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.Builder().apply(block).build())

/**
 * Retrieves information about the Amazon Macie administrator account for an account.
 */
public suspend inline fun Macie2Client.getAdministratorAccount(crossinline block: GetAdministratorAccountRequest.Builder.() -> Unit): GetAdministratorAccountResponse = getAdministratorAccount(GetAdministratorAccountRequest.Builder().apply(block).build())

/**
 * Retrieves the settings and status of an allow list.
 */
public suspend inline fun Macie2Client.getAllowList(crossinline block: GetAllowListRequest.Builder.() -> Unit): GetAllowListResponse = getAllowList(GetAllowListRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) aggregated statistical data about S3 buckets that Amazon Macie monitors and analyzes.
 */
public suspend inline fun Macie2Client.getBucketStatistics(crossinline block: GetBucketStatisticsRequest.Builder.() -> Unit): GetBucketStatisticsResponse = getBucketStatistics(GetBucketStatisticsRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration settings for storing data classification results.
 */
public suspend inline fun Macie2Client.getClassificationExportConfiguration(crossinline block: GetClassificationExportConfigurationRequest.Builder.() -> Unit): GetClassificationExportConfigurationResponse = getClassificationExportConfiguration(GetClassificationExportConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the criteria and other settings for a custom data identifier.
 */
public suspend inline fun Macie2Client.getCustomDataIdentifier(crossinline block: GetCustomDataIdentifierRequest.Builder.() -> Unit): GetCustomDataIdentifierResponse = getCustomDataIdentifier(GetCustomDataIdentifierRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) aggregated statistical data about findings.
 */
public suspend inline fun Macie2Client.getFindingStatistics(crossinline block: GetFindingStatisticsRequest.Builder.() -> Unit): GetFindingStatisticsResponse = getFindingStatistics(GetFindingStatisticsRequest.Builder().apply(block).build())

/**
 * Retrieves the details of one or more findings.
 */
public suspend inline fun Macie2Client.getFindings(crossinline block: GetFindingsRequest.Builder.() -> Unit): GetFindingsResponse = getFindings(GetFindingsRequest.Builder().apply(block).build())

/**
 * Retrieves the criteria and other settings for a findings filter.
 */
public suspend inline fun Macie2Client.getFindingsFilter(crossinline block: GetFindingsFilterRequest.Builder.() -> Unit): GetFindingsFilterResponse = getFindingsFilter(GetFindingsFilterRequest.Builder().apply(block).build())

/**
 * Retrieves the configuration settings for publishing findings to Security Hub.
 */
public suspend inline fun Macie2Client.getFindingsPublicationConfiguration(crossinline block: GetFindingsPublicationConfigurationRequest.Builder.() -> Unit): GetFindingsPublicationConfigurationResponse = getFindingsPublicationConfiguration(GetFindingsPublicationConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the count of Amazon Macie membership invitations that were received by an account.
 */
public suspend inline fun Macie2Client.getInvitationsCount(crossinline block: GetInvitationsCountRequest.Builder.() -> Unit): GetInvitationsCountResponse = getInvitationsCount(GetInvitationsCountRequest.Builder().apply(block).build())

/**
 * Retrieves the current status and configuration settings for an Amazon Macie account.
 */
public suspend inline fun Macie2Client.getMacieSession(crossinline block: GetMacieSessionRequest.Builder.() -> Unit): GetMacieSessionResponse = getMacieSession(GetMacieSessionRequest.Builder().apply(block).build())

/**
 * (Deprecated) Retrieves information about the Amazon Macie administrator account for an account. This operation has been replaced by the <link>GetAdministratorAccount operation.
 */
public suspend inline fun Macie2Client.getMasterAccount(crossinline block: GetMasterAccountRequest.Builder.() -> Unit): GetMasterAccountResponse = getMasterAccount(GetMasterAccountRequest.Builder().apply(block).build())

/**
 * Retrieves information about an account that's associated with an Amazon Macie administrator account.
 */
public suspend inline fun Macie2Client.getMember(crossinline block: GetMemberRequest.Builder.() -> Unit): GetMemberResponse = getMember(GetMemberRequest.Builder().apply(block).build())

/**
 * Retrieves the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
 */
public suspend inline fun Macie2Client.getRevealConfiguration(crossinline block: GetRevealConfigurationRequest.Builder.() -> Unit): GetRevealConfigurationResponse = getRevealConfiguration(GetRevealConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves occurrences of sensitive data reported by a finding.
 */
public suspend inline fun Macie2Client.getSensitiveDataOccurrences(crossinline block: GetSensitiveDataOccurrencesRequest.Builder.() -> Unit): GetSensitiveDataOccurrencesResponse = getSensitiveDataOccurrences(GetSensitiveDataOccurrencesRequest.Builder().apply(block).build())

/**
 * Checks whether occurrences of sensitive data can be retrieved for a finding.
 */
public suspend inline fun Macie2Client.getSensitiveDataOccurrencesAvailability(crossinline block: GetSensitiveDataOccurrencesAvailabilityRequest.Builder.() -> Unit): GetSensitiveDataOccurrencesAvailabilityResponse = getSensitiveDataOccurrencesAvailability(GetSensitiveDataOccurrencesAvailabilityRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) quotas and aggregated usage data for one or more accounts.
 */
public suspend inline fun Macie2Client.getUsageStatistics(crossinline block: GetUsageStatisticsRequest.Builder.() -> Unit): GetUsageStatisticsResponse = getUsageStatistics(GetUsageStatisticsRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) aggregated usage data for an account.
 */
public suspend inline fun Macie2Client.getUsageTotals(crossinline block: GetUsageTotalsRequest.Builder.() -> Unit): GetUsageTotalsResponse = getUsageTotals(GetUsageTotalsRequest.Builder().apply(block).build())

/**
 * Retrieves a subset of information about all the allow lists for an account.
 */
public suspend inline fun Macie2Client.listAllowLists(crossinline block: ListAllowListsRequest.Builder.() -> Unit): ListAllowListsResponse = listAllowLists(ListAllowListsRequest.Builder().apply(block).build())

/**
 * Retrieves a subset of information about one or more classification jobs.
 */
public suspend inline fun Macie2Client.listClassificationJobs(crossinline block: ListClassificationJobsRequest.Builder.() -> Unit): ListClassificationJobsResponse = listClassificationJobs(ListClassificationJobsRequest.Builder().apply(block).build())

/**
 * Retrieves a subset of information about all the custom data identifiers for an account.
 */
public suspend inline fun Macie2Client.listCustomDataIdentifiers(crossinline block: ListCustomDataIdentifiersRequest.Builder.() -> Unit): ListCustomDataIdentifiersResponse = listCustomDataIdentifiers(ListCustomDataIdentifiersRequest.Builder().apply(block).build())

/**
 * Retrieves a subset of information about one or more findings.
 */
public suspend inline fun Macie2Client.listFindings(crossinline block: ListFindingsRequest.Builder.() -> Unit): ListFindingsResponse = listFindings(ListFindingsRequest.Builder().apply(block).build())

/**
 * Retrieves a subset of information about all the findings filters for an account.
 */
public suspend inline fun Macie2Client.listFindingsFilters(crossinline block: ListFindingsFiltersRequest.Builder.() -> Unit): ListFindingsFiltersResponse = listFindingsFilters(ListFindingsFiltersRequest.Builder().apply(block).build())

/**
 * Retrieves information about the Amazon Macie membership invitations that were received by an account.
 */
public suspend inline fun Macie2Client.listInvitations(crossinline block: ListInvitationsRequest.Builder.() -> Unit): ListInvitationsResponse = listInvitations(ListInvitationsRequest.Builder().apply(block).build())

/**
 * Retrieves information about all the managed data identifiers that Amazon Macie currently provides.
 */
public suspend inline fun Macie2Client.listManagedDataIdentifiers(crossinline block: ListManagedDataIdentifiersRequest.Builder.() -> Unit): ListManagedDataIdentifiersResponse = listManagedDataIdentifiers(ListManagedDataIdentifiersRequest.Builder().apply(block).build())

/**
 * Retrieves information about the accounts that are associated with an Amazon Macie administrator account.
 */
public suspend inline fun Macie2Client.listMembers(crossinline block: ListMembersRequest.Builder.() -> Unit): ListMembersResponse = listMembers(ListMembersRequest.Builder().apply(block).build())

/**
 * Retrieves information about the delegated Amazon Macie administrator account for an organization in Organizations.
 */
public suspend inline fun Macie2Client.listOrganizationAdminAccounts(crossinline block: ListOrganizationAdminAccountsRequest.Builder.() -> Unit): ListOrganizationAdminAccountsResponse = listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.Builder().apply(block).build())

/**
 * Retrieves the tags (keys and values) that are associated with an Amazon Macie resource.
 */
public suspend inline fun Macie2Client.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates or updates the configuration settings for storing data classification results.
 */
public suspend inline fun Macie2Client.putClassificationExportConfiguration(crossinline block: PutClassificationExportConfigurationRequest.Builder.() -> Unit): PutClassificationExportConfigurationResponse = putClassificationExportConfiguration(PutClassificationExportConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the configuration settings for publishing findings to Security Hub.
 */
public suspend inline fun Macie2Client.putFindingsPublicationConfiguration(crossinline block: PutFindingsPublicationConfigurationRequest.Builder.() -> Unit): PutFindingsPublicationConfigurationResponse = putFindingsPublicationConfiguration(PutFindingsPublicationConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves (queries) statistical data and other information about Amazon Web Services resources that Amazon Macie monitors and analyzes.
 */
public suspend inline fun Macie2Client.searchResources(crossinline block: SearchResourcesRequest.Builder.() -> Unit): SearchResourcesResponse = searchResources(SearchResourcesRequest.Builder().apply(block).build())

/**
 * Adds or updates one or more tags (keys and values) that are associated with an Amazon Macie resource.
 */
public suspend inline fun Macie2Client.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Tests a custom data identifier.
 */
public suspend inline fun Macie2Client.testCustomDataIdentifier(crossinline block: TestCustomDataIdentifierRequest.Builder.() -> Unit): TestCustomDataIdentifierResponse = testCustomDataIdentifier(TestCustomDataIdentifierRequest.Builder().apply(block).build())

/**
 * Removes one or more tags (keys and values) from an Amazon Macie resource.
 */
public suspend inline fun Macie2Client.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the settings for an allow list.
 */
public suspend inline fun Macie2Client.updateAllowList(crossinline block: UpdateAllowListRequest.Builder.() -> Unit): UpdateAllowListResponse = updateAllowList(UpdateAllowListRequest.Builder().apply(block).build())

/**
 * Changes the status of a classification job.
 */
public suspend inline fun Macie2Client.updateClassificationJob(crossinline block: UpdateClassificationJobRequest.Builder.() -> Unit): UpdateClassificationJobResponse = updateClassificationJob(UpdateClassificationJobRequest.Builder().apply(block).build())

/**
 * Updates the criteria and other settings for a findings filter.
 */
public suspend inline fun Macie2Client.updateFindingsFilter(crossinline block: UpdateFindingsFilterRequest.Builder.() -> Unit): UpdateFindingsFilterResponse = updateFindingsFilter(UpdateFindingsFilterRequest.Builder().apply(block).build())

/**
 * Suspends or re-enables Amazon Macie, or updates the configuration settings for a Macie account.
 */
public suspend inline fun Macie2Client.updateMacieSession(crossinline block: UpdateMacieSessionRequest.Builder.() -> Unit): UpdateMacieSessionResponse = updateMacieSession(UpdateMacieSessionRequest.Builder().apply(block).build())

/**
 * Enables an Amazon Macie administrator to suspend or re-enable Macie for a member account.
 */
public suspend inline fun Macie2Client.updateMemberSession(crossinline block: UpdateMemberSessionRequest.Builder.() -> Unit): UpdateMemberSessionResponse = updateMemberSession(UpdateMemberSessionRequest.Builder().apply(block).build())

/**
 * Updates the Amazon Macie configuration settings for an organization in Organizations.
 */
public suspend inline fun Macie2Client.updateOrganizationConfiguration(crossinline block: UpdateOrganizationConfigurationRequest.Builder.() -> Unit): UpdateOrganizationConfigurationResponse = updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the status and configuration settings for retrieving occurrences of sensitive data reported by findings.
 */
public suspend inline fun Macie2Client.updateRevealConfiguration(crossinline block: UpdateRevealConfigurationRequest.Builder.() -> Unit): UpdateRevealConfigurationResponse = updateRevealConfiguration(UpdateRevealConfigurationRequest.Builder().apply(block).build())
