// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides information about an API operation that an entity invoked for an affected resource.
 */
public class ApiCallDetails private constructor(builder: Builder) {
    /**
     * The name of the operation that was invoked most recently and produced the finding.
     */
    public val api: kotlin.String? = builder.api
    /**
     * The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.
     */
    public val apiServiceName: kotlin.String? = builder.apiServiceName
    /**
     * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.
     */
    public val firstSeen: aws.smithy.kotlin.runtime.time.Instant? = builder.firstSeen
    /**
     * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.
     */
    public val lastSeen: aws.smithy.kotlin.runtime.time.Instant? = builder.lastSeen

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ApiCallDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiCallDetails(")
        append("api=$api,")
        append("apiServiceName=$apiServiceName,")
        append("firstSeen=$firstSeen,")
        append("lastSeen=$lastSeen)")
    }

    override fun hashCode(): kotlin.Int {
        var result = api?.hashCode() ?: 0
        result = 31 * result + (apiServiceName?.hashCode() ?: 0)
        result = 31 * result + (firstSeen?.hashCode() ?: 0)
        result = 31 * result + (lastSeen?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiCallDetails

        if (api != other.api) return false
        if (apiServiceName != other.apiServiceName) return false
        if (firstSeen != other.firstSeen) return false
        if (lastSeen != other.lastSeen) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ApiCallDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the operation that was invoked most recently and produced the finding.
         */
        public var api: kotlin.String? = null
        /**
         * The URL of the Amazon Web Service that provides the operation, for example: s3.amazonaws.com.
         */
        public var apiServiceName: kotlin.String? = null
        /**
         * The first date and time, in UTC and extended ISO 8601 format, when any operation was invoked and produced the finding.
         */
        public var firstSeen: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The most recent date and time, in UTC and extended ISO 8601 format, when the specified operation (api) was invoked and produced the finding.
         */
        public var lastSeen: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ApiCallDetails) : this() {
            this.api = x.api
            this.apiServiceName = x.apiServiceName
            this.firstSeen = x.firstSeen
            this.lastSeen = x.lastSeen
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ApiCallDetails = ApiCallDetails(this)
    }
}
