// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about an identity that performed an action on an affected resource by using temporary security credentials. The credentials were obtained using the AssumeRole operation of the Security Token Service (STS) API.
 */
public class AssumedRole private constructor(builder: Builder) {
    /**
     * The Amazon Web Services access key ID that identifies the credentials.
     */
    public val accessKeyId: kotlin.String? = builder.accessKeyId
    /**
     * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The unique identifier for the entity that was used to get the credentials.
     */
    public val principalId: kotlin.String? = builder.principalId
    /**
     * The details of the session that was created for the credentials, including the entity that issued the session.
     */
    public val sessionContext: aws.sdk.kotlin.services.macie2.model.SessionContext? = builder.sessionContext

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.AssumedRole = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssumedRole(")
        append("accessKeyId=$accessKeyId,")
        append("accountId=$accountId,")
        append("arn=$arn,")
        append("principalId=$principalId,")
        append("sessionContext=$sessionContext)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessKeyId?.hashCode() ?: 0
        result = 31 * result + (accountId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        result = 31 * result + (sessionContext?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssumedRole

        if (accessKeyId != other.accessKeyId) return false
        if (accountId != other.accountId) return false
        if (arn != other.arn) return false
        if (principalId != other.principalId) return false
        if (sessionContext != other.sessionContext) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.AssumedRole = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Web Services access key ID that identifies the credentials.
         */
        public var accessKeyId: kotlin.String? = null
        /**
         * The unique identifier for the Amazon Web Services account that owns the entity that was used to get the credentials.
         */
        public var accountId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the entity that was used to get the credentials.
         */
        public var arn: kotlin.String? = null
        /**
         * The unique identifier for the entity that was used to get the credentials.
         */
        public var principalId: kotlin.String? = null
        /**
         * The details of the session that was created for the credentials, including the entity that issued the session.
         */
        public var sessionContext: aws.sdk.kotlin.services.macie2.model.SessionContext? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.AssumedRole) : this() {
            this.accessKeyId = x.accessKeyId
            this.accountId = x.accountId
            this.arn = x.arn
            this.principalId = x.principalId
            this.sessionContext = x.sessionContext
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.AssumedRole = AssumedRole(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.SessionContext] inside the given [block]
         */
        public fun sessionContext(block: aws.sdk.kotlin.services.macie2.model.SessionContext.Builder.() -> kotlin.Unit) {
            this.sessionContext = aws.sdk.kotlin.services.macie2.model.SessionContext.invoke(block)
        }
    }
}
