// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the block public access settings for an S3 bucket. These settings can apply to a bucket at the account level or bucket level. For detailed information about each setting, see [Blocking public access to your Amazon S3 storage](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html) in the *Amazon Simple Storage Service User Guide*.
 */
public class BlockPublicAccess private constructor(builder: Builder) {
    /**
     * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.
     */
    public val blockPublicAcls: kotlin.Boolean = builder.blockPublicAcls
    /**
     * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
     */
    public val blockPublicPolicy: kotlin.Boolean = builder.blockPublicPolicy
    /**
     * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
     */
    public val ignorePublicAcls: kotlin.Boolean = builder.ignorePublicAcls
    /**
     * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
     */
    public val restrictPublicBuckets: kotlin.Boolean = builder.restrictPublicBuckets

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BlockPublicAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BlockPublicAccess(")
        append("blockPublicAcls=$blockPublicAcls,")
        append("blockPublicPolicy=$blockPublicPolicy,")
        append("ignorePublicAcls=$ignorePublicAcls,")
        append("restrictPublicBuckets=$restrictPublicBuckets)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockPublicAcls.hashCode()
        result = 31 * result + (blockPublicPolicy.hashCode())
        result = 31 * result + (ignorePublicAcls.hashCode())
        result = 31 * result + (restrictPublicBuckets.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BlockPublicAccess

        if (blockPublicAcls != other.blockPublicAcls) return false
        if (blockPublicPolicy != other.blockPublicPolicy) return false
        if (ignorePublicAcls != other.ignorePublicAcls) return false
        if (restrictPublicBuckets != other.restrictPublicBuckets) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BlockPublicAccess = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether Amazon S3 blocks public access control lists (ACLs) for the bucket and objects in the bucket.
         */
        public var blockPublicAcls: kotlin.Boolean = false
        /**
         * Specifies whether Amazon S3 blocks public bucket policies for the bucket.
         */
        public var blockPublicPolicy: kotlin.Boolean = false
        /**
         * Specifies whether Amazon S3 ignores public ACLs for the bucket and objects in the bucket.
         */
        public var ignorePublicAcls: kotlin.Boolean = false
        /**
         * Specifies whether Amazon S3 restricts public bucket policies for the bucket.
         */
        public var restrictPublicBuckets: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BlockPublicAccess) : this() {
            this.blockPublicAcls = x.blockPublicAcls
            this.blockPublicPolicy = x.blockPublicPolicy
            this.ignorePublicAcls = x.ignorePublicAcls
            this.restrictPublicBuckets = x.restrictPublicBuckets
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BlockPublicAccess = BlockPublicAccess(this)
    }
}
