// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets that are publicly accessible based on a combination of permissions settings for each bucket.
 */
public class BucketCountByEffectivePermission private constructor(builder: Builder) {
    /**
     * The total number of buckets that allow the general public to have read or write access to the bucket.
     */
    public val publiclyAccessible: kotlin.Long = builder.publiclyAccessible
    /**
     * The total number of buckets that allow the general public to have read access to the bucket.
     */
    public val publiclyReadable: kotlin.Long = builder.publiclyReadable
    /**
     * The total number of buckets that allow the general public to have write access to the bucket.
     */
    public val publiclyWritable: kotlin.Long = builder.publiclyWritable
    /**
     * The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.
     */
    public val unknown: kotlin.Long = builder.unknown

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountByEffectivePermission(")
        append("publiclyAccessible=$publiclyAccessible,")
        append("publiclyReadable=$publiclyReadable,")
        append("publiclyWritable=$publiclyWritable,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = publiclyAccessible.hashCode()
        result = 31 * result + (publiclyReadable.hashCode())
        result = 31 * result + (publiclyWritable.hashCode())
        result = 31 * result + (unknown.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketCountByEffectivePermission

        if (publiclyAccessible != other.publiclyAccessible) return false
        if (publiclyReadable != other.publiclyReadable) return false
        if (publiclyWritable != other.publiclyWritable) return false
        if (unknown != other.unknown) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of buckets that allow the general public to have read or write access to the bucket.
         */
        public var publiclyAccessible: kotlin.Long = 0L
        /**
         * The total number of buckets that allow the general public to have read access to the bucket.
         */
        public var publiclyReadable: kotlin.Long = 0L
        /**
         * The total number of buckets that allow the general public to have write access to the bucket.
         */
        public var publiclyWritable: kotlin.Long = 0L
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate permissions settings for. Macie can't determine whether these buckets are publicly accessible.
         */
        public var unknown: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission) : this() {
            this.publiclyAccessible = x.publiclyAccessible
            this.publiclyReadable = x.publiclyReadable
            this.publiclyWritable = x.publiclyWritable
            this.unknown = x.unknown
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission = BucketCountByEffectivePermission(this)
    }
}
