// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets that use certain types of server-side encryption by default or don't encrypt new objects by default. For detailed information about these settings, see [Setting default server-side encryption behavior for Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html) in the *Amazon Simple Storage Service User Guide*.
 */
public class BucketCountByEncryptionType private constructor(builder: Builder) {
    /**
     * The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.
     */
    public val kmsManaged: kotlin.Long = builder.kmsManaged
    /**
     * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.
     */
    public val s3Managed: kotlin.Long = builder.s3Managed
    /**
     * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.
     */
    public val unencrypted: kotlin.Long = builder.unencrypted
    /**
     * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.
     */
    public val unknown: kotlin.Long = builder.unknown

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountByEncryptionType(")
        append("kmsManaged=$kmsManaged,")
        append("s3Managed=$s3Managed,")
        append("unencrypted=$unencrypted,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsManaged.hashCode()
        result = 31 * result + (s3Managed.hashCode())
        result = 31 * result + (unencrypted.hashCode())
        result = 31 * result + (unknown.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketCountByEncryptionType

        if (kmsManaged != other.kmsManaged) return false
        if (s3Managed != other.s3Managed) return false
        if (unencrypted != other.unencrypted) return false
        if (unknown != other.unknown) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of buckets that use an KMS key to encrypt new objects by default, either an Amazon Web Services managed key or a customer managed key. These buckets use KMS encryption (SSE-KMS) by default.
         */
        public var kmsManaged: kotlin.Long = 0L
        /**
         * The total number of buckets that use an Amazon S3 managed key to encrypt new objects by default. These buckets use Amazon S3 managed encryption (SSE-S3) by default.
         */
        public var s3Managed: kotlin.Long = 0L
        /**
         * The total number of buckets that don't encrypt new objects by default. Default encryption is disabled for these buckets.
         */
        public var unencrypted: kotlin.Long = 0L
        /**
         * The total number of buckets that Amazon Macie doesn't have current encryption metadata for. Macie can't provide current data about the default encryption settings for these buckets.
         */
        public var unknown: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType) : this() {
            this.kmsManaged = x.kmsManaged
            this.s3Managed = x.s3Managed
            this.unencrypted = x.unencrypted
            this.unknown = x.unknown
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType = BucketCountByEncryptionType(this)
    }
}
