// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets that are or aren't shared with other Amazon Web Services accounts.
 */
public class BucketCountBySharedAccessType private constructor(builder: Builder) {
    /**
     * The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
     */
    public val external: kotlin.Long = builder.external
    /**
     * The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
     */
    public val internal: kotlin.Long = builder.internal
    /**
     * The total number of buckets that aren't shared with other Amazon Web Services accounts.
     */
    public val notShared: kotlin.Long = builder.notShared
    /**
     * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.
     */
    public val unknown: kotlin.Long = builder.unknown

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountBySharedAccessType(")
        append("external=$external,")
        append("internal=$internal,")
        append("notShared=$notShared,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = external.hashCode()
        result = 31 * result + (internal.hashCode())
        result = 31 * result + (notShared.hashCode())
        result = 31 * result + (unknown.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketCountBySharedAccessType

        if (external != other.external) return false
        if (internal != other.internal) return false
        if (notShared != other.notShared) return false
        if (unknown != other.unknown) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of buckets that are shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         */
        public var external: kotlin.Long = 0L
        /**
         * The total number of buckets that are shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
         */
        public var internal: kotlin.Long = 0L
        /**
         * The total number of buckets that aren't shared with other Amazon Web Services accounts.
         */
        public var notShared: kotlin.Long = 0L
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate shared access settings for. Macie can't determine whether these buckets are shared with other Amazon Web Services accounts.
         */
        public var unknown: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType) : this() {
            this.external = x.external
            this.internal = x.internal
            this.notShared = x.notShared
            this.unknown = x.unknown
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType = BucketCountBySharedAccessType(this)
    }
}
