// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the number of S3 buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
 */
public class BucketCountPolicyAllowsUnencryptedObjectUploads private constructor(builder: Builder) {
    /**
     * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
     */
    public val allowsUnencryptedObjectUploads: kotlin.Long = builder.allowsUnencryptedObjectUploads
    /**
     * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
     */
    public val deniesUnencryptedObjectUploads: kotlin.Long = builder.deniesUnencryptedObjectUploads
    /**
     * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.
     */
    public val unknown: kotlin.Long = builder.unknown

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketCountPolicyAllowsUnencryptedObjectUploads(")
        append("allowsUnencryptedObjectUploads=$allowsUnencryptedObjectUploads,")
        append("deniesUnencryptedObjectUploads=$deniesUnencryptedObjectUploads,")
        append("unknown=$unknown)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowsUnencryptedObjectUploads.hashCode()
        result = 31 * result + (deniesUnencryptedObjectUploads.hashCode())
        result = 31 * result + (unknown.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketCountPolicyAllowsUnencryptedObjectUploads

        if (allowsUnencryptedObjectUploads != other.allowsUnencryptedObjectUploads) return false
        if (deniesUnencryptedObjectUploads != other.deniesUnencryptedObjectUploads) return false
        if (unknown != other.unknown) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of buckets that don't have a bucket policy or have a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, the policy doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
         */
        public var allowsUnencryptedObjectUploads: kotlin.Long = 0L
        /**
         * The total number of buckets whose bucket policies require server-side encryption of new objects. PutObject requests for these buckets must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
         */
        public var deniesUnencryptedObjectUploads: kotlin.Long = 0L
        /**
         * The total number of buckets that Amazon Macie wasn't able to evaluate server-side encryption requirements for. Macie can't determine whether the bucket policies for these buckets require server-side encryption of new objects.
         */
        public var unknown: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads) : this() {
            this.allowsUnencryptedObjectUploads = x.allowsUnencryptedObjectUploads
            this.deniesUnencryptedObjectUploads = x.deniesUnencryptedObjectUploads
            this.unknown = x.unknown
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads = BucketCountPolicyAllowsUnencryptedObjectUploads(this)
    }
}
