// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides statistical data and other information about an S3 bucket that Amazon Macie monitors and analyzes for your account. If an error occurs when Macie attempts to retrieve and process information about the bucket or the bucket's objects, the value for the versioning property is false and the value for most other properties is null. Exceptions are accountId, bucketArn, bucketCreatedAt, bucketName, lastUpdated, and region. To identify the cause of the error, refer to the errorCode and errorMessage values.
 */
public class BucketMetadata private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account that owns the bucket.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:
     * + FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
     * + TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
     * + UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.
     */
    public val allowsUnencryptedObjectUploads: aws.sdk.kotlin.services.macie2.model.AllowsUnencryptedObjectUploads? = builder.allowsUnencryptedObjectUploads
    /**
     * The Amazon Resource Name (ARN) of the bucket.
     */
    public val bucketArn: kotlin.String? = builder.bucketArn
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
     */
    public val bucketCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.bucketCreatedAt
    /**
     * The name of the bucket.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     */
    public val classifiableObjectCount: kotlin.Long = builder.classifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     *
     * If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    public val classifiableSizeInBytes: kotlin.Long = builder.classifiableSizeInBytes
    /**
     * Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.
     */
    public val errorCode: aws.sdk.kotlin.services.macie2.model.BucketMetadataErrorCode? = builder.errorCode
    /**
     * A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.
     */
    public val errorMessage: kotlin.String? = builder.errorMessage
    /**
     * Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.
     */
    public val jobDetails: aws.sdk.kotlin.services.macie2.model.JobDetails? = builder.jobDetails
    /**
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The total number of objects in the bucket.
     */
    public val objectCount: kotlin.Long = builder.objectCount
    /**
     * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
     */
    public val objectCountByEncryptionType: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType? = builder.objectCountByEncryptionType
    /**
     * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.
     */
    public val publicAccess: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess? = builder.publicAccess
    /**
     * The Amazon Web Services Region that hosts the bucket.
     */
    public val region: kotlin.String? = builder.region
    /**
     * Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.
     */
    public val replicationDetails: aws.sdk.kotlin.services.macie2.model.ReplicationDetails? = builder.replicationDetails
    /**
     * Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.
     */
    public val serverSideEncryption: aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption? = builder.serverSideEncryption
    /**
     * Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are:
     * + EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
     * + INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
     * + NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts.
     * + UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.
     */
    public val sharedAccess: aws.sdk.kotlin.services.macie2.model.SharedAccess? = builder.sharedAccess
    /**
     * The total storage size, in bytes, of the bucket.
     *
     * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
     */
    public val sizeInBytes: kotlin.Long = builder.sizeInBytes
    /**
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.
     *
     * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
     */
    public val sizeInBytesCompressed: kotlin.Long = builder.sizeInBytesCompressed
    /**
     * An array that specifies the tags (keys and values) that are associated with the bucket.
     */
    public val tags: List<KeyValuePair>? = builder.tags
    /**
     * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val unclassifiableObjectCount: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = builder.unclassifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val unclassifiableObjectSizeInBytes: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = builder.unclassifiableObjectSizeInBytes
    /**
     * Specifies whether versioning is enabled for the bucket.
     */
    public val versioning: kotlin.Boolean = builder.versioning

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketMetadata(")
        append("accountId=$accountId,")
        append("allowsUnencryptedObjectUploads=$allowsUnencryptedObjectUploads,")
        append("bucketArn=$bucketArn,")
        append("bucketCreatedAt=$bucketCreatedAt,")
        append("bucketName=$bucketName,")
        append("classifiableObjectCount=$classifiableObjectCount,")
        append("classifiableSizeInBytes=$classifiableSizeInBytes,")
        append("errorCode=$errorCode,")
        append("errorMessage=$errorMessage,")
        append("jobDetails=$jobDetails,")
        append("lastUpdated=$lastUpdated,")
        append("objectCount=$objectCount,")
        append("objectCountByEncryptionType=$objectCountByEncryptionType,")
        append("publicAccess=$publicAccess,")
        append("region=$region,")
        append("replicationDetails=$replicationDetails,")
        append("serverSideEncryption=$serverSideEncryption,")
        append("sharedAccess=$sharedAccess,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInBytesCompressed=$sizeInBytesCompressed,")
        append("tags=$tags,")
        append("unclassifiableObjectCount=$unclassifiableObjectCount,")
        append("unclassifiableObjectSizeInBytes=$unclassifiableObjectSizeInBytes,")
        append("versioning=$versioning)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (allowsUnencryptedObjectUploads?.hashCode() ?: 0)
        result = 31 * result + (bucketArn?.hashCode() ?: 0)
        result = 31 * result + (bucketCreatedAt?.hashCode() ?: 0)
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (classifiableObjectCount.hashCode())
        result = 31 * result + (classifiableSizeInBytes.hashCode())
        result = 31 * result + (errorCode?.hashCode() ?: 0)
        result = 31 * result + (errorMessage?.hashCode() ?: 0)
        result = 31 * result + (jobDetails?.hashCode() ?: 0)
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (objectCount.hashCode())
        result = 31 * result + (objectCountByEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (publicAccess?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (replicationDetails?.hashCode() ?: 0)
        result = 31 * result + (serverSideEncryption?.hashCode() ?: 0)
        result = 31 * result + (sharedAccess?.hashCode() ?: 0)
        result = 31 * result + (sizeInBytes.hashCode())
        result = 31 * result + (sizeInBytesCompressed.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (versioning.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketMetadata

        if (accountId != other.accountId) return false
        if (allowsUnencryptedObjectUploads != other.allowsUnencryptedObjectUploads) return false
        if (bucketArn != other.bucketArn) return false
        if (bucketCreatedAt != other.bucketCreatedAt) return false
        if (bucketName != other.bucketName) return false
        if (classifiableObjectCount != other.classifiableObjectCount) return false
        if (classifiableSizeInBytes != other.classifiableSizeInBytes) return false
        if (errorCode != other.errorCode) return false
        if (errorMessage != other.errorMessage) return false
        if (jobDetails != other.jobDetails) return false
        if (lastUpdated != other.lastUpdated) return false
        if (objectCount != other.objectCount) return false
        if (objectCountByEncryptionType != other.objectCountByEncryptionType) return false
        if (publicAccess != other.publicAccess) return false
        if (region != other.region) return false
        if (replicationDetails != other.replicationDetails) return false
        if (serverSideEncryption != other.serverSideEncryption) return false
        if (sharedAccess != other.sharedAccess) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInBytesCompressed != other.sizeInBytesCompressed) return false
        if (tags != other.tags) return false
        if (unclassifiableObjectCount != other.unclassifiableObjectCount) return false
        if (unclassifiableObjectSizeInBytes != other.unclassifiableObjectSizeInBytes) return false
        if (versioning != other.versioning) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account that owns the bucket.
         */
        public var accountId: kotlin.String? = null
        /**
         * Specifies whether the bucket policy for the bucket requires server-side encryption of objects when objects are uploaded to the bucket. Possible values are:
         * + FALSE - The bucket policy requires server-side encryption of new objects. PutObject requests must include the x-amz-server-side-encryption header and the value for that header must be AES256 or aws:kms.
         * + TRUE - The bucket doesn't have a bucket policy or it has a bucket policy that doesn't require server-side encryption of new objects. If a bucket policy exists, it doesn't require PutObject requests to include the x-amz-server-side-encryption header and it doesn't require the value for that header to be AES256 or aws:kms.
         * + UNKNOWN - Amazon Macie can't determine whether the bucket policy requires server-side encryption of new objects.
         */
        public var allowsUnencryptedObjectUploads: aws.sdk.kotlin.services.macie2.model.AllowsUnencryptedObjectUploads? = null
        /**
         * The Amazon Resource Name (ARN) of the bucket.
         */
        public var bucketArn: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the bucket was created.
         */
        public var bucketCreatedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The total number of objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        public var classifiableObjectCount: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can analyze in the bucket. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         *
         * If versioning is enabled for the bucket, Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        public var classifiableSizeInBytes: kotlin.Long = 0L
        /**
         * Specifies the error code for an error that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. If this value is ACCESS_DENIED, Macie doesn't have permission to retrieve the information. For example, the bucket has a restrictive bucket policy and Amazon S3 denied the request. If this value is null, Macie was able to retrieve and process the information.
         */
        public var errorCode: aws.sdk.kotlin.services.macie2.model.BucketMetadataErrorCode? = null
        /**
         * A brief description of the error (errorCode) that prevented Amazon Macie from retrieving and processing information about the bucket and the bucket's objects. This value is null if Macie was able to retrieve and process the information.
         */
        public var errorMessage: kotlin.String? = null
        /**
         * Specifies whether any one-time or recurring classification jobs are configured to analyze data in the bucket, and, if so, the details of the job that ran most recently.
         */
        public var jobDetails: aws.sdk.kotlin.services.macie2.model.JobDetails? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the bucket.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total number of objects in the bucket.
         */
        public var objectCount: kotlin.Long = 0L
        /**
         * The total number of objects that are in the bucket, grouped by server-side encryption type. This includes a grouping that reports the total number of objects that aren't encrypted or use client-side encryption.
         */
        public var objectCountByEncryptionType: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType? = null
        /**
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket, and provides information about those settings.
         */
        public var publicAccess: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess? = null
        /**
         * The Amazon Web Services Region that hosts the bucket.
         */
        public var region: kotlin.String? = null
        /**
         * Specifies whether the bucket is configured to replicate one or more objects to buckets for other Amazon Web Services accounts and, if so, which accounts.
         */
        public var replicationDetails: aws.sdk.kotlin.services.macie2.model.ReplicationDetails? = null
        /**
         * Specifies whether the bucket encrypts new objects by default and, if so, the type of server-side encryption that's used.
         */
        public var serverSideEncryption: aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption? = null
        /**
         * Specifies whether the bucket is shared with another Amazon Web Services account. Possible values are:
         * + EXTERNAL - The bucket is shared with an Amazon Web Services account that isn't part of the same Amazon Macie organization.
         * + INTERNAL - The bucket is shared with an Amazon Web Services account that's part of the same Amazon Macie organization.
         * + NOT_SHARED - The bucket isn't shared with other Amazon Web Services accounts.
         * + UNKNOWN - Amazon Macie wasn't able to evaluate the shared access settings for the bucket.
         */
        public var sharedAccess: aws.sdk.kotlin.services.macie2.model.SharedAccess? = null
        /**
         * The total storage size, in bytes, of the bucket.
         *
         * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each object in the bucket. This value doesn't reflect the storage size of all versions of each object in the bucket.
         */
        public var sizeInBytes: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the bucket.
         *
         * If versioning is enabled for the bucket, Amazon Macie calculates this value based on the size of the latest version of each applicable object in the bucket. This value doesn't reflect the storage size of all versions of each applicable object in the bucket.
         */
        public var sizeInBytesCompressed: kotlin.Long = 0L
        /**
         * An array that specifies the tags (keys and values) that are associated with the bucket.
         */
        public var tags: List<KeyValuePair>? = null
        /**
         * The total number of objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var unclassifiableObjectCount: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = null
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the bucket. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var unclassifiableObjectSizeInBytes: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = null
        /**
         * Specifies whether versioning is enabled for the bucket.
         */
        public var versioning: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketMetadata) : this() {
            this.accountId = x.accountId
            this.allowsUnencryptedObjectUploads = x.allowsUnencryptedObjectUploads
            this.bucketArn = x.bucketArn
            this.bucketCreatedAt = x.bucketCreatedAt
            this.bucketName = x.bucketName
            this.classifiableObjectCount = x.classifiableObjectCount
            this.classifiableSizeInBytes = x.classifiableSizeInBytes
            this.errorCode = x.errorCode
            this.errorMessage = x.errorMessage
            this.jobDetails = x.jobDetails
            this.lastUpdated = x.lastUpdated
            this.objectCount = x.objectCount
            this.objectCountByEncryptionType = x.objectCountByEncryptionType
            this.publicAccess = x.publicAccess
            this.region = x.region
            this.replicationDetails = x.replicationDetails
            this.serverSideEncryption = x.serverSideEncryption
            this.sharedAccess = x.sharedAccess
            this.sizeInBytes = x.sizeInBytes
            this.sizeInBytesCompressed = x.sizeInBytesCompressed
            this.tags = x.tags
            this.unclassifiableObjectCount = x.unclassifiableObjectCount
            this.unclassifiableObjectSizeInBytes = x.unclassifiableObjectSizeInBytes
            this.versioning = x.versioning
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketMetadata = BucketMetadata(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobDetails] inside the given [block]
         */
        public fun jobDetails(block: aws.sdk.kotlin.services.macie2.model.JobDetails.Builder.() -> kotlin.Unit) {
            this.jobDetails = aws.sdk.kotlin.services.macie2.model.JobDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType] inside the given [block]
         */
        public fun objectCountByEncryptionType(block: aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType.Builder.() -> kotlin.Unit) {
            this.objectCountByEncryptionType = aws.sdk.kotlin.services.macie2.model.ObjectCountByEncryptionType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPublicAccess] inside the given [block]
         */
        public fun publicAccess(block: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess.Builder.() -> kotlin.Unit) {
            this.publicAccess = aws.sdk.kotlin.services.macie2.model.BucketPublicAccess.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ReplicationDetails] inside the given [block]
         */
        public fun replicationDetails(block: aws.sdk.kotlin.services.macie2.model.ReplicationDetails.Builder.() -> kotlin.Unit) {
            this.replicationDetails = aws.sdk.kotlin.services.macie2.model.ReplicationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption] inside the given [block]
         */
        public fun serverSideEncryption(block: aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption.Builder.() -> kotlin.Unit) {
            this.serverSideEncryption = aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        public fun unclassifiableObjectCount(block: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.Builder.() -> kotlin.Unit) {
            this.unclassifiableObjectCount = aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        public fun unclassifiableObjectSizeInBytes(block: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.Builder.() -> kotlin.Unit) {
            this.unclassifiableObjectSizeInBytes = aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.invoke(block)
        }
    }
}
