// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the permissions settings that determine whether an S3 bucket is publicly accessible.
 */
public class BucketPublicAccess private constructor(builder: Builder) {
    /**
     * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:
     * + NOT_PUBLIC - The bucket isn't publicly accessible.
     * + PUBLIC - The bucket is publicly accessible.
     * + UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
     */
    public val effectivePermission: aws.sdk.kotlin.services.macie2.model.EffectivePermission? = builder.effectivePermission
    /**
     * The account-level and bucket-level permissions settings for the bucket.
     */
    public val permissionConfiguration: aws.sdk.kotlin.services.macie2.model.BucketPermissionConfiguration? = builder.permissionConfiguration

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketPublicAccess = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketPublicAccess(")
        append("effectivePermission=$effectivePermission,")
        append("permissionConfiguration=$permissionConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = effectivePermission?.hashCode() ?: 0
        result = 31 * result + (permissionConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketPublicAccess

        if (effectivePermission != other.effectivePermission) return false
        if (permissionConfiguration != other.permissionConfiguration) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketPublicAccess = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the bucket is publicly accessible due to the combination of permissions settings that apply to the bucket. Possible values are:
         * + NOT_PUBLIC - The bucket isn't publicly accessible.
         * + PUBLIC - The bucket is publicly accessible.
         * + UNKNOWN - Amazon Macie can't determine whether the bucket is publicly accessible.
         */
        public var effectivePermission: aws.sdk.kotlin.services.macie2.model.EffectivePermission? = null
        /**
         * The account-level and bucket-level permissions settings for the bucket.
         */
        public var permissionConfiguration: aws.sdk.kotlin.services.macie2.model.BucketPermissionConfiguration? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketPublicAccess) : this() {
            this.effectivePermission = x.effectivePermission
            this.permissionConfiguration = x.permissionConfiguration
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketPublicAccess = BucketPublicAccess(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketPermissionConfiguration] inside the given [block]
         */
        public fun permissionConfiguration(block: aws.sdk.kotlin.services.macie2.model.BucketPermissionConfiguration.Builder.() -> kotlin.Unit) {
            this.permissionConfiguration = aws.sdk.kotlin.services.macie2.model.BucketPermissionConfiguration.invoke(block)
        }
    }
}
