// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about the default server-side encryption settings for an S3 bucket. For detailed information about these settings, see [Setting default server-side encryption behavior for Amazon S3 buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html) in the *Amazon Simple Storage Service User Guide*.
 */
public class BucketServerSideEncryption private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.
     */
    public val kmsMasterKeyId: kotlin.String? = builder.kmsMasterKeyId
    /**
     * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are:
     * + AES256 - New objects are encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.
     * + aws:kms - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key. They use SSE-KMS encryption.
     * + NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
     */
    public val type: aws.sdk.kotlin.services.macie2.model.Type? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BucketServerSideEncryption(")
        append("kmsMasterKeyId=$kmsMasterKeyId,")
        append("type=$type)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsMasterKeyId?.hashCode() ?: 0
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BucketServerSideEncryption

        if (kmsMasterKeyId != other.kmsMasterKeyId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) or unique identifier (key ID) for the KMS key that's used by default to encrypt objects that are added to the bucket. This value is null if the bucket uses an Amazon S3 managed key to encrypt new objects or the bucket doesn't encrypt new objects by default.
         */
        public var kmsMasterKeyId: kotlin.String? = null
        /**
         * The type of server-side encryption that's used by default when storing new objects in the bucket. Possible values are:
         * + AES256 - New objects are encrypted with an Amazon S3 managed key. They use SSE-S3 encryption.
         * + aws:kms - New objects are encrypted with an KMS key (kmsMasterKeyId), either an Amazon Web Services managed key or a customer managed key. They use SSE-KMS encryption.
         * + NONE - New objects aren't encrypted by default. Default encryption is disabled for the bucket.
         */
        public var type: aws.sdk.kotlin.services.macie2.model.Type? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption) : this() {
            this.kmsMasterKeyId = x.kmsMasterKeyId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.BucketServerSideEncryption = BucketServerSideEncryption(this)
    }
}
