// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies the location of an occurrence of sensitive data in a Microsoft Excel workbook, CSV file, or TSV file.
 */
public class Cell private constructor(builder: Builder) {
    /**
     * The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
     */
    public val cellReference: kotlin.String? = builder.cellReference
    /**
     * The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.
     */
    public val column: kotlin.Long = builder.column
    /**
     * The name of the column that contains the sensitive data, if available.
     */
    public val columnName: kotlin.String? = builder.columnName
    /**
     * The row number of the row that contains the sensitive data.
     */
    public val row: kotlin.Long = builder.row

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.Cell = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Cell(")
        append("cellReference=$cellReference,")
        append("column=$column,")
        append("columnName=$columnName,")
        append("row=$row)")
    }

    override fun hashCode(): kotlin.Int {
        var result = cellReference?.hashCode() ?: 0
        result = 31 * result + (column.hashCode())
        result = 31 * result + (columnName?.hashCode() ?: 0)
        result = 31 * result + (row.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Cell

        if (cellReference != other.cellReference) return false
        if (column != other.column) return false
        if (columnName != other.columnName) return false
        if (row != other.row) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.Cell = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The location of the cell, as an absolute cell reference, that contains the sensitive data, for example Sheet2!C5 for cell C5 on Sheet2 in a Microsoft Excel workbook. This value is null for CSV and TSV files.
         */
        public var cellReference: kotlin.String? = null
        /**
         * The column number of the column that contains the sensitive data. For a Microsoft Excel workbook, this value correlates to the alphabetical character(s) for a column identifier, for example: 1 for column A, 2 for column B, and so on.
         */
        public var column: kotlin.Long = 0L
        /**
         * The name of the column that contains the sensitive data, if available.
         */
        public var columnName: kotlin.String? = null
        /**
         * The row number of the row that contains the sensitive data.
         */
        public var row: kotlin.Long = 0L

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.Cell) : this() {
            this.cellReference = x.cellReference
            this.column = x.column
            this.columnName = x.columnName
            this.row = x.row
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.Cell = Cell(this)
    }
}
