// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about a sensitive data finding and the details of the finding.
 */
public class ClassificationDetails private constructor(builder: Builder) {
    /**
     * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.
     */
    public val detailedResultsLocation: kotlin.String? = builder.detailedResultsLocation
    /**
     * The Amazon Resource Name (ARN) of the classification job that produced the finding.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The unique identifier for the classification job that produced the finding.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * Specifies how Amazon Macie found the sensitive data that produced the finding: SENSITIVE_DATA_DISCOVERY_JOB, for a classification job.
     */
    public val originType: aws.sdk.kotlin.services.macie2.model.OriginType? = builder.originType
    /**
     * The status and other details of the finding.
     */
    public val result: aws.sdk.kotlin.services.macie2.model.ClassificationResult? = builder.result

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ClassificationDetails = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClassificationDetails(")
        append("detailedResultsLocation=$detailedResultsLocation,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("originType=$originType,")
        append("result=$result)")
    }

    override fun hashCode(): kotlin.Int {
        var result = detailedResultsLocation?.hashCode() ?: 0
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (originType?.hashCode() ?: 0)
        result = 31 * result + (result?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClassificationDetails

        if (detailedResultsLocation != other.detailedResultsLocation) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (originType != other.originType) return false
        if (result != other.result) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ClassificationDetails = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The path to the folder or file (in Amazon S3) that contains the corresponding sensitive data discovery result for the finding. If a finding applies to a large archive or compressed file, this value is the path to a folder. Otherwise, this value is the path to a file.
         */
        public var detailedResultsLocation: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the classification job that produced the finding.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The unique identifier for the classification job that produced the finding.
         */
        public var jobId: kotlin.String? = null
        /**
         * Specifies how Amazon Macie found the sensitive data that produced the finding: SENSITIVE_DATA_DISCOVERY_JOB, for a classification job.
         */
        public var originType: aws.sdk.kotlin.services.macie2.model.OriginType? = null
        /**
         * The status and other details of the finding.
         */
        public var result: aws.sdk.kotlin.services.macie2.model.ClassificationResult? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ClassificationDetails) : this() {
            this.detailedResultsLocation = x.detailedResultsLocation
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.originType = x.originType
            this.result = x.result
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ClassificationDetails = ClassificationDetails(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ClassificationResult] inside the given [block]
         */
        public fun result(block: aws.sdk.kotlin.services.macie2.model.ClassificationResult.Builder.() -> kotlin.Unit) {
            this.result = aws.sdk.kotlin.services.macie2.model.ClassificationResult.invoke(block)
        }
    }
}
