// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides the details of a sensitive data finding, including the types, number of occurrences, and locations of the sensitive data that was detected.
 */
public class ClassificationResult private constructor(builder: Builder) {
    /**
     * Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.
     *
     * This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).
     */
    public val additionalOccurrences: kotlin.Boolean = builder.additionalOccurrences
    /**
     * The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.
     */
    public val customDataIdentifiers: aws.sdk.kotlin.services.macie2.model.CustomDataIdentifiers? = builder.customDataIdentifiers
    /**
     * The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.
     */
    public val mimeType: kotlin.String? = builder.mimeType
    /**
     * The category, types, and number of occurrences of the sensitive data that produced the finding.
     */
    public val sensitiveData: List<SensitiveDataItem>? = builder.sensitiveData
    /**
     * The total size, in bytes, of the data that the finding applies to.
     */
    public val sizeClassified: kotlin.Long = builder.sizeClassified
    /**
     * The status of the finding.
     */
    public val status: aws.sdk.kotlin.services.macie2.model.ClassificationResultStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.ClassificationResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ClassificationResult(")
        append("additionalOccurrences=$additionalOccurrences,")
        append("customDataIdentifiers=$customDataIdentifiers,")
        append("mimeType=$mimeType,")
        append("sensitiveData=$sensitiveData,")
        append("sizeClassified=$sizeClassified,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalOccurrences.hashCode()
        result = 31 * result + (customDataIdentifiers?.hashCode() ?: 0)
        result = 31 * result + (mimeType?.hashCode() ?: 0)
        result = 31 * result + (sensitiveData?.hashCode() ?: 0)
        result = 31 * result + (sizeClassified.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ClassificationResult

        if (additionalOccurrences != other.additionalOccurrences) return false
        if (customDataIdentifiers != other.customDataIdentifiers) return false
        if (mimeType != other.mimeType) return false
        if (sensitiveData != other.sensitiveData) return false
        if (sizeClassified != other.sizeClassified) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.ClassificationResult = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether Amazon Macie detected additional occurrences of sensitive data in the S3 object. A finding includes location data for a maximum of 15 occurrences of sensitive data.
         *
         * This value can help you determine whether to investigate additional occurrences of sensitive data in an object. You can do this by referring to the corresponding sensitive data discovery result for the finding (ClassificationDetails.detailedResultsLocation).
         */
        public var additionalOccurrences: kotlin.Boolean = false
        /**
         * The custom data identifiers that detected the sensitive data and the number of occurrences of the data that they detected.
         */
        public var customDataIdentifiers: aws.sdk.kotlin.services.macie2.model.CustomDataIdentifiers? = null
        /**
         * The type of content, as a MIME type, that the finding applies to. For example, application/gzip, for a GNU Gzip compressed archive file, or application/pdf, for an Adobe Portable Document Format file.
         */
        public var mimeType: kotlin.String? = null
        /**
         * The category, types, and number of occurrences of the sensitive data that produced the finding.
         */
        public var sensitiveData: List<SensitiveDataItem>? = null
        /**
         * The total size, in bytes, of the data that the finding applies to.
         */
        public var sizeClassified: kotlin.Long = 0L
        /**
         * The status of the finding.
         */
        public var status: aws.sdk.kotlin.services.macie2.model.ClassificationResultStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.ClassificationResult) : this() {
            this.additionalOccurrences = x.additionalOccurrences
            this.customDataIdentifiers = x.customDataIdentifiers
            this.mimeType = x.mimeType
            this.sensitiveData = x.sensitiveData
            this.sizeClassified = x.sizeClassified
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.ClassificationResult = ClassificationResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.CustomDataIdentifiers] inside the given [block]
         */
        public fun customDataIdentifiers(block: aws.sdk.kotlin.services.macie2.model.CustomDataIdentifiers.Builder.() -> kotlin.Unit) {
            this.customDataIdentifiers = aws.sdk.kotlin.services.macie2.model.CustomDataIdentifiers.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ClassificationResultStatus] inside the given [block]
         */
        public fun status(block: aws.sdk.kotlin.services.macie2.model.ClassificationResultStatus.Builder.() -> kotlin.Unit) {
            this.status = aws.sdk.kotlin.services.macie2.model.ClassificationResultStatus.invoke(block)
        }
    }
}
