// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



public class CreateClassificationJobRequest private constructor(builder: Builder) {
    /**
     * An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
     */
    public val allowListIds: List<String>? = builder.allowListIds
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.
     */
    public val customDataIdentifierIds: List<String>? = builder.customDataIdentifierIds
    /**
     * A custom description of the job. The description can contain as many as 200 characters.
     */
    public val description: kotlin.String? = builder.description
    /**
     * For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.
     *
     * If you configure the job to run only once, don't specify a value for this property.
     */
    public val initialRun: kotlin.Boolean = builder.initialRun
    /**
     * The schedule for running the job. Valid values are:
     * + ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.
     * + SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.
     */
    public val jobType: aws.sdk.kotlin.services.macie2.model.JobType? = builder.jobType
    /**
     * An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).
     *
     * To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
     */
    public val managedDataIdentifierIds: List<String>? = builder.managedDataIdentifierIds
    /**
     * The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:
     * + ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.
     * + EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.
     * + INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     * + NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.
     *
     * If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.
     */
    public val managedDataIdentifierSelector: aws.sdk.kotlin.services.macie2.model.ManagedDataIdentifierSelector? = builder.managedDataIdentifierSelector
    /**
     * A custom name for the job. The name can contain as many as 500 characters.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    public val s3JobDefinition: aws.sdk.kotlin.services.macie2.model.S3JobDefinition? = builder.s3JobDefinition
    /**
     * The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     */
    public val samplingPercentage: kotlin.Int = builder.samplingPercentage
    /**
     * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.
     */
    public val scheduleFrequency: aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency? = builder.scheduleFrequency
    /**
     * A map of key-value pairs that specifies the tags to associate with the job.
     *
     * A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.CreateClassificationJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateClassificationJobRequest(")
        append("allowListIds=$allowListIds,")
        append("clientToken=$clientToken,")
        append("customDataIdentifierIds=$customDataIdentifierIds,")
        append("description=$description,")
        append("initialRun=$initialRun,")
        append("jobType=$jobType,")
        append("managedDataIdentifierIds=$managedDataIdentifierIds,")
        append("managedDataIdentifierSelector=$managedDataIdentifierSelector,")
        append("name=$name,")
        append("s3JobDefinition=$s3JobDefinition,")
        append("samplingPercentage=$samplingPercentage,")
        append("scheduleFrequency=$scheduleFrequency,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowListIds?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (customDataIdentifierIds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (initialRun.hashCode())
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (managedDataIdentifierIds?.hashCode() ?: 0)
        result = 31 * result + (managedDataIdentifierSelector?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3JobDefinition?.hashCode() ?: 0)
        result = 31 * result + (samplingPercentage)
        result = 31 * result + (scheduleFrequency?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateClassificationJobRequest

        if (allowListIds != other.allowListIds) return false
        if (clientToken != other.clientToken) return false
        if (customDataIdentifierIds != other.customDataIdentifierIds) return false
        if (description != other.description) return false
        if (initialRun != other.initialRun) return false
        if (jobType != other.jobType) return false
        if (managedDataIdentifierIds != other.managedDataIdentifierIds) return false
        if (managedDataIdentifierSelector != other.managedDataIdentifierSelector) return false
        if (name != other.name) return false
        if (s3JobDefinition != other.s3JobDefinition) return false
        if (samplingPercentage != other.samplingPercentage) return false
        if (scheduleFrequency != other.scheduleFrequency) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.CreateClassificationJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of unique identifiers, one for each allow list for the job to use when it analyzes data.
         */
        public var allowListIds: List<String>? = null
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * An array of unique identifiers, one for each custom data identifier for the job to use when it analyzes data. To use only managed data identifiers, don't specify a value for this property and specify a value other than NONE for the managedDataIdentifierSelector property.
         */
        public var customDataIdentifierIds: List<String>? = null
        /**
         * A custom description of the job. The description can contain as many as 200 characters.
         */
        public var description: kotlin.String? = null
        /**
         * For a recurring job, specifies whether to analyze all existing, eligible objects immediately after the job is created (true). To analyze only those objects that are created or changed after you create the job and before the job's first scheduled run, set this value to false.
         *
         * If you configure the job to run only once, don't specify a value for this property.
         */
        public var initialRun: kotlin.Boolean = false
        /**
         * The schedule for running the job. Valid values are:
         * + ONE_TIME - Run the job only once. If you specify this value, don't specify a value for the scheduleFrequency property.
         * + SCHEDULED - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the scheduleFrequency property to define the recurrence pattern for the job.
         */
        public var jobType: aws.sdk.kotlin.services.macie2.model.JobType? = null
        /**
         * An array of unique identifiers, one for each managed data identifier for the job to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type that you specify for the job (managedDataIdentifierSelector).
         *
         * To retrieve a list of valid values for this property, use the ListManagedDataIdentifiers operation.
         */
        public var managedDataIdentifierIds: List<String>? = null
        /**
         * The selection type to apply when determining which managed data identifiers the job uses to analyze data. Valid values are:
         * + ALL - Use all the managed data identifiers that Amazon Macie provides. If you specify this value, don't specify any values for the managedDataIdentifierIds property.
         * + EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.
         * + INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         * + NONE - Don't use any managed data identifiers. If you specify this value, specify at least one custom data identifier for the job (customDataIdentifierIds) and don't specify any values for the managedDataIdentifierIds property.
         *
         * If you don't specify a value for this property, the job uses all managed data identifiers. If you don't specify a value for this property or you specify ALL or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.
         */
        public var managedDataIdentifierSelector: aws.sdk.kotlin.services.macie2.model.ManagedDataIdentifierSelector? = null
        /**
         * A custom name for the job. The name can contain as many as 500 characters.
         */
        public var name: kotlin.String? = null
        /**
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         */
        public var s3JobDefinition: aws.sdk.kotlin.services.macie2.model.S3JobDefinition? = null
        /**
         * The sampling depth, as a percentage, for the job to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
         */
        public var samplingPercentage: kotlin.Int = 0
        /**
         * The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the jobType property to ONE_TIME.
         */
        public var scheduleFrequency: aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency? = null
        /**
         * A map of key-value pairs that specifies the tags to associate with the job.
         *
         * A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.CreateClassificationJobRequest) : this() {
            this.allowListIds = x.allowListIds
            this.clientToken = x.clientToken
            this.customDataIdentifierIds = x.customDataIdentifierIds
            this.description = x.description
            this.initialRun = x.initialRun
            this.jobType = x.jobType
            this.managedDataIdentifierIds = x.managedDataIdentifierIds
            this.managedDataIdentifierSelector = x.managedDataIdentifierSelector
            this.name = x.name
            this.s3JobDefinition = x.s3JobDefinition
            this.samplingPercentage = x.samplingPercentage
            this.scheduleFrequency = x.scheduleFrequency
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.CreateClassificationJobRequest = CreateClassificationJobRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3JobDefinition] inside the given [block]
         */
        public fun s3JobDefinition(block: aws.sdk.kotlin.services.macie2.model.S3JobDefinition.Builder.() -> kotlin.Unit) {
            this.s3JobDefinition = aws.sdk.kotlin.services.macie2.model.S3JobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency] inside the given [block]
         */
        public fun scheduleFrequency(block: aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency.Builder.() -> kotlin.Unit) {
            this.scheduleFrequency = aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency.invoke(block)
        }
    }
}
