// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



public class CreateCustomDataIdentifierRequest private constructor(builder: Builder) {
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A custom description of the custom data identifier. The description can contain as many as 512 characters.
     *
     * We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    public val description: kotlin.String? = builder.description
    /**
     * An array that lists specific character sequences (*ignore words*) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.
     */
    public val ignoreWords: List<String>? = builder.ignoreWords
    /**
     * An array that lists specific character sequences (*keywords*), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.
     */
    public val keywords: List<String>? = builder.keywords
    /**
     * The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. The distance can be 1-300 characters. The default value is 50.
     */
    public val maximumMatchDistance: kotlin.Int = builder.maximumMatchDistance
    /**
     * A custom name for the custom data identifier. The name can contain as many as 128 characters.
     *
     * We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The regular expression (*regex*) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    public val regex: kotlin.String? = builder.regex
    /**
     * The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.
     *
     * If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.
     */
    public val severityLevels: List<SeverityLevel>? = builder.severityLevels
    /**
     * A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     *
     * A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.CreateCustomDataIdentifierRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateCustomDataIdentifierRequest(")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("ignoreWords=$ignoreWords,")
        append("keywords=$keywords,")
        append("maximumMatchDistance=$maximumMatchDistance,")
        append("name=$name,")
        append("regex=$regex,")
        append("severityLevels=$severityLevels,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (ignoreWords?.hashCode() ?: 0)
        result = 31 * result + (keywords?.hashCode() ?: 0)
        result = 31 * result + (maximumMatchDistance)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (regex?.hashCode() ?: 0)
        result = 31 * result + (severityLevels?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateCustomDataIdentifierRequest

        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (ignoreWords != other.ignoreWords) return false
        if (keywords != other.keywords) return false
        if (maximumMatchDistance != other.maximumMatchDistance) return false
        if (name != other.name) return false
        if (regex != other.regex) return false
        if (severityLevels != other.severityLevels) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.CreateCustomDataIdentifierRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A custom description of the custom data identifier. The description can contain as many as 512 characters.
         *
         * We strongly recommend that you avoid including any sensitive data in the description of a custom data identifier. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        public var description: kotlin.String? = null
        /**
         * An array that lists specific character sequences (*ignore words*) to exclude from the results. If the text matched by the regular expression contains any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4-90 UTF-8 characters. Ignore words are case sensitive.
         */
        public var ignoreWords: List<String>? = null
        /**
         * An array that lists specific character sequences (*keywords*), one of which must precede and be within proximity (maximumMatchDistance) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords aren't case sensitive.
         */
        public var keywords: List<String>? = null
        /**
         * The maximum number of characters that can exist between the end of at least one complete character sequence specified by the keywords array and the end of the text that matches the regex pattern. If a complete keyword precedes all the text that matches the pattern and the keyword is within the specified distance, Amazon Macie includes the result. The distance can be 1-300 characters. The default value is 50.
         */
        public var maximumMatchDistance: kotlin.Int = 0
        /**
         * A custom name for the custom data identifier. The name can contain as many as 128 characters.
         *
         * We strongly recommend that you avoid including any sensitive data in the name of a custom data identifier. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        public var name: kotlin.String? = null
        /**
         * The regular expression (*regex*) that defines the pattern to match. The expression can contain as many as 512 characters.
         */
        public var regex: kotlin.String? = null
        /**
         * The severity to assign to findings that the custom data identifier produces, based on the number of occurrences of text that matches the custom data identifier's detection criteria. You can specify as many as three SeverityLevel objects in this array, one for each severity: LOW, MEDIUM, or HIGH. If you specify more than one, the occurrences thresholds must be in ascending order by severity, moving from LOW to HIGH. For example, 1 for LOW, 50 for MEDIUM, and 100 for HIGH. If an S3 object contains fewer occurrences than the lowest specified threshold, Amazon Macie doesn't create a finding.
         *
         * If you don't specify any values for this array, Macie creates findings for S3 objects that contain at least one occurrence of text that matches the detection criteria, and Macie assigns the MEDIUM severity to those findings.
         */
        public var severityLevels: List<SeverityLevel>? = null
        /**
         * A map of key-value pairs that specifies the tags to associate with the custom data identifier.
         *
         * A custom data identifier can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.CreateCustomDataIdentifierRequest) : this() {
            this.clientToken = x.clientToken
            this.description = x.description
            this.ignoreWords = x.ignoreWords
            this.keywords = x.keywords
            this.maximumMatchDistance = x.maximumMatchDistance
            this.name = x.name
            this.regex = x.regex
            this.severityLevels = x.severityLevels
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.CreateCustomDataIdentifierRequest = CreateCustomDataIdentifierRequest(this)
    }
}
