// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



public class CreateFindingsFilterRequest private constructor(builder: Builder) {
    /**
     * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
     */
    public val action: aws.sdk.kotlin.services.macie2.model.FindingsFilterAction? = builder.action
    /**
     * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * A custom description of the filter. The description can contain as many as 512 characters.
     *
     * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The criteria to use to filter findings.
     */
    public val findingCriteria: aws.sdk.kotlin.services.macie2.model.FindingCriteria? = builder.findingCriteria
    /**
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.
     *
     * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    public val position: kotlin.Int = builder.position
    /**
     * A map of key-value pairs that specifies the tags to associate with the filter.
     *
     * A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.CreateFindingsFilterRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateFindingsFilterRequest(")
        append("action=$action,")
        append("clientToken=$clientToken,")
        append("description=$description,")
        append("findingCriteria=$findingCriteria,")
        append("name=$name,")
        append("position=$position,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = action?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (findingCriteria?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (position)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateFindingsFilterRequest

        if (action != other.action) return false
        if (clientToken != other.clientToken) return false
        if (description != other.description) return false
        if (findingCriteria != other.findingCriteria) return false
        if (name != other.name) return false
        if (position != other.position) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.CreateFindingsFilterRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The action to perform on findings that meet the filter criteria (findingCriteria). Valid values are: ARCHIVE, suppress (automatically archive) the findings; and, NOOP, don't perform any action on the findings.
         */
        public var action: aws.sdk.kotlin.services.macie2.model.FindingsFilterAction? = null
        /**
         * A unique, case-sensitive token that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * A custom description of the filter. The description can contain as many as 512 characters.
         *
         * We strongly recommend that you avoid including any sensitive data in the description of a filter. Other users of your account might be able to see this description, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        public var description: kotlin.String? = null
        /**
         * The criteria to use to filter findings.
         */
        public var findingCriteria: aws.sdk.kotlin.services.macie2.model.FindingCriteria? = null
        /**
         * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters.
         *
         * We strongly recommend that you avoid including any sensitive data in the name of a filter. Other users of your account might be able to see this name, depending on the actions that they're allowed to perform in Amazon Macie.
         */
        public var name: kotlin.String? = null
        /**
         * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
         */
        public var position: kotlin.Int = 0
        /**
         * A map of key-value pairs that specifies the tags to associate with the filter.
         *
         * A findings filter can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.CreateFindingsFilterRequest) : this() {
            this.action = x.action
            this.clientToken = x.clientToken
            this.description = x.description
            this.findingCriteria = x.findingCriteria
            this.name = x.name
            this.position = x.position
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.CreateFindingsFilterRequest = CreateFindingsFilterRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.FindingCriteria] inside the given [block]
         */
        public fun findingCriteria(block: aws.sdk.kotlin.services.macie2.model.FindingCriteria.Builder.() -> kotlin.Unit) {
            this.findingCriteria = aws.sdk.kotlin.services.macie2.model.FindingCriteria.invoke(block)
        }
    }
}
