// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Specifies the operator to use in a property-based condition that filters the results of a query for findings. For detailed information and examples of each operator, see [Fundamentals of filtering findings](https://docs.aws.amazon.com/macie/latest/user/findings-filter-basics.html) in the *Amazon Macie User Guide*.
 */
public class CriterionAdditionalProperties private constructor(builder: Builder) {
    /**
     * The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.
     */
    public val eq: List<String>? = builder.eq
    /**
     * The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
     *
     * You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
     */
    public val eqExactMatch: List<String>? = builder.eqExactMatch
    /**
     * The value for the property is greater than the specified value.
     */
    public val gt: kotlin.Long = builder.gt
    /**
     * The value for the property is greater than or equal to the specified value.
     */
    public val gte: kotlin.Long = builder.gte
    /**
     * The value for the property is less than the specified value.
     */
    public val lt: kotlin.Long = builder.lt
    /**
     * The value for the property is less than or equal to the specified value.
     */
    public val lte: kotlin.Long = builder.lte
    /**
     * The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.
     */
    public val neq: List<String>? = builder.neq

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.CriterionAdditionalProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CriterionAdditionalProperties(")
        append("eq=$eq,")
        append("eqExactMatch=$eqExactMatch,")
        append("gt=$gt,")
        append("gte=$gte,")
        append("lt=$lt,")
        append("lte=$lte,")
        append("neq=$neq)")
    }

    override fun hashCode(): kotlin.Int {
        var result = eq?.hashCode() ?: 0
        result = 31 * result + (eqExactMatch?.hashCode() ?: 0)
        result = 31 * result + (gt.hashCode())
        result = 31 * result + (gte.hashCode())
        result = 31 * result + (lt.hashCode())
        result = 31 * result + (lte.hashCode())
        result = 31 * result + (neq?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CriterionAdditionalProperties

        if (eq != other.eq) return false
        if (eqExactMatch != other.eqExactMatch) return false
        if (gt != other.gt) return false
        if (gte != other.gte) return false
        if (lt != other.lt) return false
        if (lte != other.lte) return false
        if (neq != other.neq) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.CriterionAdditionalProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The value for the property matches (equals) the specified value. If you specify multiple values, Macie uses OR logic to join the values.
         */
        public var eq: List<String>? = null
        /**
         * The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
         *
         * You can use this operator with the following properties: customDataIdentifiers.detections.arn, customDataIdentifiers.detections.name, resourcesAffected.s3Bucket.tags.key, resourcesAffected.s3Bucket.tags.value, resourcesAffected.s3Object.tags.key, resourcesAffected.s3Object.tags.value, sensitiveData.category, and sensitiveData.detections.type.
         */
        public var eqExactMatch: List<String>? = null
        /**
         * The value for the property is greater than the specified value.
         */
        public var gt: kotlin.Long = 0L
        /**
         * The value for the property is greater than or equal to the specified value.
         */
        public var gte: kotlin.Long = 0L
        /**
         * The value for the property is less than the specified value.
         */
        public var lt: kotlin.Long = 0L
        /**
         * The value for the property is less than or equal to the specified value.
         */
        public var lte: kotlin.Long = 0L
        /**
         * The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Macie uses OR logic to join the values.
         */
        public var neq: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.CriterionAdditionalProperties) : this() {
            this.eq = x.eq
            this.eqExactMatch = x.eqExactMatch
            this.gt = x.gt
            this.gte = x.gte
            this.lt = x.lt
            this.lte = x.lte
            this.neq = x.neq
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.CriterionAdditionalProperties = CriterionAdditionalProperties(this)
    }
}
