// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



/**
 * Provides information about a custom data identifier that produced a sensitive data finding, and the sensitive data that it detected for the finding.
 */
public class CustomDetection private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom data identifier.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The total number of occurrences of the sensitive data that the custom data identifier detected.
     */
    public val count: kotlin.Long = builder.count
    /**
     * The name of the custom data identifier.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.
     */
    public val occurrences: aws.sdk.kotlin.services.macie2.model.Occurrences? = builder.occurrences

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.CustomDetection = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomDetection(")
        append("arn=$arn,")
        append("count=$count,")
        append("name=$name,")
        append("occurrences=$occurrences)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (count.hashCode())
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (occurrences?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomDetection

        if (arn != other.arn) return false
        if (count != other.count) return false
        if (name != other.name) return false
        if (occurrences != other.occurrences) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.CustomDetection = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom data identifier.
         */
        public var arn: kotlin.String? = null
        /**
         * The total number of occurrences of the sensitive data that the custom data identifier detected.
         */
        public var count: kotlin.Long = 0L
        /**
         * The name of the custom data identifier.
         */
        public var name: kotlin.String? = null
        /**
         * The location of 1-15 occurrences of the sensitive data that the custom data identifier detected. A finding includes location data for a maximum of 15 occurrences of sensitive data.
         */
        public var occurrences: aws.sdk.kotlin.services.macie2.model.Occurrences? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.CustomDetection) : this() {
            this.arn = x.arn
            this.count = x.count
            this.name = x.name
            this.occurrences = x.occurrences
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.CustomDetection = CustomDetection(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Occurrences] inside the given [block]
         */
        public fun occurrences(block: aws.sdk.kotlin.services.macie2.model.Occurrences.Builder.() -> kotlin.Unit) {
            this.occurrences = aws.sdk.kotlin.services.macie2.model.Occurrences.invoke(block)
        }
    }
}
