// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model



public class DeleteAllowListRequest private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Macie resource that the request applies to.
     */
    public val id: kotlin.String? = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * Specifies whether to force deletion of the allow list, even if active classification jobs are configured to use the list.
     *
     * When you try to delete an allow list, Amazon Macie checks for classification jobs that use the list and have a status other than COMPLETE or CANCELLED. By default, Macie rejects your request if any jobs meet these criteria. To skip these checks and delete the list, set this value to true. To delete the list only if no active jobs are configured to use it, set this value to false.
     */
    public val ignoreJobChecks: kotlin.String? = builder.ignoreJobChecks

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.DeleteAllowListRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteAllowListRequest(")
        append("id=$id,")
        append("ignoreJobChecks=$ignoreJobChecks)")
    }

    override fun hashCode(): kotlin.Int {
        var result = id?.hashCode() ?: 0
        result = 31 * result + (ignoreJobChecks?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteAllowListRequest

        if (id != other.id) return false
        if (ignoreJobChecks != other.ignoreJobChecks) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.DeleteAllowListRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Macie resource that the request applies to.
         */
        public var id: kotlin.String? = null
        /**
         * Specifies whether to force deletion of the allow list, even if active classification jobs are configured to use the list.
         *
         * When you try to delete an allow list, Amazon Macie checks for classification jobs that use the list and have a status other than COMPLETE or CANCELLED. By default, Macie rejects your request if any jobs meet these criteria. To skip these checks and delete the list, set this value to true. To delete the list only if no active jobs are configured to use it, set this value to false.
         */
        public var ignoreJobChecks: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.DeleteAllowListRequest) : this() {
            this.id = x.id
            this.ignoreJobChecks = x.ignoreJobChecks
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.DeleteAllowListRequest = DeleteAllowListRequest(this)
    }
}
