// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeClassificationJobResponse private constructor(builder: Builder) {
    /**
     * An array of unique identifiers, one for each allow list that the job uses when it analyzes data.
     */
    public val allowListIds: List<String>? = builder.allowListIds
    /**
     * The token that was provided to ensure the idempotency of the request to create the job.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * An array of unique identifiers, one for each custom data identifier that the job uses when it analyzes data. This value is null if the job uses only managed data identifiers to analyze data.
     */
    public val customDataIdentifierIds: List<String>? = builder.customDataIdentifierIds
    /**
     * The custom description of the job.
     */
    public val description: kotlin.String? = builder.description
    /**
     * For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects immediately after the job was created (true). If you configured the job to analyze only those objects that were created or changed after the job was created and before the job's first scheduled run, this value is false. This value is also false for a one-time job.
     */
    public val initialRun: kotlin.Boolean = builder.initialRun
    /**
     * The Amazon Resource Name (ARN) of the job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The unique identifier for the job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The current status of the job. Possible values are:
     * + CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.
     * + COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.
     * + IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.
     * + PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.
     * + RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
     * + USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
     */
    public val jobStatus: aws.sdk.kotlin.services.macie2.model.JobStatus? = builder.jobStatus
    /**
     * The schedule for running the job. Possible values are:
     * + ONE_TIME - The job runs only once.
     * + SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.
     */
    public val jobType: aws.sdk.kotlin.services.macie2.model.JobType? = builder.jobType
    /**
     * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
     */
    public val lastRunErrorStatus: aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus? = builder.lastRunErrorStatus
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started or, if the job hasn't run yet, when the job was created.
     */
    public val lastRunTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastRunTime
    /**
     * An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type specified for the job (managedDataIdentifierSelector). This value is null if the job's managed data identifier selection type is ALL or the job uses only custom data identifiers (customDataIdentifierIds) to analyze data.
     */
    public val managedDataIdentifierIds: List<String>? = builder.managedDataIdentifierIds
    /**
     * The selection type that determines which managed data identifiers the job uses to analyze data. Possible values are:
     * + ALL - Use all the managed data identifiers that Amazon Macie provides.
     * + EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.
     * + INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
     * + NONE - Don't use any managed data identifiers.
     *
     * If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.
     */
    public val managedDataIdentifierSelector: aws.sdk.kotlin.services.macie2.model.ManagedDataIdentifierSelector? = builder.managedDataIdentifierSelector
    /**
     * The custom name of the job.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
     */
    public val s3JobDefinition: aws.sdk.kotlin.services.macie2.model.S3JobDefinition? = builder.s3JobDefinition
    /**
     * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.
     */
    public val samplingPercentage: kotlin.Int = builder.samplingPercentage
    /**
     * The recurrence pattern for running the job. This value is null if the job is configured to run only once.
     */
    public val scheduleFrequency: aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency? = builder.scheduleFrequency
    /**
     * The number of times that the job has run and processing statistics for the job's current run.
     */
    public val statistics: aws.sdk.kotlin.services.macie2.model.Statistics? = builder.statistics
    /**
     * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
     */
    public val userPausedDetails: aws.sdk.kotlin.services.macie2.model.UserPausedDetails? = builder.userPausedDetails

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeClassificationJobResponse(")
        append("allowListIds=$allowListIds,")
        append("clientToken=$clientToken,")
        append("createdAt=$createdAt,")
        append("customDataIdentifierIds=$customDataIdentifierIds,")
        append("description=$description,")
        append("initialRun=$initialRun,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobStatus=$jobStatus,")
        append("jobType=$jobType,")
        append("lastRunErrorStatus=$lastRunErrorStatus,")
        append("lastRunTime=$lastRunTime,")
        append("managedDataIdentifierIds=$managedDataIdentifierIds,")
        append("managedDataIdentifierSelector=$managedDataIdentifierSelector,")
        append("name=$name,")
        append("s3JobDefinition=$s3JobDefinition,")
        append("samplingPercentage=$samplingPercentage,")
        append("scheduleFrequency=$scheduleFrequency,")
        append("statistics=$statistics,")
        append("tags=$tags,")
        append("userPausedDetails=$userPausedDetails)")
    }

    override fun hashCode(): kotlin.Int {
        var result = allowListIds?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (customDataIdentifierIds?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (initialRun.hashCode())
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobStatus?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (lastRunErrorStatus?.hashCode() ?: 0)
        result = 31 * result + (lastRunTime?.hashCode() ?: 0)
        result = 31 * result + (managedDataIdentifierIds?.hashCode() ?: 0)
        result = 31 * result + (managedDataIdentifierSelector?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3JobDefinition?.hashCode() ?: 0)
        result = 31 * result + (samplingPercentage)
        result = 31 * result + (scheduleFrequency?.hashCode() ?: 0)
        result = 31 * result + (statistics?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (userPausedDetails?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeClassificationJobResponse

        if (allowListIds != other.allowListIds) return false
        if (clientToken != other.clientToken) return false
        if (createdAt != other.createdAt) return false
        if (customDataIdentifierIds != other.customDataIdentifierIds) return false
        if (description != other.description) return false
        if (initialRun != other.initialRun) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobStatus != other.jobStatus) return false
        if (jobType != other.jobType) return false
        if (lastRunErrorStatus != other.lastRunErrorStatus) return false
        if (lastRunTime != other.lastRunTime) return false
        if (managedDataIdentifierIds != other.managedDataIdentifierIds) return false
        if (managedDataIdentifierSelector != other.managedDataIdentifierSelector) return false
        if (name != other.name) return false
        if (s3JobDefinition != other.s3JobDefinition) return false
        if (samplingPercentage != other.samplingPercentage) return false
        if (scheduleFrequency != other.scheduleFrequency) return false
        if (statistics != other.statistics) return false
        if (tags != other.tags) return false
        if (userPausedDetails != other.userPausedDetails) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of unique identifiers, one for each allow list that the job uses when it analyzes data.
         */
        public var allowListIds: List<String>? = null
        /**
         * The token that was provided to ensure the idempotency of the request to create the job.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of unique identifiers, one for each custom data identifier that the job uses when it analyzes data. This value is null if the job uses only managed data identifiers to analyze data.
         */
        public var customDataIdentifierIds: List<String>? = null
        /**
         * The custom description of the job.
         */
        public var description: kotlin.String? = null
        /**
         * For a recurring job, specifies whether you configured the job to analyze all existing, eligible objects immediately after the job was created (true). If you configured the job to analyze only those objects that were created or changed after the job was created and before the job's first scheduled run, this value is false. This value is also false for a one-time job.
         */
        public var initialRun: kotlin.Boolean = false
        /**
         * The Amazon Resource Name (ARN) of the job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The unique identifier for the job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The current status of the job. Possible values are:
         * + CANCELLED - You cancelled the job or, if it's a one-time job, you paused the job and didn't resume it within 30 days.
         * + COMPLETE - For a one-time job, Amazon Macie finished processing the data specified for the job. This value doesn't apply to recurring jobs.
         * + IDLE - For a recurring job, the previous scheduled run is complete and the next scheduled run is pending. This value doesn't apply to one-time jobs.
         * + PAUSED - Macie started running the job but additional processing would exceed the monthly sensitive data discovery quota for your account or one or more member accounts that the job analyzes data for.
         * + RUNNING - For a one-time job, the job is in progress. For a recurring job, a scheduled run is in progress.
         * + USER_PAUSED - You paused the job. If you paused the job while it had a status of RUNNING and you don't resume it within 30 days of pausing it, the job or job run will expire and be cancelled, depending on the job's type. To check the expiration date, refer to the UserPausedDetails.jobExpiresAt property.
         */
        public var jobStatus: aws.sdk.kotlin.services.macie2.model.JobStatus? = null
        /**
         * The schedule for running the job. Possible values are:
         * + ONE_TIME - The job runs only once.
         * + SCHEDULED - The job runs on a daily, weekly, or monthly basis. The scheduleFrequency property indicates the recurrence pattern for the job.
         */
        public var jobType: aws.sdk.kotlin.services.macie2.model.JobType? = null
        /**
         * Specifies whether any account- or bucket-level access errors occurred when the job ran. For a recurring job, this value indicates the error status of the job's most recent run.
         */
        public var lastRunErrorStatus: aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the job started. If the job is a recurring job, this value indicates when the most recent run started or, if the job hasn't run yet, when the job was created.
         */
        public var lastRunTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An array of unique identifiers, one for each managed data identifier that the job is explicitly configured to include (use) or exclude (not use) when it analyzes data. Inclusion or exclusion depends on the managed data identifier selection type specified for the job (managedDataIdentifierSelector). This value is null if the job's managed data identifier selection type is ALL or the job uses only custom data identifiers (customDataIdentifierIds) to analyze data.
         */
        public var managedDataIdentifierIds: List<String>? = null
        /**
         * The selection type that determines which managed data identifiers the job uses to analyze data. Possible values are:
         * + ALL - Use all the managed data identifiers that Amazon Macie provides.
         * + EXCLUDE - Use all the managed data identifiers that Macie provides except the managed data identifiers specified by the managedDataIdentifierIds property.
         * + INCLUDE - Use only the managed data identifiers specified by the managedDataIdentifierIds property.
         * + NONE - Don't use any managed data identifiers.
         *
         * If this value is null, the job uses all managed data identifiers. If this value is null, ALL, or EXCLUDE for a recurring job, the job also uses new managed data identifiers as they are released.
         */
        public var managedDataIdentifierSelector: aws.sdk.kotlin.services.macie2.model.ManagedDataIdentifierSelector? = null
        /**
         * The custom name of the job.
         */
        public var name: kotlin.String? = null
        /**
         * The S3 buckets that contain the objects to analyze, and the scope of that analysis.
         */
        public var s3JobDefinition: aws.sdk.kotlin.services.macie2.model.S3JobDefinition? = null
        /**
         * The sampling depth, as a percentage, that determines the percentage of eligible objects that the job analyzes.
         */
        public var samplingPercentage: kotlin.Int = 0
        /**
         * The recurrence pattern for running the job. This value is null if the job is configured to run only once.
         */
        public var scheduleFrequency: aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency? = null
        /**
         * The number of times that the job has run and processing statistics for the job's current run.
         */
        public var statistics: aws.sdk.kotlin.services.macie2.model.Statistics? = null
        /**
         * A map of key-value pairs that specifies which tags (keys and values) are associated with the classification job.
         */
        public var tags: Map<String, String>? = null
        /**
         * If the current status of the job is USER_PAUSED, specifies when the job was paused and when the job or job run will expire and be cancelled if it isn't resumed. This value is present only if the value for jobStatus is USER_PAUSED.
         */
        public var userPausedDetails: aws.sdk.kotlin.services.macie2.model.UserPausedDetails? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobResponse) : this() {
            this.allowListIds = x.allowListIds
            this.clientToken = x.clientToken
            this.createdAt = x.createdAt
            this.customDataIdentifierIds = x.customDataIdentifierIds
            this.description = x.description
            this.initialRun = x.initialRun
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobStatus = x.jobStatus
            this.jobType = x.jobType
            this.lastRunErrorStatus = x.lastRunErrorStatus
            this.lastRunTime = x.lastRunTime
            this.managedDataIdentifierIds = x.managedDataIdentifierIds
            this.managedDataIdentifierSelector = x.managedDataIdentifierSelector
            this.name = x.name
            this.s3JobDefinition = x.s3JobDefinition
            this.samplingPercentage = x.samplingPercentage
            this.scheduleFrequency = x.scheduleFrequency
            this.statistics = x.statistics
            this.tags = x.tags
            this.userPausedDetails = x.userPausedDetails
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.DescribeClassificationJobResponse = DescribeClassificationJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus] inside the given [block]
         */
        public fun lastRunErrorStatus(block: aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus.Builder.() -> kotlin.Unit) {
            this.lastRunErrorStatus = aws.sdk.kotlin.services.macie2.model.LastRunErrorStatus.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.S3JobDefinition] inside the given [block]
         */
        public fun s3JobDefinition(block: aws.sdk.kotlin.services.macie2.model.S3JobDefinition.Builder.() -> kotlin.Unit) {
            this.s3JobDefinition = aws.sdk.kotlin.services.macie2.model.S3JobDefinition.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency] inside the given [block]
         */
        public fun scheduleFrequency(block: aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency.Builder.() -> kotlin.Unit) {
            this.scheduleFrequency = aws.sdk.kotlin.services.macie2.model.JobScheduleFrequency.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Statistics] inside the given [block]
         */
        public fun statistics(block: aws.sdk.kotlin.services.macie2.model.Statistics.Builder.() -> kotlin.Unit) {
            this.statistics = aws.sdk.kotlin.services.macie2.model.Statistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.UserPausedDetails] inside the given [block]
         */
        public fun userPausedDetails(block: aws.sdk.kotlin.services.macie2.model.UserPausedDetails.Builder.() -> kotlin.Unit) {
            this.userPausedDetails = aws.sdk.kotlin.services.macie2.model.UserPausedDetails.invoke(block)
        }
    }
}
