// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Provides the details of a finding.
 */
public class Finding private constructor(builder: Builder) {
    /**
     * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * Specifies whether the finding is archived (suppressed).
     */
    public val archived: kotlin.Boolean = builder.archived
    /**
     * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.
     */
    public val category: aws.sdk.kotlin.services.macie2.model.FindingCategory? = builder.category
    /**
     * The details of a sensitive data finding. This value is null for a policy finding.
     */
    public val classificationDetails: aws.sdk.kotlin.services.macie2.model.ClassificationDetails? = builder.classificationDetails
    /**
     * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
     */
    public val count: kotlin.Long = builder.count
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The description of the finding.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The Amazon Web Services partition that Amazon Macie created the finding in.
     */
    public val partition: kotlin.String? = builder.partition
    /**
     * The details of a policy finding. This value is null for a sensitive data finding.
     */
    public val policyDetails: aws.sdk.kotlin.services.macie2.model.PolicyDetails? = builder.policyDetails
    /**
     * The Amazon Web Services Region that Amazon Macie created the finding in.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The resources that the finding applies to.
     */
    public val resourcesAffected: aws.sdk.kotlin.services.macie2.model.ResourcesAffected? = builder.resourcesAffected
    /**
     * Specifies whether the finding is a sample finding. A *sample finding* is a finding that uses example data to demonstrate what a finding might contain.
     */
    public val sample: kotlin.Boolean = builder.sample
    /**
     * The version of the schema that was used to define the data structures in the finding.
     */
    public val schemaVersion: kotlin.String? = builder.schemaVersion
    /**
     * The severity level and score for the finding.
     */
    public val severity: aws.sdk.kotlin.services.macie2.model.Severity? = builder.severity
    /**
     * The brief description of the finding.
     */
    public val title: kotlin.String? = builder.title
    /**
     * The type of the finding.
     */
    public val type: aws.sdk.kotlin.services.macie2.model.FindingType? = builder.type
    /**
     * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.Finding = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Finding(")
        append("accountId=$accountId,")
        append("archived=$archived,")
        append("category=$category,")
        append("classificationDetails=$classificationDetails,")
        append("count=$count,")
        append("createdAt=$createdAt,")
        append("description=$description,")
        append("id=$id,")
        append("partition=$partition,")
        append("policyDetails=$policyDetails,")
        append("region=$region,")
        append("resourcesAffected=$resourcesAffected,")
        append("sample=$sample,")
        append("schemaVersion=$schemaVersion,")
        append("severity=$severity,")
        append("title=$title,")
        append("type=$type,")
        append("updatedAt=$updatedAt)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (archived.hashCode())
        result = 31 * result + (category?.hashCode() ?: 0)
        result = 31 * result + (classificationDetails?.hashCode() ?: 0)
        result = 31 * result + (count.hashCode())
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (partition?.hashCode() ?: 0)
        result = 31 * result + (policyDetails?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (resourcesAffected?.hashCode() ?: 0)
        result = 31 * result + (sample.hashCode())
        result = 31 * result + (schemaVersion?.hashCode() ?: 0)
        result = 31 * result + (severity?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Finding

        if (accountId != other.accountId) return false
        if (archived != other.archived) return false
        if (category != other.category) return false
        if (classificationDetails != other.classificationDetails) return false
        if (count != other.count) return false
        if (createdAt != other.createdAt) return false
        if (description != other.description) return false
        if (id != other.id) return false
        if (partition != other.partition) return false
        if (policyDetails != other.policyDetails) return false
        if (region != other.region) return false
        if (resourcesAffected != other.resourcesAffected) return false
        if (sample != other.sample) return false
        if (schemaVersion != other.schemaVersion) return false
        if (severity != other.severity) return false
        if (title != other.title) return false
        if (type != other.type) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.Finding = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier for the Amazon Web Services account that the finding applies to. This is typically the account that owns the affected resource.
         */
        public var accountId: kotlin.String? = null
        /**
         * Specifies whether the finding is archived (suppressed).
         */
        public var archived: kotlin.Boolean = false
        /**
         * The category of the finding. Possible values are: CLASSIFICATION, for a sensitive data finding; and, POLICY, for a policy finding.
         */
        public var category: aws.sdk.kotlin.services.macie2.model.FindingCategory? = null
        /**
         * The details of a sensitive data finding. This value is null for a policy finding.
         */
        public var classificationDetails: aws.sdk.kotlin.services.macie2.model.ClassificationDetails? = null
        /**
         * The total number of occurrences of the finding. For sensitive data findings, this value is always 1. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         */
        public var count: kotlin.Long = 0L
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the finding was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The description of the finding.
         */
        public var description: kotlin.String? = null
        /**
         * The unique identifier for the finding. This is a random string that Amazon Macie generates and assigns to a finding when it creates the finding.
         */
        public var id: kotlin.String? = null
        /**
         * The Amazon Web Services partition that Amazon Macie created the finding in.
         */
        public var partition: kotlin.String? = null
        /**
         * The details of a policy finding. This value is null for a sensitive data finding.
         */
        public var policyDetails: aws.sdk.kotlin.services.macie2.model.PolicyDetails? = null
        /**
         * The Amazon Web Services Region that Amazon Macie created the finding in.
         */
        public var region: kotlin.String? = null
        /**
         * The resources that the finding applies to.
         */
        public var resourcesAffected: aws.sdk.kotlin.services.macie2.model.ResourcesAffected? = null
        /**
         * Specifies whether the finding is a sample finding. A *sample finding* is a finding that uses example data to demonstrate what a finding might contain.
         */
        public var sample: kotlin.Boolean = false
        /**
         * The version of the schema that was used to define the data structures in the finding.
         */
        public var schemaVersion: kotlin.String? = null
        /**
         * The severity level and score for the finding.
         */
        public var severity: aws.sdk.kotlin.services.macie2.model.Severity? = null
        /**
         * The brief description of the finding.
         */
        public var title: kotlin.String? = null
        /**
         * The type of the finding.
         */
        public var type: aws.sdk.kotlin.services.macie2.model.FindingType? = null
        /**
         * The date and time, in UTC and extended ISO 8601 format, when the finding was last updated. For sensitive data findings, this value is the same as the value for the createdAt property. All sensitive data findings are considered new (unique) because they derive from individual classification jobs.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.Finding) : this() {
            this.accountId = x.accountId
            this.archived = x.archived
            this.category = x.category
            this.classificationDetails = x.classificationDetails
            this.count = x.count
            this.createdAt = x.createdAt
            this.description = x.description
            this.id = x.id
            this.partition = x.partition
            this.policyDetails = x.policyDetails
            this.region = x.region
            this.resourcesAffected = x.resourcesAffected
            this.sample = x.sample
            this.schemaVersion = x.schemaVersion
            this.severity = x.severity
            this.title = x.title
            this.type = x.type
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.Finding = Finding(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ClassificationDetails] inside the given [block]
         */
        public fun classificationDetails(block: aws.sdk.kotlin.services.macie2.model.ClassificationDetails.Builder.() -> kotlin.Unit) {
            this.classificationDetails = aws.sdk.kotlin.services.macie2.model.ClassificationDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.PolicyDetails] inside the given [block]
         */
        public fun policyDetails(block: aws.sdk.kotlin.services.macie2.model.PolicyDetails.Builder.() -> kotlin.Unit) {
            this.policyDetails = aws.sdk.kotlin.services.macie2.model.PolicyDetails.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ResourcesAffected] inside the given [block]
         */
        public fun resourcesAffected(block: aws.sdk.kotlin.services.macie2.model.ResourcesAffected.Builder.() -> kotlin.Unit) {
            this.resourcesAffected = aws.sdk.kotlin.services.macie2.model.ResourcesAffected.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.Severity] inside the given [block]
         */
        public fun severity(block: aws.sdk.kotlin.services.macie2.model.Severity.Builder.() -> kotlin.Unit) {
            this.severity = aws.sdk.kotlin.services.macie2.model.Severity.invoke(block)
        }
    }
}
