// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.macie2.model

import aws.smithy.kotlin.runtime.time.Instant

public class GetBucketStatisticsResponse private constructor(builder: Builder) {
    /**
     * The total number of buckets.
     */
    public val bucketCount: kotlin.Long = builder.bucketCount
    /**
     * The total number of buckets that are publicly accessible based on a combination of permissions settings for each bucket.
     */
    public val bucketCountByEffectivePermission: aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission? = builder.bucketCountByEffectivePermission
    /**
     * The total number of buckets that use certain types of server-side encryption to encrypt new objects by default. This object also reports the total number of buckets that don't encrypt new objects by default.
     */
    public val bucketCountByEncryptionType: aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType? = builder.bucketCountByEncryptionType
    /**
     * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
     */
    public val bucketCountByObjectEncryptionRequirement: aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads? = builder.bucketCountByObjectEncryptionRequirement
    /**
     * The total number of buckets that are or aren't shared with another Amazon Web Services account.
     */
    public val bucketCountBySharedAccessType: aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType? = builder.bucketCountBySharedAccessType
    /**
     * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     */
    public val classifiableObjectCount: kotlin.Long = builder.classifiableObjectCount
    /**
     * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
     *
     * If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of all applicable objects in the buckets.
     */
    public val classifiableSizeInBytes: kotlin.Long = builder.classifiableSizeInBytes
    /**
     * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the buckets.
     */
    public val lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdated
    /**
     * The total number of objects in the buckets.
     */
    public val objectCount: kotlin.Long = builder.objectCount
    /**
     * The total storage size, in bytes, of the buckets.
     *
     * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.
     */
    public val sizeInBytes: kotlin.Long = builder.sizeInBytes
    /**
     * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets.
     *
     * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of the applicable objects in the buckets.
     */
    public val sizeInBytesCompressed: kotlin.Long = builder.sizeInBytesCompressed
    /**
     * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val unclassifiableObjectCount: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = builder.unclassifiableObjectCount
    /**
     * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
     */
    public val unclassifiableObjectSizeInBytes: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = builder.unclassifiableObjectSizeInBytes

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBucketStatisticsResponse(")
        append("bucketCount=$bucketCount,")
        append("bucketCountByEffectivePermission=$bucketCountByEffectivePermission,")
        append("bucketCountByEncryptionType=$bucketCountByEncryptionType,")
        append("bucketCountByObjectEncryptionRequirement=$bucketCountByObjectEncryptionRequirement,")
        append("bucketCountBySharedAccessType=$bucketCountBySharedAccessType,")
        append("classifiableObjectCount=$classifiableObjectCount,")
        append("classifiableSizeInBytes=$classifiableSizeInBytes,")
        append("lastUpdated=$lastUpdated,")
        append("objectCount=$objectCount,")
        append("sizeInBytes=$sizeInBytes,")
        append("sizeInBytesCompressed=$sizeInBytesCompressed,")
        append("unclassifiableObjectCount=$unclassifiableObjectCount,")
        append("unclassifiableObjectSizeInBytes=$unclassifiableObjectSizeInBytes)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketCount.hashCode()
        result = 31 * result + (bucketCountByEffectivePermission?.hashCode() ?: 0)
        result = 31 * result + (bucketCountByEncryptionType?.hashCode() ?: 0)
        result = 31 * result + (bucketCountByObjectEncryptionRequirement?.hashCode() ?: 0)
        result = 31 * result + (bucketCountBySharedAccessType?.hashCode() ?: 0)
        result = 31 * result + (classifiableObjectCount.hashCode())
        result = 31 * result + (classifiableSizeInBytes.hashCode())
        result = 31 * result + (lastUpdated?.hashCode() ?: 0)
        result = 31 * result + (objectCount.hashCode())
        result = 31 * result + (sizeInBytes.hashCode())
        result = 31 * result + (sizeInBytesCompressed.hashCode())
        result = 31 * result + (unclassifiableObjectCount?.hashCode() ?: 0)
        result = 31 * result + (unclassifiableObjectSizeInBytes?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBucketStatisticsResponse

        if (bucketCount != other.bucketCount) return false
        if (bucketCountByEffectivePermission != other.bucketCountByEffectivePermission) return false
        if (bucketCountByEncryptionType != other.bucketCountByEncryptionType) return false
        if (bucketCountByObjectEncryptionRequirement != other.bucketCountByObjectEncryptionRequirement) return false
        if (bucketCountBySharedAccessType != other.bucketCountBySharedAccessType) return false
        if (classifiableObjectCount != other.classifiableObjectCount) return false
        if (classifiableSizeInBytes != other.classifiableSizeInBytes) return false
        if (lastUpdated != other.lastUpdated) return false
        if (objectCount != other.objectCount) return false
        if (sizeInBytes != other.sizeInBytes) return false
        if (sizeInBytesCompressed != other.sizeInBytesCompressed) return false
        if (unclassifiableObjectCount != other.unclassifiableObjectCount) return false
        if (unclassifiableObjectSizeInBytes != other.unclassifiableObjectSizeInBytes) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The total number of buckets.
         */
        public var bucketCount: kotlin.Long = 0L
        /**
         * The total number of buckets that are publicly accessible based on a combination of permissions settings for each bucket.
         */
        public var bucketCountByEffectivePermission: aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission? = null
        /**
         * The total number of buckets that use certain types of server-side encryption to encrypt new objects by default. This object also reports the total number of buckets that don't encrypt new objects by default.
         */
        public var bucketCountByEncryptionType: aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType? = null
        /**
         * The total number of buckets whose bucket policies do or don't require server-side encryption of objects when objects are uploaded to the buckets.
         */
        public var bucketCountByObjectEncryptionRequirement: aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads? = null
        /**
         * The total number of buckets that are or aren't shared with another Amazon Web Services account.
         */
        public var bucketCountBySharedAccessType: aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType? = null
        /**
         * The total number of objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         */
        public var classifiableObjectCount: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of all the objects that Amazon Macie can analyze in the buckets. These objects use a supported storage class and have a file name extension for a supported file or storage format.
         *
         * If versioning is enabled for any of the buckets, Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of all applicable objects in the buckets.
         */
        public var classifiableSizeInBytes: kotlin.Long = 0L
        /**
         * The date and time, in UTC and extended ISO 8601 format, when Amazon Macie most recently retrieved both bucket and object metadata from Amazon S3 for the buckets.
         */
        public var lastUpdated: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The total number of objects in the buckets.
         */
        public var objectCount: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of the buckets.
         *
         * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the latest version of each object in those buckets. This value doesn't reflect the storage size of all versions of the objects in the buckets.
         */
        public var sizeInBytes: kotlin.Long = 0L
        /**
         * The total storage size, in bytes, of the objects that are compressed (.gz, .gzip, .zip) files in the buckets.
         *
         * If versioning is enabled for any of the buckets, Amazon Macie calculates this value based on the size of the latest version of each applicable object in those buckets. This value doesn't reflect the storage size of all versions of the applicable objects in the buckets.
         */
        public var sizeInBytesCompressed: kotlin.Long = 0L
        /**
         * The total number of objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var unclassifiableObjectCount: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = null
        /**
         * The total storage size, in bytes, of the objects that Amazon Macie can't analyze in the buckets. These objects don't use a supported storage class or don't have a file name extension for a supported file or storage format.
         */
        public var unclassifiableObjectSizeInBytes: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsResponse) : this() {
            this.bucketCount = x.bucketCount
            this.bucketCountByEffectivePermission = x.bucketCountByEffectivePermission
            this.bucketCountByEncryptionType = x.bucketCountByEncryptionType
            this.bucketCountByObjectEncryptionRequirement = x.bucketCountByObjectEncryptionRequirement
            this.bucketCountBySharedAccessType = x.bucketCountBySharedAccessType
            this.classifiableObjectCount = x.classifiableObjectCount
            this.classifiableSizeInBytes = x.classifiableSizeInBytes
            this.lastUpdated = x.lastUpdated
            this.objectCount = x.objectCount
            this.sizeInBytes = x.sizeInBytes
            this.sizeInBytesCompressed = x.sizeInBytesCompressed
            this.unclassifiableObjectCount = x.unclassifiableObjectCount
            this.unclassifiableObjectSizeInBytes = x.unclassifiableObjectSizeInBytes
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.macie2.model.GetBucketStatisticsResponse = GetBucketStatisticsResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission] inside the given [block]
         */
        public fun bucketCountByEffectivePermission(block: aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission.Builder.() -> kotlin.Unit) {
            this.bucketCountByEffectivePermission = aws.sdk.kotlin.services.macie2.model.BucketCountByEffectivePermission.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType] inside the given [block]
         */
        public fun bucketCountByEncryptionType(block: aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType.Builder.() -> kotlin.Unit) {
            this.bucketCountByEncryptionType = aws.sdk.kotlin.services.macie2.model.BucketCountByEncryptionType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads] inside the given [block]
         */
        public fun bucketCountByObjectEncryptionRequirement(block: aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.Builder.() -> kotlin.Unit) {
            this.bucketCountByObjectEncryptionRequirement = aws.sdk.kotlin.services.macie2.model.BucketCountPolicyAllowsUnencryptedObjectUploads.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType] inside the given [block]
         */
        public fun bucketCountBySharedAccessType(block: aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType.Builder.() -> kotlin.Unit) {
            this.bucketCountBySharedAccessType = aws.sdk.kotlin.services.macie2.model.BucketCountBySharedAccessType.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        public fun unclassifiableObjectCount(block: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.Builder.() -> kotlin.Unit) {
            this.unclassifiableObjectCount = aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics] inside the given [block]
         */
        public fun unclassifiableObjectSizeInBytes(block: aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.Builder.() -> kotlin.Unit) {
            this.unclassifiableObjectSizeInBytes = aws.sdk.kotlin.services.macie2.model.ObjectLevelStatistics.invoke(block)
        }
    }
}
